/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.impl;

import java.util.Iterator;
import java.util.function.BiFunction;
import kd.fi.v2.fah.constant.enums.NotNull;
import kd.fi.v2.fah.storage.impl.CacheableMutableArrayStorage;
import kd.fi.v2.fah.storage.tables.enums.MemTableStorageTypeEnum;
import kd.fi.v2.fah.storage.tables.impl.AbstractSimpleTableStorage;

public abstract class AbstractSimpleTableRowStorage<ROW>
extends AbstractSimpleTableStorage<CacheableMutableArrayStorage<ROW>> {
    public AbstractSimpleTableRowStorage(int columnCnt, int maxRowCnt, int[] pkColumnIdx) {
        super(columnCnt, maxRowCnt, pkColumnIdx);
    }

    public AbstractSimpleTableRowStorage(int columnCnt, int maxRowCnt) {
        super(columnCnt, maxRowCnt);
    }

    public AbstractSimpleTableRowStorage(int columnCnt) {
        super(columnCnt);
    }

    public AbstractSimpleTableRowStorage() {
    }

    @Override
    public MemTableStorageTypeEnum getTableStorageType() {
        return MemTableStorageTypeEnum.Row_Raw_Table;
    }

    @Override
    protected CacheableMutableArrayStorage<ROW> __createStorage(int maxRowCnt) {
        return new CacheableMutableArrayStorage<Object[]>(maxRowCnt, Object[].class);
    }

    protected int __storage_forEach_row(BiFunction<Integer, ROW, Boolean> valueConsumer) {
        return ((CacheableMutableArrayStorage)this.storage).forEach((row, idx) -> (Boolean)valueConsumer.apply((Integer)row, (Object)idx));
    }

    protected abstract ROW wrapRowData(Object[] var1);

    protected abstract Object[] getRowDataValue(ROW var1);

    protected abstract Object getRowCellValue(ROW var1, int var2);

    protected abstract boolean setRowCellValue(ROW var1, int var2, Object var3);

    protected abstract boolean appendRowColumn(ROW var1, int var2, Object var3, int var4);

    protected abstract boolean removeRowColumns(int var1, ROW var2, int var3, int var4, int var5, int var6, int var7, Object[][] var8);

    @Override
    protected void __storage_insert_new_row(Object[] newRowData, boolean addToCache) {
        if (addToCache) {
            ((CacheableMutableArrayStorage)this.storage).cache(this.wrapRowData(newRowData));
        } else {
            ((CacheableMutableArrayStorage)this.storage).addEx(this.wrapRowData(newRowData));
        }
    }

    @Override
    protected void __storage_set_row(int rowIdx, Object[] newRowData) {
        ((CacheableMutableArrayStorage)this.storage).set(rowIdx, this.wrapRowData(newRowData));
    }

    @Override
    protected boolean __storage_flush() {
        return ((CacheableMutableArrayStorage)this.storage).flush();
    }

    @Override
    protected void __storage_clear() {
        ((CacheableMutableArrayStorage)this.storage).clear();
    }

    @Override
    protected boolean __storage_clear_cache() {
        return ((CacheableMutableArrayStorage)this.storage).clearCache();
    }

    @Override
    public int addEmptyRow() {
        if (this.columnCnt > 0) {
            ((CacheableMutableArrayStorage)this.storage).add(this.wrapRowData(new Object[this.columnCnt]));
            ++this.rowCnt;
        }
        return this.getRowCnt();
    }

    @Override
    public void clear(int startColumnIdx, int endColumnIdx) {
        int start = Math.max(startColumnIdx, 0);
        int end = Math.min(Math.max(endColumnIdx, 0), this.columnCnt - 1);
        if (endColumnIdx >= startColumnIdx) {
            for (int rowIdx = 0; rowIdx < this.rowCnt; ++rowIdx) {
                for (int i = start; i <= end; ++i) {
                    this.setCellValue(rowIdx, i, null);
                }
            }
        }
    }

    @Override
    public int addColumn(Object initValue) {
        return this.addColumns(1, initValue);
    }

    @Override
    public int addColumns(int addColumnCnt, Object initValue) {
        if (addColumnCnt <= 0) {
            return -1;
        }
        int newColumnSize = this.columnCnt + addColumnCnt - 1;
        this.__storage_forEach_row((idx, row) -> this.appendRowColumn(row, addColumnCnt, initValue, newColumnSize));
        this.columnCnt = newColumnSize;
        return this.columnCnt;
    }

    @Override
    public Object[] removeColumn(int columnIdx) {
        Object[][] resultBuf = this.removeColumns(columnIdx, columnIdx);
        return resultBuf == null ? Empty_DataRow : resultBuf[0];
    }

    @Override
    public Object[][] removeColumns(int startColumnIdx, int endColumnIdx) {
        Object[][] removedResult;
        if (endColumnIdx <= 0) {
            return Empty_Removed_Columns;
        }
        int removeColumnCnt = Math.min(endColumnIdx + 1, this.columnCnt) - startColumnIdx;
        if (this.rowCnt <= 0) {
            removedResult = Empty_Removed_Columns;
        } else {
            removedResult = new Object[removeColumnCnt][this.rowCnt];
            int newColumnCnt = this.columnCnt - removeColumnCnt;
            int removeType = endColumnIdx >= this.columnCnt - 1 ? 2 : (startColumnIdx > 0 ? 1 : 0);
            this.__storage_forEach_row((idx, row) -> this.removeRowColumns((int)idx, (ROW)row, startColumnIdx, endColumnIdx, newColumnCnt, removeColumnCnt, removeType, removedResult));
        }
        this.columnCnt -= removeColumnCnt;
        return removedResult;
    }

    protected Object[][] getColumnValues(int startColumnIdx, int columnCnt) {
        Object[][] result = new Object[columnCnt][this.rowCnt];
        int[] selectColumnIdx = new int[columnCnt];
        for (int i = 0; i < columnCnt; ++i) {
            selectColumnIdx[i] = startColumnIdx + i;
        }
        Iterator<Object[]> delColumnIterator = this.getSelectColumnValues(selectColumnIdx, true);
        int rowIdx = 0;
        while (delColumnIterator.hasNext()) {
            Object[] removedBuf = delColumnIterator.next();
            for (int delColIdx = 0; delColIdx < columnCnt; ++delColIdx) {
                result[delColIdx][rowIdx] = removedBuf[delColIdx];
            }
        }
        return result;
    }

    @Override
    public <T> T getCellValue(int rowIdx, int columnIdx) {
        return (T)this.getRowCellValue(((CacheableMutableArrayStorage)this.storage).get(rowIdx), columnIdx);
    }

    @Override
    public void setCellValue(int rowIdx, int columnIdx, Object value) {
        this.setRowCellValue(((CacheableMutableArrayStorage)this.storage).get(rowIdx), columnIdx, value);
    }

    @Override
    public void setColumn(int columnIdx, Object[] values) {
        for (int rowIdx = 0; rowIdx < this.rowCnt; ++rowIdx) {
            this.setRowCellValue(((CacheableMutableArrayStorage)this.storage).get(rowIdx), columnIdx, values[rowIdx]);
        }
    }

    @Override
    public Object[] fetchRowValueCopy(int rowIdx, @NotNull Object[] outputBuffer, @NotNull int[] selectColumns) {
        if (rowIdx < 0 || rowIdx >= this.rowCnt) {
            return Empty_DataRow;
        }
        int i = 0;
        Object[] rowBuf = this.getRowDataValue(((CacheableMutableArrayStorage)this.storage).get(rowIdx));
        for (int col : selectColumns) {
            outputBuffer[i++] = rowBuf[col];
        }
        return outputBuffer;
    }

    @Override
    public Object[] fetchRowValueCopy(int rowIdx, @NotNull Object[] outputBuffer) {
        if (rowIdx < 0 || rowIdx >= this.rowCnt) {
            return Empty_DataRow;
        }
        System.arraycopy(((CacheableMutableArrayStorage)this.storage).get(rowIdx), 0, outputBuffer, 0, this.columnCnt);
        return outputBuffer;
    }

    @Override
    public Object[] getColumnValues(int columnIdx) {
        if (columnIdx < 0 || columnIdx >= this.columnCnt) {
            return Empty_DataRow;
        }
        Object[] result = new Object[this.rowCnt];
        for (int i = 0; i < this.rowCnt; ++i) {
            result[i] = this.getRowCellValue(((CacheableMutableArrayStorage)this.storage).get(i), columnIdx);
        }
        return result;
    }
}

