/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;

public abstract class AbstractSimpleTableStorage<STORAGE>
implements IDataTableStorage,
IDataItemKey<String> {
    protected static final Object[] Empty_DataRow = new Object[0];
    protected static final Object[][] Empty_Removed_Columns = new Object[0][];
    protected String tableKey;
    protected int columnCnt;
    protected int rowCnt;
    protected int cacheRowCnt;
    protected int maxRowCnt;
    protected int[] pkColumnIdx;
    protected transient Map<List<Object>, Integer> pkIndex;
    protected transient boolean enablePk;
    protected STORAGE storage;

    protected AbstractSimpleTableStorage(int columnCnt, int maxRowCnt, int[] pkColumnIdx) {
        this.resetTable(columnCnt, maxRowCnt, pkColumnIdx);
    }

    protected AbstractSimpleTableStorage(int columnCnt, int maxRowCnt) {
        this(columnCnt, maxRowCnt, null);
    }

    protected AbstractSimpleTableStorage(int columnCnt) {
        this(columnCnt, -1, null);
    }

    protected AbstractSimpleTableStorage() {
        this(0, -1, null);
    }

    protected abstract STORAGE __createStorage(int var1);

    protected abstract void __storage_insert_new_row(Object[] var1, boolean var2);

    protected abstract void __storage_set_row(int var1, Object[] var2);

    protected abstract boolean __storage_flush();

    protected abstract void __storage_clear();

    protected abstract boolean __storage_clear_cache();

    @Override
    public void resetTable(int columnCnt, int maxRowCnt, int[] pkColumnIdx) {
        this.columnCnt = Math.max(0, columnCnt);
        this.rowCnt = 0;
        this.cacheRowCnt = 0;
        this.maxRowCnt = maxRowCnt;
        this.storage = this.__createStorage(Math.max(0, this.maxRowCnt));
        this.enablePk = false;
        this.setPkColumnIdx(pkColumnIdx);
    }

    public abstract int addEmptyRow();

    @Override
    public int addEx(Object[] value) {
        if (value == null) {
            return this.addEmptyRow();
        }
        return this.insertRowData(value, true, false);
    }

    @Override
    public int batchAdd(Collection<Object[]> datas) {
        if (datas == null || datas.isEmpty()) {
            return this.addEmptyRow();
        }
        int resultIdx = -1;
        for (Object[] srcRow : datas) {
            resultIdx = this.insertRowData(srcRow, true, false);
        }
        return resultIdx;
    }

    @Override
    public int insertRowData(Object[] newRowDatas, boolean autoExpandColumn, boolean addToCache) {
        if (newRowDatas == null || newRowDatas.length == 0) {
            return -1;
        }
        int srcDataLength = newRowDatas.length;
        if (srcDataLength > this.columnCnt) {
            if (autoExpandColumn) {
                this.addColumns(srcDataLength - this.columnCnt, null);
            } else if (this.columnCnt <= 0) {
                return -1;
            }
        } else if (srcDataLength < this.columnCnt) {
            newRowDatas = Arrays.copyOf(newRowDatas, this.columnCnt);
        }
        if (this.enablePk) {
            Object[] pkBuf = new Object[this.pkColumnIdx.length];
            int i = 0;
            for (int col : this.pkColumnIdx) {
                pkBuf[i++] = newRowDatas[col];
            }
            List<Object> pks = Arrays.asList(pkBuf);
            if (this.pkIndex.containsKey(pks)) {
                return -99;
            }
            this.pkIndex.put(pks, this.rowCnt);
        }
        int result = this.cacheRowCnt + this.rowCnt;
        if (addToCache) {
            this.__storage_insert_new_row(newRowDatas, true);
            ++this.cacheRowCnt;
        } else {
            this.__storage_insert_new_row(newRowDatas, false);
            ++this.rowCnt;
        }
        return result;
    }

    @Override
    public boolean flush() {
        if (this.storage == null) {
            return false;
        }
        this.__storage_flush();
        this.rowCnt += this.cacheRowCnt;
        this.cacheRowCnt = 0;
        return true;
    }

    @Override
    public void clear() {
        if (this.storage != null) {
            this.__storage_clear();
        }
        this.clearCache();
        if (this.pkIndex != null) {
            this.pkIndex.clear();
        }
        this.rowCnt = 0;
    }

    @Override
    public int getRowIndexBySinglePK(Object pk) {
        if (!this.enablePk || pk == null || this.pkColumnIdx.length != 1) {
            return -1;
        }
        return this.pkIndex != null ? this.pkIndex.get(Collections.singletonList(pk)) : -1;
    }

    @Override
    public int getRowIndexByPK(List<Object> pks) {
        if (!this.enablePk) {
            return -1;
        }
        return this.pkIndex != null ? this.pkIndex.get(pks) : -1;
    }

    @Override
    public int getRowIndexByPK(Object[] pks) {
        if (!this.enablePk || pks == null) {
            return -1;
        }
        return this.pkIndex != null ? this.pkIndex.get(Arrays.asList(pks)) : -1;
    }

    @Override
    public Object[] get(int rowIdx) {
        return this.fetchRowValueCopy(rowIdx, new Object[this.columnCnt]);
    }

    protected abstract Object[] getColumnValues(int var1);

    @Override
    public boolean compareColumnValues(int rowIndex, int[] columnIdxs, Object[] compareTarget) {
        if (rowIndex >= this.rowCnt || columnIdxs == null || columnIdxs.length == 0 || compareTarget == null || compareTarget.length != columnIdxs.length) {
            return false;
        }
        Object[] rowBuf = this.get(rowIndex);
        int i = 0;
        for (int colIdx : columnIdxs) {
            if (ICommonDataValueUtil.deepEquals(rowBuf[colIdx], compareTarget[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] getSelectColumnValues(int rowIndex, int[] columnIdxs) {
        if (rowIndex >= this.rowCnt || columnIdxs == null || columnIdxs.length == 0) {
            return new Object[0];
        }
        Object[] rowBuf = this.get(rowIndex);
        Object[] result = new Object[columnIdxs.length];
        int i = 0;
        for (int colIdx : columnIdxs) {
            result[i++] = rowBuf[colIdx];
        }
        return result;
    }

    @Override
    public Iterator<Object[]> iterator() {
        if (this.columnCnt <= 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        int[] columnIndexs = new int[this.columnCnt];
        for (int i = 0; i < this.columnCnt; ++i) {
            columnIndexs[i] = i;
        }
        return this.getSelectColumnValues(columnIndexs, true);
    }

    @Override
    public Iterator<Object[]> getSelectColumnValues(final int[] columnIdxs, final boolean duplicateCopy) {
        if (this.rowCnt <= 0 || columnIdxs == null || columnIdxs.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new Iterator<Object[]>(){
            int currentRowIdx = 0;
            final int selectColumnCnt = columnIdxs.length;
            Object[] resultBuffer = duplicateCopy ? null : new Object[this.selectColumnCnt];

            @Override
            public boolean hasNext() {
                return this.currentRowIdx < AbstractSimpleTableStorage.this.rowCnt;
            }

            @Override
            public Object[] next() {
                if (this.hasNext()) {
                    if (duplicateCopy) {
                        this.resultBuffer = new Object[this.selectColumnCnt];
                    }
                    Object[] rowBuf = AbstractSimpleTableStorage.this.get(this.currentRowIdx);
                    int i = 0;
                    for (int colIdx : columnIdxs) {
                        this.resultBuffer[i++] = rowBuf[colIdx];
                    }
                    ++this.currentRowIdx;
                }
                return this.resultBuffer;
            }
        };
    }

    @Override
    public Set<Object> getDistinctColumnValues(int columnIdx) {
        if (this.columnCnt <= 0 || this.rowCnt <= 0) {
            return Collections.EMPTY_SET;
        }
        Object[] vals = this.getColumnValues(columnIdx);
        return vals != null && vals.length > 0 ? new HashSet<Object>(Arrays.asList(vals)) : Collections.EMPTY_SET;
    }

    @Override
    public Set<List<Object>> getDistinctColumnValues(int[] columnIdxs) {
        if (this.columnCnt <= 0 || this.rowCnt <= 0 || columnIdxs == null || columnIdxs.length <= 0) {
            return Collections.EMPTY_SET;
        }
        int selectColCnt = columnIdxs.length;
        LinkedList<List<Object>> cacheList = new LinkedList<List<Object>>();
        for (int rowIdx = 0; rowIdx < this.rowCnt; ++rowIdx) {
            cacheList.add(Arrays.asList(this.fetchRowValueCopy(rowIdx, new Object[selectColCnt], columnIdxs)));
        }
        return new HashSet<List<Object>>(cacheList);
    }

    @Override
    public Map<List<Object>, List<Integer>> rebuildUniqueIndex(int[] uniqueIdxCols, Map<List<Object>, Integer> outputIndexMap) {
        if (outputIndexMap == null) {
            throw new IllegalArgumentException("Target Output Index Map cannot be Null!");
        }
        if (uniqueIdxCols == null || uniqueIdxCols.length <= 0 || this.columnCnt <= 0 || this.rowCnt <= 0) {
            return Collections.emptyMap();
        }
        HashMap<List<Object>, List<Integer>> errorMap = new HashMap<List<Object>, List<Integer>>(8);
        int selectColCnt = uniqueIdxCols.length;
        for (int rowIdx = 0; rowIdx < this.rowCnt; ++rowIdx) {
            List<Object> keyBuf = Arrays.asList(this.fetchRowValueCopy(rowIdx, new Object[selectColCnt], uniqueIdxCols));
            Integer existingRowIdx = outputIndexMap.get(keyBuf);
            if (existingRowIdx != null) {
                List rowIdxs = errorMap.computeIfAbsent(keyBuf, v -> new LinkedList());
                if (rowIdxs.isEmpty()) {
                    rowIdxs.add(existingRowIdx);
                }
                rowIdxs.add(rowIdx);
                continue;
            }
            outputIndexMap.put(keyBuf, rowIdx);
        }
        return errorMap;
    }

    @Override
    public Map<List<Object>, List<Integer>> rebuildPKIndex() {
        if (this.rowCnt <= 0 || this.columnCnt <= 0 || this.pkColumnIdx == null || this.pkColumnIdx.length <= 0) {
            return Collections.emptyMap();
        }
        if (this.pkIndex == null) {
            this.pkIndex = new HashMap<List<Object>, Integer>(this.rowCnt);
        }
        return this.rebuildUniqueIndex(this.pkColumnIdx, this.pkIndex);
    }

    @Override
    public int getColumnCnt() {
        return this.columnCnt;
    }

    public void setColumnCnt(int columnCnt) {
        if (columnCnt <= 0) {
            this.clear();
        } else if (this.columnCnt > columnCnt) {
            this.removeColumns(this.columnCnt - columnCnt, this.columnCnt - 1);
        } else if (this.columnCnt < columnCnt) {
            this.addColumns(columnCnt - this.columnCnt, null);
        }
    }

    @Override
    public int getRowCnt() {
        return this.rowCnt + this.cacheRowCnt;
    }

    public int getMaxRowCnt() {
        return this.maxRowCnt;
    }

    public void setMaxRowCnt(int maxRowCnt) {
        this.maxRowCnt = maxRowCnt;
    }

    public int[] getPkColumnIdx() {
        return this.pkColumnIdx;
    }

    public void setPkColumnIdx(int[] pkColumnIdx) {
        boolean needClearPkIdx;
        boolean bl = needClearPkIdx = this.pkIndex != null;
        if (pkColumnIdx == null || pkColumnIdx.length == 0) {
            this.enablePk = false;
        } else {
            this.enablePk = true;
            if (needClearPkIdx) {
                boolean bl2 = needClearPkIdx = !ICommonDataValueUtil.deepEquals(this.pkIndex, pkColumnIdx);
            }
        }
        if (needClearPkIdx) {
            this.pkIndex.clear();
        } else if (this.enablePk) {
            this.pkIndex = new HashMap<List<Object>, Integer>(Math.max(this.maxRowCnt, 64));
        }
        this.pkColumnIdx = pkColumnIdx;
    }

    public boolean isEnablePk() {
        return this.enablePk;
    }

    public Object[][] getValues() {
        if (this.rowCnt <= 0) {
            return new Object[0][];
        }
        Object[][] result = new Object[this.rowCnt][];
        for (int rowIdx = 0; rowIdx < this.rowCnt; ++rowIdx) {
            result[rowIdx] = this.fetchRowValueCopy(rowIdx, new Object[this.columnCnt]);
        }
        return result;
    }

    @Override
    public int size() {
        return this.rowCnt;
    }

    @Override
    public boolean isEmpty() {
        return this.rowCnt <= 0;
    }

    protected Object[] getPKValueByRowIndex(int rowIndex) {
        return this.enablePk && this.rowCnt > rowIndex ? this.getSelectColumnValues(rowIndex, this.pkColumnIdx) : null;
    }

    @Override
    public Object[] set(int rowIndex, Object[] newRowDatas) {
        if (rowIndex >= this.rowCnt) {
            throw new IllegalArgumentException(String.format("Index:%d > Row Count:%d", rowIndex, this.rowCnt - 1));
        }
        Object[] result = newRowDatas;
        if (newRowDatas == null) {
            Object[] oldRow;
            if (this.enablePk && (oldRow = this.getSelectColumnValues(rowIndex, this.pkColumnIdx)) != null) {
                this.pkIndex.remove(Arrays.asList(oldRow));
            }
            this.__storage_set_row(rowIndex, null);
        } else {
            int srcDataLength = newRowDatas.length;
            List<Object> pks = null;
            if (this.enablePk) {
                Object[] pkBuf = new Object[this.pkColumnIdx.length];
                int i = 0;
                for (int col : this.pkColumnIdx) {
                    pkBuf[i++] = newRowDatas[col];
                }
                if (!this.compareColumnValues(rowIndex, this.pkColumnIdx, pkBuf)) {
                    pks = Arrays.asList(pkBuf);
                    int existPk = this.pkIndex.getOrDefault(pks, -1);
                    if (existPk >= 0) {
                        throw new IllegalArgumentException(String.format("Duplicate PK:%s Found on row:[%d]", pks, existPk));
                    }
                } else {
                    List<Object> existPkValue = Arrays.asList(this.getSelectColumnValues(rowIndex, this.pkColumnIdx));
                    if (this.pkIndex.remove(existPkValue) == null) {
                        throw new RuntimeException(String.format(" Failed to remove existing PK:%s on row:[%d]", existPkValue, rowIndex));
                    }
                    this.pkIndex.put(pks, rowIndex);
                }
            }
            if (srcDataLength == this.columnCnt) {
                this.__storage_set_row(rowIndex, result);
            } else {
                result = Arrays.copyOf(newRowDatas, this.columnCnt);
                this.__storage_set_row(rowIndex, result);
            }
        }
        return result;
    }

    @Override
    public int migrateTableColumns(IDataTableStorage srcTable, Integer[][] colReadWritePos) {
        throw new UnsupportedOperationException("Not support Migrate Table by default!");
    }

    @Override
    public int cache(Object[] value) {
        return this.insertRowData(value, true, true);
    }

    public int cacheRowData(Object[] value, boolean autoExpandColumn) {
        return this.insertRowData(value, true, true);
    }

    @Override
    public int cachedSize() {
        return this.cacheRowCnt;
    }

    @Override
    public boolean clearCache() {
        this.cacheRowCnt = 0;
        if (this.storage != null) {
            return this.__storage_clear_cache();
        }
        return false;
    }

    @Override
    public String getTableKey() {
        return this.tableKey;
    }

    @Override
    public void setTableKey(String tableKey) {
        this.tableKey = tableKey;
    }
}

