/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.impl;

import java.util.function.Function;
import kd.fi.v2.fah.meta.SimpleTableMeta;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.storage.tables.impl.AbstractSimpleTableStorage;
import kd.fi.v2.fah.storage.tables.impl.TableInfoPairTuple;

public interface IMemTableManager {
    public int registerTableSpace(Object var1, boolean var2, int var3, int var4);

    default public int registerTableSpace(Object tableKey, boolean columnStorageType, int columnCnt) {
        return this.registerTableSpace(tableKey, columnStorageType, columnCnt, -1);
    }

    public int registerTableSpace(boolean var1, SimpleTableMeta var2);

    default public TableInfoPairTuple getTableStorageAndInfo(String tableKey) {
        return this.getTableStorageAndInfoByIndex(this.getTableIndex(tableKey));
    }

    public TableInfoPairTuple getTableStorageAndInfoByIndex(int var1);

    default public <T extends AbstractSimpleTableStorage> T getTableStorage(String tableKey) {
        TableInfoPairTuple tableInfo = this.getTableStorageAndInfo(tableKey);
        return (T)(tableInfo == null ? null : (AbstractSimpleTableStorage)tableInfo.getKey());
    }

    default public <T extends AbstractSimpleTableStorage> T getTableStorageByIndex(int tableIdx) {
        TableInfoPairTuple tableInfo = this.getTableStorageAndInfoByIndex(tableIdx);
        return (T)(tableInfo == null ? null : (AbstractSimpleTableStorage)tableInfo.getKey());
    }

    default public TableInfoPairTuple releaseTableStorage(String tableKey) {
        return this.releaseTableStorage(this.getTableIndex(tableKey));
    }

    public TableInfoPairTuple releaseTableStorage(int var1);

    public int getTableIndex(String var1);

    public <T> T accessTable(int var1, Function<IDataTableStorage, T> var2, T var3);

    default public boolean setCellValue(int tableIdx, int rowIdx, int columnIdx, Object value) {
        return this.accessTable(tableIdx, tab -> {
            tab.setCellValue(rowIdx, columnIdx, value);
            return true;
        }, false);
    }

    default public Object getCellValue(int tableIdx, int rowIdx, int columnIdx) {
        return this.accessTable(tableIdx, tab -> tab.getCellValue(rowIdx, columnIdx), null);
    }
}

