/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.fi.v2.fah.constant.enums.NotNull;
import kd.fi.v2.fah.storage.impl.CacheableMutableArrayStorage;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.storage.tables.enums.MemTableStorageTypeEnum;
import kd.fi.v2.fah.storage.tables.impl.AbstractSimpleTableStorage;

public class SimpleTableColStorage
extends AbstractSimpleTableStorage<CacheableMutableArrayStorage<CacheableMutableArrayStorage>> {
    public SimpleTableColStorage(int columnCnt, int maxRowCnt, int[] pkColumnIdx) {
        super(columnCnt, maxRowCnt, pkColumnIdx);
    }

    public SimpleTableColStorage(int columnCnt, int maxRowCnt) {
        super(columnCnt, maxRowCnt);
    }

    public SimpleTableColStorage(int columnCnt) {
        super(columnCnt);
    }

    public SimpleTableColStorage() {
    }

    @Override
    public MemTableStorageTypeEnum getTableStorageType() {
        return MemTableStorageTypeEnum.Column_Raw_Table;
    }

    @Override
    public void resetTable(int columnCnt, int maxRowCnt, int[] pkColumnIdx) {
        this.maxRowCnt = maxRowCnt;
        this.rowCnt = 0;
        this.cacheRowCnt = 0;
        this.storage = this.__createStorage(columnCnt, CacheableMutableArrayStorage.class);
        this.columnCnt = columnCnt;
        if (this.columnCnt > 0) {
            for (int col = 0; col < columnCnt; ++col) {
                ((CacheableMutableArrayStorage)this.storage).add(this.__createStorage(Math.max(maxRowCnt, 0), Object.class));
            }
        }
        this.enablePk = false;
        this.setPkColumnIdx(pkColumnIdx);
    }

    @Override
    protected CacheableMutableArrayStorage<CacheableMutableArrayStorage> __createStorage(int maxRowCnt) {
        return this.__createStorage(maxRowCnt, CacheableMutableArrayStorage.class);
    }

    protected <T> CacheableMutableArrayStorage<T> __createStorage(int newSize, Class<T> classType) {
        return new CacheableMutableArrayStorage<T>(newSize, classType);
    }

    @Override
    protected void __storage_insert_new_row(Object[] newRowData, boolean addToCache) {
        int srcDataLength = newRowData == null ? 0 : newRowData.length;
        boolean isNotNullRow = newRowData != null;
        for (int col = 0; col < this.columnCnt; ++col) {
            Object valBuf;
            Object object = valBuf = isNotNullRow && col < srcDataLength ? newRowData[col] : null;
            if (addToCache) {
                ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).cache(valBuf);
                continue;
            }
            ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).addEx(valBuf);
        }
    }

    @Override
    protected void __storage_set_row(int rowIdx, Object[] newRowData) {
        int srcDataLength = newRowData == null ? 0 : newRowData.length;
        boolean isNotNullRow = newRowData != null;
        for (int col = 0; col < this.columnCnt; ++col) {
            ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).set(rowIdx, isNotNullRow && col < srcDataLength ? newRowData[col] : null);
        }
    }

    @Override
    protected boolean __storage_flush() {
        return ((CacheableMutableArrayStorage)this.storage).flush();
    }

    @Override
    protected void __storage_clear() {
        ((CacheableMutableArrayStorage)this.storage).forEach(col -> {
            if (col != null) {
                col.clear();
            }
        });
    }

    @Override
    protected boolean __storage_clear_cache() {
        return ((CacheableMutableArrayStorage)this.storage).clearCache();
    }

    @Override
    public int addEmptyRow() {
        for (int col = 0; col < this.columnCnt; ++col) {
            ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).cache(null);
        }
        ++this.rowCnt;
        return this.getRowCnt();
    }

    @Override
    public void clear(int startColumnIdx, int endColumnIdx) {
        int start = Math.max(startColumnIdx, 0);
        int end = Math.min(Math.max(endColumnIdx, 0), this.columnCnt - 1);
        if (endColumnIdx >= startColumnIdx) {
            for (int i = start; i <= end; ++i) {
                ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(i)).clear();
            }
        }
    }

    @Override
    public int addColumn(Object initValue) {
        CacheableMutableArrayStorage<Object> newColumn = this.__createStorage(this.rowCnt, Object.class);
        if (this.rowCnt > 0) {
            for (int i = 0; i < this.rowCnt; ++i) {
                newColumn.set(i, initValue);
            }
        }
        ++this.columnCnt;
        return ((CacheableMutableArrayStorage)this.storage).addEx(newColumn);
    }

    @Override
    public int addColumns(int addColumnCnt, Object initValue) {
        if (addColumnCnt <= 0) {
            return -1;
        }
        if (addColumnCnt == 1) {
            return this.addColumn(initValue);
        }
        ArrayList<CacheableMutableArrayStorage<Object>> newColumns = new ArrayList<CacheableMutableArrayStorage<Object>>(addColumnCnt);
        for (int i = 0; i < addColumnCnt; ++i) {
            newColumns.add(this.__createStorage(this.rowCnt, Object.class));
        }
        if (this.rowCnt > 0) {
            for (CacheableMutableArrayStorage cacheableMutableArrayStorage : newColumns) {
                for (int i = 0; i < this.rowCnt; ++i) {
                    cacheableMutableArrayStorage.set(i, initValue);
                }
            }
        }
        this.columnCnt += addColumnCnt;
        return ((CacheableMutableArrayStorage)this.storage).batchAdd(newColumns);
    }

    @Override
    public Object[] removeColumn(int columnIdx) {
        if (columnIdx < 0 || columnIdx >= this.columnCnt) {
            return Empty_DataRow;
        }
        CacheableMutableArrayStorage removedCol = (CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).removeByIndex(columnIdx);
        if (removedCol != null) {
            --this.columnCnt;
            return removedCol.getValues();
        }
        return Empty_DataRow;
    }

    @Override
    public Object[][] removeColumns(int startColumnIdx, int endColumnIdx) {
        List resultCols = ((CacheableMutableArrayStorage)this.storage).batchRemoveByRange(startColumnIdx, endColumnIdx);
        if (resultCols != null) {
            this.columnCnt -= resultCols.size();
            Object[][] result = new Object[resultCols.size()][];
            int colIdx = 0;
            for (CacheableMutableArrayStorage col : resultCols) {
                result[colIdx++] = col == null ? null : col.getValues();
            }
            return result;
        }
        return Empty_Removed_Columns;
    }

    @Override
    public <T> T getCellValue(int rowIdx, int columnIdx) {
        return (T)((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(columnIdx)).get(rowIdx);
    }

    @Override
    public void setCellValue(int rowIdx, int columnIdx, Object value) {
        ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(columnIdx)).set(rowIdx, value);
    }

    @Override
    public void setColumn(int columnIdx, Object[] values) {
        ((CacheableMutableArrayStorage)this.storage).set(columnIdx, new CacheableMutableArrayStorage<Object>(values, Object.class));
    }

    @Override
    public Object[] fetchRowValueCopy(int rowIdx, @NotNull Object[] outputBuffer, @NotNull int[] selectColumns) {
        int i = 0;
        for (int col : selectColumns) {
            outputBuffer[i++] = ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).get(rowIdx);
        }
        return outputBuffer;
    }

    @Override
    public Object[] fetchRowValueCopy(int rowIdx, @NotNull Object[] outputBuffer) {
        if (rowIdx < 0 || rowIdx >= this.rowCnt) {
            return null;
        }
        int i = 0;
        for (int col = 0; col < this.columnCnt; ++col) {
            outputBuffer[i++] = ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).get(rowIdx);
        }
        return outputBuffer;
    }

    @Override
    public Object[] getColumnValues(int columnIdx) {
        return ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(columnIdx)).getValues();
    }

    @Override
    public int insertRowData(Object[] newRowDatas, boolean autoExpandColumn, boolean addToCache) {
        if (newRowDatas == null || newRowDatas.length == 0) {
            return -1;
        }
        int srcDataLength = newRowDatas.length;
        if (srcDataLength > this.columnCnt) {
            if (autoExpandColumn) {
                this.addColumns(srcDataLength - this.columnCnt, null);
            } else if (this.columnCnt <= 0) {
                return -1;
            }
        }
        if (this.enablePk) {
            Object[] pkBuf = new Object[this.pkColumnIdx.length];
            int i = 0;
            for (int col : this.pkColumnIdx) {
                pkBuf[i++] = newRowDatas[col];
            }
            List<Object> pks = Arrays.asList(pkBuf);
            if (this.pkIndex.containsKey(pks)) {
                return -99;
            }
            this.pkIndex.put(pks, this.rowCnt);
        }
        for (int col = 0; col < this.columnCnt; ++col) {
            Object valBuf;
            Object object = valBuf = col < srcDataLength ? newRowDatas[col] : null;
            if (addToCache) {
                ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).cache(valBuf);
                continue;
            }
            ((CacheableMutableArrayStorage)((CacheableMutableArrayStorage)this.storage).get(col)).addEx(valBuf);
        }
        int result = this.cacheRowCnt + this.rowCnt;
        if (addToCache) {
            ++this.cacheRowCnt;
        } else {
            ++this.rowCnt;
        }
        return result;
    }

    @Override
    public int migrateTableColumns(IDataTableStorage srcTable, Integer[][] colReadWritePos) {
        if (srcTable == null || colReadWritePos == null || colReadWritePos.length == 0) {
            return 0;
        }
        int maxColWritePos = -1;
        for (Integer[] colPos : colReadWritePos) {
            if (colPos == null || maxColWritePos >= colPos[1]) continue;
            maxColWritePos = colPos[1];
        }
        if (maxColWritePos < 0) {
            return 0;
        }
        int maxRow = srcTable.getRowCnt();
        if (srcTable instanceof SimpleTableColStorage) {
            SimpleTableColStorage srcColumnTable = (SimpleTableColStorage)srcTable;
            ((CacheableMutableArrayStorage)this.storage).ensureCapacity(maxColWritePos + 1, CacheableMutableArrayStorage.class, true);
            this.columnCnt = ((CacheableMutableArrayStorage)this.storage).getCurrentStorePos();
            for (Integer[] colPos : colReadWritePos) {
                ((CacheableMutableArrayStorage)this.storage).set(colPos[1], ((CacheableMutableArrayStorage)srcColumnTable.storage).get(colPos[0]));
            }
            ((CacheableMutableArrayStorage)this.storage).forEach(col -> col.ensureCapacity(maxRow, Object.class, true));
            return colReadWritePos.length;
        }
        throw new UnsupportedOperationException(String.format("Not support Migrate From Table Type: [%s]!", srcTable.getClass().getSimpleName()));
    }
}

