/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.fi.v2.fah.meta.SimpleTableMeta;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableColStorage;

public class SimpleTableManager<T extends SimpleTableMeta> {
    private final Map<T, SimpleTableColStorage> tables = new HashMap<T, SimpleTableColStorage>(8);
    private final BiConsumer<T, SimpleTableColStorage> saveFunc;

    public SimpleTableManager() {
        this.saveFunc = (a, b) -> {};
    }

    public SimpleTableManager(BiConsumer<T, SimpleTableColStorage> saveFunc) {
        this.saveFunc = saveFunc;
    }

    public SimpleTableColStorage getSimpleTableStorage(T simpleTableMeta) {
        return this.tables.computeIfAbsent(simpleTableMeta, k -> new SimpleTableColStorage(simpleTableMeta.getColumnCnt()));
    }

    public void saveTable(T simpleTableMeta, SimpleTableColStorage storage) {
        this.saveFunc.accept(simpleTableMeta, storage);
    }

    public void saveTables() {
        for (Map.Entry<T, SimpleTableColStorage> tableEntry : this.tables.entrySet()) {
            this.saveFunc.accept(tableEntry.getKey(), tableEntry.getValue());
        }
    }
}

