/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.index.impl;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import kd.fi.v2.fah.iterator.BitSetIterator;
import kd.fi.v2.fah.storage.tables.enums.TableIndexTypeEnum;
import kd.fi.v2.fah.storage.tables.index.AbstractTableIndexStorage;
import kd.fi.v2.fah.storage.tables.index.INonUniqueTableIndexStorage;

public class SimpleBitMapTableIndexStorage
extends AbstractTableIndexStorage<BitSet>
implements INonUniqueTableIndexStorage {
    private static final BitSet Empty_BitSet = new BitSet(0);
    protected int positionMultiplier;
    protected transient boolean needMultiplierPosition;

    public SimpleBitMapTableIndexStorage() {
        this.positionMultiplier = 1;
        this.needMultiplierPosition = false;
    }

    public SimpleBitMapTableIndexStorage(int[] indexColumnPos) {
        this(null, indexColumnPos, 1);
    }

    public SimpleBitMapTableIndexStorage(int[] indexColumnPos, int positionMultiplier) {
        super(null, TableIndexTypeEnum.BITMAP_INDXE, indexColumnPos);
        this.positionMultiplier = positionMultiplier;
        this.needMultiplierPosition = this.positionMultiplier > 1;
    }

    public SimpleBitMapTableIndexStorage(Object indexKey, int[] indexColumnPos) {
        this(indexKey, indexColumnPos, 1);
    }

    public SimpleBitMapTableIndexStorage(Object indexKey, int[] indexColumnPos, int positionMultiplier) {
        super(indexKey, TableIndexTypeEnum.BITMAP_INDXE, indexColumnPos);
        this.positionMultiplier = positionMultiplier;
        this.needMultiplierPosition = this.positionMultiplier > 1;
    }

    @Override
    public boolean addIndexRow(int rowIndex, Object[] rowData) {
        int __newRowIdx = this.needMultiplierPosition ? this.positionMultiplier * rowIndex : rowIndex;
        Object indexKey = this.buildIndexKey(rowData);
        if (this.indexDatas == null) {
            this.indexDatas = new HashMap(4);
            BitSet bitSet = new BitSet();
            bitSet.set(__newRowIdx);
            this.indexDatas.put(indexKey, bitSet);
            return true;
        }
        this.indexDatas.computeIfAbsent(indexKey, v -> new BitSet(0)).set(__newRowIdx);
        return true;
    }

    @Override
    public int getMatchDataRowCnt(Object indexKey) {
        return this.indexDatas != null && !this.indexDatas.isEmpty() ? this.indexDatas.getOrDefault(indexKey, Empty_BitSet).cardinality() : 0;
    }

    @Override
    public Iterator<Integer> getMatchDataRow(Object indexKey) {
        return new BitSetIterator<Integer>(this.indexDatas != null && !this.indexDatas.isEmpty() ? this.indexDatas.getOrDefault(indexKey, Empty_BitSet) : Empty_BitSet, this.positionMultiplier, pos -> pos);
    }

    public int getPositionMultiplier() {
        return this.positionMultiplier;
    }

    public void setPositionMultiplier(int positionMultiplier) {
        this.positionMultiplier = positionMultiplier;
    }
}

