/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.common;

import java.io.Serializable;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.fi.v2.fah.task.common.BaseTaskMetaInfo;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.common.ITaskExceptionListener;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public abstract class AbstractFahBaseDataWorkTask<GRP_KEY extends Serializable, TASK_ID extends Serializable, TASK_TYPE extends Serializable, TASK_RESULT, META extends BaseTaskMetaInfo<GRP_KEY, TASK_ID, TASK_TYPE>>
implements IFahDataWorkTask<GRP_KEY, TASK_ID, TASK_TYPE, TASK_RESULT, META> {
    protected Supplier<Log> logSupplier;
    protected Log __logger;
    protected RequestContext requestContext;
    protected META taskMeta;
    protected TASK_RESULT taskResult;
    protected int currentBatchSeqNo;
    protected FahTaskGroupCondition taskGroupCondition;
    protected ITaskStatusChangeListener taskStatusChangeListener;
    protected ITaskExceptionListener taskExceptionListener;

    protected AbstractFahBaseDataWorkTask() {
        this.currentBatchSeqNo = 0;
    }

    protected AbstractFahBaseDataWorkTask(META taskMetaInfo, ITaskStatusChangeListener taskStatusChangeListener, FahTaskGroupCondition taskGroupCondition) {
        this.__logger = null;
        this.taskMeta = taskMetaInfo;
        this.taskGroupCondition = taskGroupCondition;
        this.taskStatusChangeListener = taskStatusChangeListener;
        this.currentBatchSeqNo = 0;
    }

    protected AbstractFahBaseDataWorkTask(META taskMetaInfo, ITaskStatusChangeListener taskStatusChangeListener) {
        this(taskMetaInfo, taskStatusChangeListener, null);
    }

    public String toString() {
        return "AbstractFahBaseDataWorkTask{taskMeta=" + this.taskMeta + ", taskResult=" + this.taskResult + ", currentBatchSeqNo=" + this.currentBatchSeqNo + ", taskGroupCondition=" + this.taskGroupCondition + ", taskStatusChangeListener=" + this.taskStatusChangeListener + ", requestContext=" + this.requestContext + ", logSupplier=" + this.logSupplier + '}';
    }

    @Override
    public void run() {
        try {
            this.taskResult = this.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initialization() {
        ((BaseTaskMetaInfo)this.taskMeta).setInitialized(true);
    }

    private Log getLogger() {
        if (this.__logger == null && this.logSupplier != null) {
            this.__logger = this.logSupplier.get();
        }
        return this.__logger;
    }

    protected abstract TASK_RESULT doTaskJob() throws Exception;

    protected void updateTaskStageCode(TaskStatusEnum newStageCode) {
        this.updateTaskStageCode(newStageCode, false);
    }

    protected synchronized void updateTaskStageCode(TaskStatusEnum newStageCode, boolean hasError) {
        this.taskGroupCondition.updateGroupCondition(newStageCode, hasError);
    }

    protected int getTaskTotalStatisticsPoints() {
        return this.taskGroupCondition.getTaskStatistic().getTotalStatisticsCnt();
    }

    protected boolean onException(Throwable exception) {
        if (this.getLogger() != null) {
            this.__logger.error(String.format("%s doTaskJob Error\uff1aTaskClass=%s", this.getClass().getName(), this));
            this.__logger.error(exception.getMessage(), exception);
        }
        boolean result = false;
        if (this.taskExceptionListener != null) {
            result = this.taskExceptionListener.onException(this, this.currentBatchSeqNo, exception.getMessage(), this.taskGroupCondition, exception);
        }
        if (result) {
            result = this.taskStatusChangeListener != null ? this.taskStatusChangeListener.onException(this, this.currentBatchSeqNo, exception.getMessage(), this.taskGroupCondition, exception) : true;
        }
        return result;
    }

    @Override
    public TASK_RESULT call() throws Exception {
        block15: {
            if (this.getLogger() != null && this.__logger.isInfoEnabled()) {
                this.__logger.info("Starting WorkTask: " + this);
            }
            if (this.taskStatusChangeListener != null) {
                this.taskStatusChangeListener.beforeTaskStart(this);
            }
            this.updateTaskStageCode(TaskStatusEnum.NEW);
            try {
                block14: {
                    block13: {
                        try {
                            this.initialization();
                            this.updateTaskStageCode(TaskStatusEnum.PROCESSING);
                            if (!this.isCancelled()) {
                                this.taskResult = this.doTaskJob();
                                this.updateTaskStageCode(TaskStatusEnum.COMPLETED);
                            }
                        }
                        catch (Exception ex) {
                            this.updateTaskStageCode(TaskStatusEnum.FAILURE, true);
                            this.onException(ex);
                            if (!((BaseTaskMetaInfo)this.taskMeta).isCanThrowException()) break block13;
                            throw ex;
                        }
                    }
                    try {
                        this.doTaskFinallyCleanUp(this.isCancelled(), this.taskGroupCondition.isWithFatalError());
                    }
                    catch (Exception ex) {
                        if (!this.taskGroupCondition.isWithFatalError()) {
                            this.updateTaskStageCode(TaskStatusEnum.WAIN, true);
                        }
                        this.onException(ex);
                        if (!((BaseTaskMetaInfo)this.taskMeta).isCanThrowException()) break block14;
                        throw ex;
                    }
                }
                if (this.taskStatusChangeListener == null) break block15;
                this.taskStatusChangeListener.afterTaskCompleted(this, this.taskResult, this.taskGroupCondition.isWithFatalError());
            }
            catch (Throwable throwable) {
                if (this.taskStatusChangeListener != null) {
                    this.taskStatusChangeListener.afterTaskCompleted(this, this.taskResult, this.taskGroupCondition.isWithFatalError());
                }
                if (this.__logger != null && this.__logger.isInfoEnabled()) {
                    this.__logger.info(String.format("WorkTask[%s, %s] Completed: ", this.getGroupId(), this.getTaskId()));
                }
                throw throwable;
            }
        }
        if (this.__logger != null && this.__logger.isInfoEnabled()) {
            this.__logger.info(String.format("WorkTask[%s, %s] Completed: ", this.getGroupId(), this.getTaskId()));
        }
        return this.taskResult;
    }

    protected void doTaskFinallyCleanUp(boolean isCancelled, boolean withError) {
    }

    @Override
    public void cancel(boolean deactivateAll) {
        this.taskGroupCondition.cancel(false);
    }

    protected void restoreRequestContext(RequestContext tenantRequestContext) {
        RequestContext.copyAndSet((RequestContext)tenantRequestContext);
    }

    @Override
    public RequestContext getTenantRequestContext() {
        return this.requestContext;
    }

    @Override
    public TASK_RESULT getResult() {
        return this.taskResult;
    }

    @Override
    public boolean hasError() {
        return this.taskGroupCondition.isWithFatalError();
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public void refreshRequestContext() {
        this.requestContext = this.requestContext == null ? RequestContext.copyAndSet((RequestContext)RequestContext.get()) : RequestContext.copyAndSet((RequestContext)this.requestContext);
    }

    public TASK_RESULT getTaskResult() {
        return this.taskResult;
    }

    @Override
    public FahTaskGroupCondition getTaskGroupCondition() {
        return this.taskGroupCondition;
    }

    public ITaskStatusChangeListener getTaskStatusChangeListener() {
        return this.taskStatusChangeListener;
    }

    @Override
    public void setTaskStatusChangeListener(ITaskStatusChangeListener taskStatusChangeListener) {
        this.taskStatusChangeListener = taskStatusChangeListener;
    }

    public Supplier<Log> getLogSupplier() {
        return this.logSupplier;
    }

    public void setLogSupplier(Supplier<Log> logSupplier) {
        this.logSupplier = logSupplier;
    }

    @Override
    public META getTaskMeta() {
        return this.taskMeta;
    }

    @Override
    public void setTaskMeta(META taskMeta) {
        this.taskMeta = taskMeta;
    }

    public void setTaskResult(TASK_RESULT taskTASKResult) {
        this.taskResult = taskTASKResult;
    }

    @Override
    public void setTaskGroupCondition(FahTaskGroupCondition taskGroupCondition) {
        this.taskGroupCondition = taskGroupCondition;
    }

    public ITaskExceptionListener getTaskExceptionListener() {
        return this.taskExceptionListener;
    }

    public void setTaskExceptionListener(ITaskExceptionListener taskExceptionListener) {
        this.taskExceptionListener = taskExceptionListener;
    }
}

