/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public class BaseTaskMetaInfo<GRP_KEY extends Serializable, TASK_ID extends Serializable, TASK_TYPE extends Serializable>
implements Serializable,
IDataItemKey<List<Object>> {
    protected GRP_KEY groupId;
    protected TASK_ID taskId;
    protected TASK_TYPE taskTypeCode;
    protected boolean canThrowException;
    protected TaskStatusEnum taskStatus = TaskStatusEnum.NEW;
    protected boolean initialized;
    protected transient ArrayList<Object> metaKey_cache;

    public BaseTaskMetaInfo(GRP_KEY groupId, TASK_ID taskId, TASK_TYPE taskTypeCode, boolean canThrowException) {
        this.groupId = groupId;
        this.taskId = taskId;
        this.taskTypeCode = taskTypeCode;
        this.canThrowException = canThrowException;
        this.initialized = false;
        this.metaKey_cache = new ArrayList<Serializable>(Arrays.asList(groupId, taskId, taskTypeCode));
    }

    public BaseTaskMetaInfo(GRP_KEY groupId, TASK_ID taskId, TASK_TYPE taskTypeCode) {
        this(groupId, taskId, taskTypeCode, false);
    }

    public BaseTaskMetaInfo(TASK_ID taskId, TASK_TYPE taskTypeCode) {
        this(null, taskId, taskTypeCode, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTaskMetaInfo)) {
            return false;
        }
        BaseTaskMetaInfo that = (BaseTaskMetaInfo)o;
        return this.canThrowException == that.canThrowException && this.initialized == that.initialized && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.taskTypeCode, that.taskTypeCode) && this.taskStatus == that.taskStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.taskId, this.taskTypeCode, this.canThrowException, this.taskStatus, this.initialized, this.metaKey_cache});
    }

    public String toString() {
        return "BaseTaskMetaInfo{groupId=" + this.groupId + ", taskId=" + this.taskId + ", taskTypeCode='" + this.taskTypeCode + '\'' + ", canThrowException=" + this.canThrowException + ", initialized=" + this.initialized + ", metaKey_cache=" + this.getItemKey() + '}';
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public List<Object> getItemKey() {
        return this.metaKey_cache == null ? (this.metaKey_cache = new ArrayList<Serializable>(Arrays.asList(this.groupId, this.taskId, this.taskTypeCode))) : this.metaKey_cache;
    }

    public GRP_KEY getGroupId() {
        return this.groupId;
    }

    public void setGroupId(GRP_KEY groupId) {
        this.groupId = groupId;
        this.metaKey_cache.set(0, this.groupId);
    }

    public TASK_ID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(TASK_ID taskId) {
        this.taskId = taskId;
        this.metaKey_cache.set(0, this.taskId);
    }

    public TASK_TYPE getTaskTypeCode() {
        return this.taskTypeCode;
    }

    public void setTaskTypeCode(TASK_TYPE taskTypeCode) {
        this.taskTypeCode = taskTypeCode;
        this.metaKey_cache.set(0, this.taskTypeCode);
    }

    public boolean isCanThrowException() {
        return this.canThrowException;
    }

    public void setCanThrowException(boolean canThrowException) {
        this.canThrowException = canThrowException;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public TaskStatusEnum getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(TaskStatusEnum taskStatus) {
        this.taskStatus = taskStatus;
    }
}

