/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.context;

import java.util.List;
import java.util.Objects;
import kd.fi.v2.fah.constant.enums.NotNull;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.task.context.IBackgroundTaskContext;
import kd.fi.v2.fah.task.statistics.BaseTaskStatisticInfo;
import kd.fi.v2.fah.task.status.ResultCountTypeEnum;
import kd.fi.v2.fah.task.status.TaskStatusEnum;
import kd.fi.v2.fah.task.status.TaskTimeTypeEnum;

public class BaseBackgroundTaskContext<TASK_ID>
implements IBackgroundTaskContext<TASK_ID> {
    protected TASK_ID taskId;
    protected BackgroundTaskTypeEnum backgroundTaskType;
    protected BaseTaskStatisticInfo taskStatistic = new BaseTaskStatisticInfo();
    protected TaskStatusEnum taskStatus;
    protected List<String> errorMsg;

    public BaseBackgroundTaskContext() {
    }

    public BaseBackgroundTaskContext(TASK_ID taskId, BackgroundTaskTypeEnum backgroundTaskType) {
        this();
        this.taskId = taskId;
        this.backgroundTaskType = backgroundTaskType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseBackgroundTaskContext)) {
            return false;
        }
        BaseBackgroundTaskContext that = (BaseBackgroundTaskContext)o;
        return Objects.equals(this.taskId, that.taskId) && this.backgroundTaskType == that.backgroundTaskType && Objects.equals(this.taskStatistic, that.taskStatistic) && this.taskStatus == that.taskStatus && Objects.equals(this.errorMsg, that.errorMsg);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskId, this.backgroundTaskType, this.taskStatistic, this.taskStatus, this.errorMsg});
    }

    @Override
    public BackgroundTaskTypeEnum getBackgroundTaskType() {
        return this.backgroundTaskType;
    }

    @Override
    public TASK_ID getItemKey() {
        return this.taskId;
    }

    @Override
    public TASK_ID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(TASK_ID taskId) {
        this.taskId = taskId;
    }

    public void setBackgroundTaskType(BackgroundTaskTypeEnum backgroundTaskType) {
        this.backgroundTaskType = backgroundTaskType;
    }

    public long getTaskTime(TaskTimeTypeEnum timeType) {
        return this.taskStatistic.getTaskTime(timeType);
    }

    public void setTaskTime(long[] taskTime) {
        this.taskStatistic.setTaskTime(taskTime);
    }

    public void setTaskTime(TaskTimeTypeEnum timeType, long newValue) {
        this.taskStatistic.setTaskTime(timeType, newValue);
    }

    public int getTaskPoints(@NotNull ResultCountTypeEnum countType) {
        return this.taskStatistic.getStatisticPoint(countType.getCode());
    }

    public void setTaskPoints(@NotNull ResultCountTypeEnum countType, int taskPoint) {
        this.taskStatistic.setStatisticPoint(countType.getCode(), taskPoint);
    }

    public TaskStatusEnum getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(TaskStatusEnum taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setTaskStastic(int[] taskStastic) {
        this.taskStatistic.setStatisticPoints(taskStastic);
    }

    public BaseTaskStatisticInfo getTaskStatistic() {
        return this.taskStatistic;
    }

    public void setTaskStatistic(BaseTaskStatisticInfo taskStatistic) {
        this.taskStatistic = taskStatistic;
    }

    public List<String> getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(List<String> errorMsg) {
        this.errorMsg = errorMsg;
    }
}

