/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.process;

import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.engine.config.IProcessorConfigContext;
import kd.fi.v2.fah.engine.config.grp.HierarchyProcessorCfgGroup;
import kd.fi.v2.fah.engine.config.grp.SingleLayerUnitCfgCollection;
import kd.fi.v2.fah.engine.processor.IMemTableProcessorUnit;
import kd.fi.v2.fah.engine.processor.IProcessorUnit;
import kd.fi.v2.fah.engine.processor.ProcessorLookupFactory;
import kd.fi.v2.fah.engine.processor.SimpleProcessResultCounts;
import kd.fi.v2.fah.engine.processor.common.AbstractMemTableProcessorUnit;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableColStorage;
import kd.fi.v2.fah.task.context.IBackgroundTaskContext;
import kd.fi.v2.fah.task.process.AbstractBaseFahProcessTask;
import kd.fi.v2.fah.utils.Assert;

public class CommonHierarchyDynValFieldProcessTask
extends AbstractBaseFahProcessTask<PairTuple<IDataTableStorage, SimpleProcessResultCounts[]>, IBackgroundTaskContext> {
    protected static final ProcessorLookupFactory processorFactory = ProcessorLookupFactory.getInstance();
    protected HierarchyProcessorCfgGroup cfgGroup;
    protected IDataTableStorage srcDataTable;
    protected int srcDataCnt;
    protected transient IProcessorUnit[][] _cache_processors;
    protected transient int[] _layersColumnCnt;

    protected void initialization() {
        this.build_processorUnit_cache();
        super.initialization();
    }

    protected int build_processorUnit_cache() {
        int totalLayerCnt = this.cfgGroup.getTotalLayerCnt();
        this._cache_processors = new IProcessorUnit[totalLayerCnt][];
        this._layersColumnCnt = new int[totalLayerCnt];
        int totalUnitCnt = 0;
        int layerIdx = 0;
        if (this.cfgGroup.hasPreProcessLayer() && (this._cache_processors[layerIdx] = this._build_layer_processorUnit_cache(this.cfgGroup.getPreProcessLayer())) != null) {
            totalUnitCnt += this._cache_processors[layerIdx].length;
            this._layersColumnCnt[layerIdx] = this.cfgGroup.getPreProcessLayer().getTotalColumnCnt();
        }
        for (SingleLayerUnitCfgCollection layer : this.cfgGroup.getLayerCfgs()) {
            if (layer == null || (this._cache_processors[layerIdx] = this._build_layer_processorUnit_cache(layer)) == null) continue;
            totalUnitCnt += this._cache_processors[layerIdx].length;
            this._layersColumnCnt[layerIdx] = layer.getTotalColumnCnt();
            ++layerIdx;
        }
        return totalUnitCnt;
    }

    protected IProcessorUnit[] _build_layer_processorUnit_cache(SingleLayerUnitCfgCollection cfgs) {
        if (cfgs == null) {
            return null;
        }
        IProcessorUnit[] result = new AbstractMemTableProcessorUnit[cfgs.size()];
        int i = 0;
        for (IProcessorConfigContext cfg : cfgs) {
            result[i++] = processorFactory.getProcessorUnit(cfg);
            if (result[i++] != null) continue;
            throw new IllegalArgumentException(String.format("%d).Cfg Cannot found Process Unit! %s", i - 1, cfg));
        }
        return result;
    }

    protected void releaseProcessorUnits() {
        if (this._cache_processors == null) {
            return;
        }
        for (IProcessorUnit[] processorUnits : this._cache_processors) {
            if (processorUnits == null) continue;
            for (IProcessorUnit p : processorUnits) {
                processorFactory.returnProcessorInstance(p);
            }
        }
        this._cache_processors = null;
        this._layersColumnCnt = null;
    }

    @Override
    public void releaseTask() {
        this.releaseProcessorUnits();
    }

    @Override
    protected void onProcessDataTrans(IBackgroundTaskContext taskContext) {
        this.taskResult = this.doLayerProcess(this.srcDataTable, this.srcDataCnt);
    }

    protected PairTuple<IDataTableStorage, SimpleProcessResultCounts[]> doLayerProcess(IDataTableStorage srcData, int dataCnt) {
        int layerIdx = -1;
        IDataTableStorage parentLayerTable = srcData;
        SimpleTableColStorage currentLayerTable = null;
        SimpleProcessResultCounts[] layerResultCnts = new SimpleProcessResultCounts[this._cache_processors.length];
        for (IProcessorUnit[] units : this._cache_processors) {
            int failCnt = 0;
            currentLayerTable = this.requestNewDataStorage(parentLayerTable, this.cfgGroup.getLayerCfgs(++layerIdx), this._layersColumnCnt[layerIdx], -1L);
            block4: for (IProcessorUnit processor : units) {
                if (processor instanceof IMemTableProcessorUnit) {
                    ((IMemTableProcessorUnit)processor).setOutputTable(currentLayerTable);
                }
                layerResultCnts[layerIdx] = processor.process(parentLayerTable, this.taskContext, dataCnt);
                switch (layerResultCnts[layerIdx].getResultStatus()) {
                    case FAILURE: 
                    case CANCELLED: {
                        ++failCnt;
                        continue block4;
                    }
                }
            }
            if (failCnt == units.length) break;
            parentLayerTable = currentLayerTable;
        }
        return new PairTuple(currentLayerTable, (Object)layerResultCnts);
    }

    protected SimpleTableColStorage requestNewDataStorage(IDataTableStorage parentLayerTable, SingleLayerUnitCfgCollection layerConfigs, int maxColumnCnt, long timeOut) {
        int parentLayerRowCnt = parentLayerTable.getRowCnt();
        SimpleTableColStorage layerTable = new SimpleTableColStorage(maxColumnCnt, parentLayerRowCnt);
        int successCnt = layerTable.migrateTableColumns(parentLayerTable, layerConfigs.getMigrateColumnPos());
        Assert.assertEquals(layerConfigs.getMigrateColumnPos().length, successCnt);
        return layerTable;
    }
}

