/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.statistics;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Arrays;
import kd.fi.v2.fah.task.status.ResultCountTypeEnum;
import kd.fi.v2.fah.task.status.TaskTimeTypeEnum;

public class BaseTaskStatisticInfo
implements Serializable {
    public static final int STATISTIC_IDX_TOTAL = ResultCountTypeEnum.getMaxCode();
    protected final long[] taskTime;
    protected final int[] statisticPoints = new int[this.getTotalStatisticsIdx()];

    public BaseTaskStatisticInfo() {
        Arrays.fill(this.statisticPoints, 0);
        this.taskTime = new long[TaskTimeTypeEnum.values().length];
        Arrays.fill(this.taskTime, 0L);
    }

    public String toString() {
        return "BaseTaskStatisticInfo{statisticPoints=" + Arrays.toString(this.statisticPoints) + "taskTime=" + Arrays.toString(this.taskTime) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTaskStatisticInfo)) {
            return false;
        }
        BaseTaskStatisticInfo that = (BaseTaskStatisticInfo)o;
        return Arrays.equals(this.taskTime, that.taskTime) && Arrays.equals(this.statisticPoints, that.statisticPoints);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.taskTime);
        result = 31 * result + Arrays.hashCode(this.statisticPoints);
        return result;
    }

    protected int getTotalStatisticsIdx() {
        return STATISTIC_IDX_TOTAL + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long __accessTaskTime(boolean getOrUpdate, int idx, long newValue) {
        long[] lArray = this.taskTime;
        synchronized (this.taskTime) {
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return getOrUpdate ? this.taskTime[idx] : newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int __accessStatisticPoints(int accessMode, int idx, int newValue) {
        int[] nArray = this.statisticPoints;
        synchronized (this.statisticPoints) {
            switch (accessMode) {
                case 1: {
                    this.statisticPoints[idx] = newValue;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.statisticPoints[idx];
                }
                case 2: {
                    int n = idx;
                    int n2 = this.statisticPoints[n] + newValue;
                    this.statisticPoints[n] = n2;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return n2;
                }
                case 3: {
                    int cnt = 0;
                    for (int v : this.statisticPoints) {
                        cnt += v;
                    }
                    this.statisticPoints[BaseTaskStatisticInfo.STATISTIC_IDX_TOTAL] = cnt;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.statisticPoints[BaseTaskStatisticInfo.STATISTIC_IDX_TOTAL];
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.statisticPoints[idx];
        }
    }

    protected synchronized int __accessStatisticPoints(int idx) {
        return this.__accessStatisticPoints(0, idx, -1);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getTotalStatisticsCnt() {
        return this.__accessStatisticPoints(STATISTIC_IDX_TOTAL);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int reCalculateTotalStatisticsCnt() {
        return this.__accessStatisticPoints(3, -1, -1);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void setStatisticPoint(int idx, int newValue) {
        this.__accessStatisticPoints(1, idx, newValue);
    }

    public int updateStatisticPoint(int idx, int deltaValue) {
        return this.__accessStatisticPoints(2, idx, deltaValue);
    }

    public int increase(int idx) {
        return this.__accessStatisticPoints(2, idx, 1);
    }

    public int getStatisticPoint(int idx) {
        return this.__accessStatisticPoints(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getStatisticPoints() {
        int[] nArray = this.statisticPoints;
        synchronized (this.statisticPoints) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.copyOf(this.statisticPoints, this.statisticPoints.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatisticPoints(int[] srcPoints) {
        if (srcPoints == null || srcPoints.length == 0) {
            return;
        }
        int[] nArray = this.statisticPoints;
        synchronized (this.statisticPoints) {
            Arrays.fill(this.statisticPoints, 0);
            for (int i = 0; i < Math.min(srcPoints.length, this.statisticPoints.length); ++i) {
                this.statisticPoints[i] = srcPoints[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getTaskTime() {
        long[] lArray = this.taskTime;
        synchronized (this.taskTime) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.copyOf(this.taskTime, this.taskTime.length);
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public long getTaskTime(TaskTimeTypeEnum timeType) {
        return this.__accessTaskTime(true, timeType.getCode(), -1L);
    }

    public long setTaskTime(TaskTimeTypeEnum timeType, long newValue) {
        return this.__accessTaskTime(false, timeType.getCode(), newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskTime(long[] srcTaskTime) {
        if (srcTaskTime == null || srcTaskTime.length == 0) {
            return;
        }
        long[] lArray = this.taskTime;
        synchronized (this.taskTime) {
            Arrays.fill(this.taskTime, 0L);
            for (int i = 0; i < Math.min(srcTaskTime.length, this.taskTime.length); ++i) {
                this.taskTime[i] = srcTaskTime[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

