/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class BillProcessStageStatistics
implements Serializable {
    protected volatile Map<Long, int[][]> stageStatistic;

    public BillProcessStageStatistics() {
    }

    public BillProcessStageStatistics(Collection<Long> srcBillIds) {
        if (srcBillIds == null) {
            throw new IllegalArgumentException("Source Bill Id cannot be null!");
        }
        this.stageStatistic = new HashMap<Long, int[][]>(srcBillIds.size());
        for (Long key : srcBillIds) {
            this.stageStatistic.put(key, this.buildStageStatisticArray());
        }
    }

    protected synchronized <RES> RES accessBillStatistic(Long srcBillId, Function<int[][], RES> accessFunc, RES defaultValue) {
        int[][] statistic = this.stageStatistic.get(srcBillId);
        return statistic != null ? accessFunc.apply(statistic) : defaultValue;
    }

    public synchronized void batchAccessStageStatistic(Collection<Long> srcBillIds, BiConsumer<Long, int[][]> accessFunc) {
        for (Long id : srcBillIds) {
            accessFunc.accept(id, this.stageStatistic.get(id));
        }
    }

    protected int addStageStatistic(Long srcBillId, BillProcessStageStatisticEnum stage, boolean expectOrComplete, int deltaValue) {
        return this.accessBillStatistic(srcBillId, statistic -> {
            int[] nArray = statistic[stage.code];
            int n = expectOrComplete ? 0 : 1;
            int n2 = nArray[n] + deltaValue;
            nArray[n] = n2;
            return n2;
        }, 0);
    }

    public int addExpectCnt(Long srcBillId, BillProcessStageStatisticEnum stage, int deltaValue) {
        return this.addStageStatistic(srcBillId, stage, true, deltaValue);
    }

    public int addCompletedCnt(Long srcBillId, BillProcessStageStatisticEnum stage, int deltaValue) {
        return this.addStageStatistic(srcBillId, stage, false, deltaValue);
    }

    public synchronized int[][] removeStatistic(Long srcBillId) {
        return this.stageStatistic.remove(srcBillId);
    }

    public synchronized boolean containBillId(Long srcBillId) {
        return this.stageStatistic.containsKey(srcBillId);
    }

    public synchronized boolean isStageCompleted(Long srcBillId, BillProcessStageStatisticEnum stage) {
        return this.accessBillStatistic(srcBillId, statistic -> statistic[stage.code][0] <= statistic[stage.code][1], false);
    }

    public synchronized boolean isAllStageCompleted(Long srcBillId) {
        return this.accessBillStatistic(srcBillId, statistic -> {
            for (int i = 0; i < ((int[][])statistic).length; ++i) {
                if (statistic[i][0] <= statistic[i][1]) continue;
                return false;
            }
            return true;
        }, false);
    }

    protected int[][] buildStageStatisticArray() {
        int[][] result = new int[BillProcessStageStatisticEnum.Stage_GenXLA.code + 1][2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new int[]{0, 0};
        }
        return result;
    }

    public Map<Long, int[][]> getStageStatistic() {
        return this.stageStatistic;
    }

    public void setStageStatistic(Map<Long, int[][]> stageStatistic) {
        this.stageStatistic = stageStatistic;
    }

    public static enum BillProcessStageStatisticEnum {
        Stage_Dispatch(0),
        Stage_GenEvent(1),
        Stage_GenXLA(2);

        int code;

        private BillProcessStageStatisticEnum(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

