/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.Arrays;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;

public class Assert {
    protected Assert() {
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void isTrue(boolean condition, String message) {
        if (!condition) {
            Assert.fail(message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        Assert.assertTrue(message, !condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (!ICommonDataValueUtil.deepEquals(expected, actual)) {
            if (expected instanceof String && actual instanceof String) {
                throw new ComparisonFailure(message == null ? "" : message, (String)expected, (String)actual);
            }
            Assert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertIntArrayEquals(int[] expected, int[] actual) {
        Assert.assertEquals(Arrays.toString(expected), Arrays.toString(actual));
    }

    public static void assertIntArrayEquals(long[] expected, long[] actual) {
        Assert.assertEquals(Arrays.toString(expected), Arrays.toString(expected));
    }

    public static void assertNotEquals(String message, Object unexpected, Object actual) {
        if (ICommonDataValueUtil.deepEquals(unexpected, actual)) {
            Assert.failEquals(message, actual);
        }
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    private static void failEquals(String message, Object actual) {
        String formatted = "Values should be different. ";
        if (message != null) {
            formatted = message + ". ";
        }
        formatted = formatted + "Actual: " + actual;
        Assert.fail(formatted);
    }

    public static void assertNotEquals(String message, long unexpected, long actual) {
        if (unexpected == actual) {
            Assert.failEquals(message, actual);
        }
    }

    public static void assertNotEquals(long unexpected, long actual) {
        Assert.assertNotEquals(null, unexpected, actual);
    }

    public static void assertNotEquals(String message, double unexpected, double actual, double delta) {
        if (!Assert.doubleIsDifferent(unexpected, actual, delta)) {
            Assert.failEquals(message, actual);
        }
    }

    public static void assertNotEquals(double unexpected, double actual, double delta) {
        Assert.assertNotEquals(null, unexpected, actual, delta);
    }

    public static void assertNotEquals(float unexpected, float actual, float delta) {
        Assert.assertNotEquals(null, unexpected, actual, delta);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Assert.doubleIsDifferent(expected, actual, delta)) {
            Assert.failNotEquals(message, expected, actual);
        }
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (Assert.floatIsDifferent(expected, actual, delta)) {
            Assert.failNotEquals(message, Float.valueOf(expected), Float.valueOf(actual));
        }
    }

    public static void assertNotEquals(String message, float unexpected, float actual, float delta) {
        if (!Assert.floatIsDifferent(unexpected, actual, delta)) {
            Assert.failEquals(message, Float.valueOf(actual));
        }
    }

    private static boolean doubleIsDifferent(double d1, double d2, double delta) {
        if (Double.compare(d1, d2) == 0) {
            return false;
        }
        return !(Math.abs(d1 - d2) <= delta);
    }

    private static boolean floatIsDifferent(float f1, float f2, float delta) {
        if (Float.compare(f1, f2) == 0) {
            return false;
        }
        return !(Math.abs(f1 - f2) <= delta);
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, long expected, long actual) {
        if (expected != actual) {
            Assert.failNotEquals(message, expected, actual);
        }
    }

    @Deprecated
    public static void assertEquals(double expected, double actual) {
        Assert.assertEquals(null, expected, actual);
    }

    @Deprecated
    public static void assertEquals(String message, double expected, double actual) {
        Assert.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assertTrue(message, object != null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNull(String message, Object object) {
        if (object == null) {
            return;
        }
        Assert.failNotNull(message, object);
    }

    public static void isNull(Object object, String message) {
        Assert.assertNull(message, object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    private static void failNotNull(String message, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected null, but was:<" + actual + ">");
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message, Object unexpected, Object actual) {
        if (unexpected == actual) {
            Assert.failSame(message);
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assert.assertNotSame(null, unexpected, actual);
    }

    private static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not same");
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        Assert.fail(Assert.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !"".equals(message)) {
            formatted = message + " ";
        }
        if (ICommonDataValueUtil.deepEquals(expectedString = String.valueOf(expected), actualString = String.valueOf(actual))) {
            return formatted + "expected: " + Assert.formatClassAndValue(expected, expectedString) + " but was: " + Assert.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClass(Class<?> value) {
        String className = value.getCanonicalName();
        return className == null ? value.getName() : className;
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    private static String buildPrefix(String message) {
        return message != null && message.length() != 0 ? message + ": " : "";
    }

    public static class ComparisonFailure
    extends AssertionError {
        private static final int MAX_CONTEXT_LENGTH = 20;
        private static final long serialVersionUID = 1L;
        private String fExpected;
        private String fActual;

        public ComparisonFailure(String message, String expected, String actual) {
            super((Object)message);
            this.fExpected = expected;
            this.fActual = actual;
        }

        public String getMessage() {
            return new ComparisonCompactor(20, this.fExpected, this.fActual).compact(super.getMessage());
        }

        public String getActual() {
            return this.fActual;
        }

        public String getExpected() {
            return this.fExpected;
        }

        private static class ComparisonCompactor {
            private static final String ELLIPSIS = "...";
            private static final String DIFF_END = "]";
            private static final String DIFF_START = "[";
            private final int contextLength;
            private final String expected;
            private final String actual;

            public ComparisonCompactor(int contextLength, String expected, String actual) {
                this.contextLength = contextLength;
                this.expected = expected;
                this.actual = actual;
            }

            public String compact(String message) {
                if (this.expected == null || this.actual == null || this.expected.equals(this.actual)) {
                    return Assert.format(message, this.expected, this.actual);
                }
                DiffExtractor extractor = new DiffExtractor();
                String compactedPrefix = extractor.compactPrefix();
                String compactedSuffix = extractor.compactSuffix();
                return Assert.format(message, compactedPrefix + extractor.expectedDiff() + compactedSuffix, compactedPrefix + extractor.actualDiff() + compactedSuffix);
            }

            private String sharedPrefix() {
                int end = Math.min(this.expected.length(), this.actual.length());
                for (int i = 0; i < end; ++i) {
                    if (this.expected.charAt(i) == this.actual.charAt(i)) continue;
                    return this.expected.substring(0, i);
                }
                return this.expected.substring(0, end);
            }

            private String sharedSuffix(String prefix) {
                int suffixLength;
                int maxSuffixLength = Math.min(this.expected.length() - prefix.length(), this.actual.length() - prefix.length()) - 1;
                for (suffixLength = 0; suffixLength <= maxSuffixLength && this.expected.charAt(this.expected.length() - 1 - suffixLength) == this.actual.charAt(this.actual.length() - 1 - suffixLength); ++suffixLength) {
                }
                return this.expected.substring(this.expected.length() - suffixLength);
            }

            private class DiffExtractor {
                private final String sharedPrefix;
                private final String sharedSuffix;

                private DiffExtractor() {
                    this.sharedPrefix = ComparisonCompactor.this.sharedPrefix();
                    this.sharedSuffix = ComparisonCompactor.this.sharedSuffix(this.sharedPrefix);
                }

                public String expectedDiff() {
                    return this.extractDiff(ComparisonCompactor.this.expected);
                }

                public String actualDiff() {
                    return this.extractDiff(ComparisonCompactor.this.actual);
                }

                public String compactPrefix() {
                    if (this.sharedPrefix.length() <= ComparisonCompactor.this.contextLength) {
                        return this.sharedPrefix;
                    }
                    return ComparisonCompactor.ELLIPSIS + this.sharedPrefix.substring(this.sharedPrefix.length() - ComparisonCompactor.this.contextLength);
                }

                public String compactSuffix() {
                    if (this.sharedSuffix.length() <= ComparisonCompactor.this.contextLength) {
                        return this.sharedSuffix;
                    }
                    return this.sharedSuffix.substring(0, ComparisonCompactor.this.contextLength) + ComparisonCompactor.ELLIPSIS;
                }

                private String extractDiff(String source) {
                    return ComparisonCompactor.DIFF_START + source.substring(this.sharedPrefix.length(), source.length() - this.sharedSuffix.length()) + ComparisonCompactor.DIFF_END;
                }
            }
        }
    }
}

