/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;

public class DataModelMetaUtils {
    public static final String ENTITY_BOSORG = "bos_org";
    public static final String DEFAULT_ORG = "org";

    public static MainEntityType getEntityTypeForDyn(DynamicObject dyEventClass, DataModelCfg extDatamodel) {
        MainEntityType entityType = new MainEntityType();
        if (extDatamodel.getCollections() == null || ((BaseMutableArrayMapStorage)extDatamodel.getCollections()).isEmpty()) {
            return null;
        }
        String number = dyEventClass.getString("number");
        String displayName = dyEventClass.getString("name");
        DataModelMetaUtils.initMetaEntityBaseInfo(entityType, number, displayName);
        DataModelMetaUtils.registerMissingProperty(entityType, extDatamodel);
        DataModelMetaUtils.endInitMetaEntityBaseInfo(entityType);
        return entityType;
    }

    private static void initMetaEntityBaseInfo(MainEntityType entityType, String number, String displayName) {
        entityType.setName(number);
        entityType.setAppId("ai");
        entityType.setDisplayName(new LocaleString(displayName));
        entityType.setDbIgnore(true);
        LongProp idProp = new LongProp();
        idProp.setAlias("fid");
        idProp.setName("id");
        entityType.addProperty((DynamicProperty)idProp);
    }

    private static void endInitMetaEntityBaseInfo(MainEntityType entityType) {
        DataEntityPropertyCollection properties = entityType.getProperties();
        IDataEntityProperty defalutOrgProp = (IDataEntityProperty)properties.get((Object)DEFAULT_ORG);
        if (defalutOrgProp == null) {
            OrgProp orgProp = new OrgProp();
            MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)ENTITY_BOSORG);
            orgProp.setComplexType((IDataEntityType)orgType);
            orgProp.setBaseEntityId(ENTITY_BOSORG);
            orgProp.setRefIdPropName("org_Id");
            LongProp idProp = new LongProp();
            idProp.setName("org_Id");
            orgProp.setRefIdProp((IDataEntityProperty)idProp);
            orgProp.setAlias("fid");
            orgProp.setName(DEFAULT_ORG);
            orgProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"DataModelMetaUtils_0", (String)"fi-ai-common", (Object[])new Object[0])));
            entityType.addProperty((DynamicProperty)orgProp);
        }
    }

    private static void registerMissingProperty(MainEntityType entityType, DataModelCfg extDataModel) {
        DynamicProperty prop = null;
        for (DataModelFieldCollection collection : (BaseMutableArrayMapStorage)extDataModel.getCollections()) {
            if (collection.getCollections() == null) continue;
            for (DataModelFieldCfg field : (BaseMutableArrayMapStorage)collection.getCollections()) {
                prop = DataModelMetaUtils.createProperty(field);
                if (null == prop) continue;
                if (prop instanceof BasedataProp) {
                    prop.setAlias("f" + field.getNumber() + "id");
                } else {
                    prop.setAlias("f" + field.getNumber());
                }
                prop.setName(field.getNumber());
                prop.setDisplayName(new LocaleString(field.getName()));
                prop.setDbIgnore(true);
                entityType.addProperty(prop);
                if (!(prop instanceof BasedataProp)) continue;
                DynamicProperty refIdProp = (DynamicProperty)((BasedataProp)prop).getRefIdProp();
                refIdProp.setName(prop.getName() + "_Id");
                entityType.addProperty(refIdProp);
            }
        }
    }

    private static DynamicProperty createProperty(DataModelFieldCfg field) {
        TextProp prop = null;
        DataValueTypeEnum dataType = field.getDataType();
        if (DataValueTypeEnum.String == dataType) {
            prop = new TextProp();
        } else if (DataValueTypeEnum.Decimal == dataType) {
            prop = new DecimalProp();
        } else if (DataValueTypeEnum.Date == dataType) {
            prop = new DateProp();
        } else if (DataValueTypeEnum.BaseProp == dataType) {
            BasedataProp bdp = new BasedataProp();
            if ("bd_measureunits".equalsIgnoreCase(field.getNumber())) {
                bdp = new UnitProp();
            } else if ("bd_currency".equalsIgnoreCase(field.getNumber())) {
                bdp = new CurrencyProp();
            }
            DataModelMetaUtils.initBasedataProp(bdp, field);
            prop = bdp;
        } else if (DataValueTypeEnum.AssistProp == dataType) {
            AssistantProp atp = new AssistantProp();
            DataModelMetaUtils.initAssistantProp(atp, field);
            prop = atp;
        } else if (DataValueTypeEnum.Bool == dataType) {
            prop = new BooleanProp();
        } else if (DataValueTypeEnum.Int == dataType) {
            prop = new IntegerProp();
        }
        return prop;
    }

    private static void initAssistantProp(AssistantProp p, DataModelFieldCfg field) {
        Long refAssistProp = field.getRefAssistProp();
        DynamicObject assistProp = BusinessDataServiceHelper.loadSingle((Object)refAssistProp, (String)"bos_assistantdatagroup");
        String pkValue = assistProp.getString("id");
        String typeId = assistProp.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bos_assistantdata_detail");
        p.setComplexType((IDataEntityType)entityType);
        p.setBaseEntityId("bos_assistantdata_detail");
        p.setAsstTypeId(typeId);
        p.setName(pkValue);
        Object idProp = null;
        idProp = entityType.getPrimaryKey() instanceof LongProp ? new LongProp() : new VarcharProp();
        idProp.setDbIgnore(true);
        p.setRefIdProp((IDataEntityProperty)idProp);
        p.setDisplayProp(field.getName());
        p.setAsstParentId(pkValue);
        p.setAsstTypeId(pkValue);
    }

    private static void initBasedataProp(BasedataProp p, DataModelFieldCfg field) {
        String entryId = field.getRefBaseProp();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryId);
        p.setComplexType((IDataEntityType)entityType);
        p.setBaseEntityId(entryId);
        Object idProp = null;
        idProp = entityType.getPrimaryKey() instanceof LongProp ? new LongProp() : new VarcharProp();
        idProp.setDbIgnore(true);
        p.setRefIdProp((IDataEntityProperty)idProp);
        p.setDisplayProp(field.getName());
    }
}

