/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.ExtractModeEnum;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.dao.event.FahEventRuleCfgDAO;
import kd.fi.v2.fah.models.event.eventrule.BizDimGetValueCfgDTO;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldCfg;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineCfg;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineGroup;
import kd.fi.v2.fah.models.event.eventrule.EventRuleModelCfg;
import kd.fi.v2.fah.models.event.eventrule.EvtLineDimGrpGetValueCfgCollection;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.utils.DynFieldValueSetUtil;
import kd.fi.v2.fah.utils.ExtractFieldUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class EventRuleUtils {
    public static final String SOURCEBILL_PK_ALIAS = "srcbill_pk";
    public static final String SOURCEBILL_NUMBER_ALIAS = "srcbill_num";
    public static final String SOURCEBILL_ORG_NUMBER_ALIAS = "srcbill_orgnum";
    public static final String SOURCEBILL_BIZDATE_NUMBER_ALIAS = "srcbill_bizdate";
    public static final String SOURCEBILL_ACCTDATE_NUMBER_ALIAS = "srcbill_acctdate";
    public static final String SOURCEBILL_ENTRY_PK_ALIAS = "srcbill_entrypk";
    public static final String SOURCEBILL_SUBENTRY_PK_ALIAS = "srcbill_subentrypk";
    private static final Log logger = LogFactory.getLog(EventRuleUtils.class);

    public static List<ComboItem> createComboItems(MainEntityType mainEntityType, Map<String, DataValueTypeEnum> fieldDataTypeMap, DataValueTypeEnum type) {
        LinkedList<ComboItem> items = new LinkedList<ComboItem>();
        EventRuleUtils.buildComboItemList((EntityType)mainEntityType, items, fieldDataTypeMap, type);
        return items;
    }

    private static void buildComboItemList(EntityType mainEntityType, List<ComboItem> items, Map<String, DataValueTypeEnum> fieldDataTypeMap, DataValueTypeEnum type) {
        StringBuilder parentValue = new StringBuilder();
        EventRuleUtils.generateParentValue(parentValue, (IDataEntityType)mainEntityType);
        StringBuilder parentCaption = new StringBuilder();
        EventRuleUtils.generateParentCaption(parentCaption, (IDataEntityType)mainEntityType);
        for (IDataEntityProperty property : mainEntityType.getProperties()) {
            if (property instanceof EntryProp) {
                EntityType subEntityType = (EntityType)((EntryProp)property).getItemType();
                EventRuleUtils.buildComboItemList(subEntityType, items, fieldDataTypeMap, type);
                continue;
            }
            if (StringUtils.isEmpty(property.getDisplayName())) continue;
            String caption = parentCaption + property.getDisplayName().toString();
            String value = parentValue + property.getName();
            ComboItem comboItem = new ComboItem(new LocaleString(caption), value);
            items.add(comboItem);
            EventRuleUtils.fillFieldDataTypeMap(fieldDataTypeMap, property, value);
        }
    }

    public static void generateParentCaption(StringBuilder sb, IDataEntityType entityType) {
        if (entityType.getParent() != null) {
            sb.insert(0, '.');
            sb.insert(0, entityType.getDisplayName().toString());
            EventRuleUtils.generateParentCaption(sb, entityType.getParent());
        }
    }

    public static void generateParentValue(StringBuilder sb, IDataEntityType entityType) {
        if (entityType.getParent() != null) {
            sb.insert(0, '.');
            sb.insert(0, entityType.getName());
            EventRuleUtils.generateParentValue(sb, entityType.getParent());
        }
    }

    private static void fillFieldDataTypeMap(Map<String, DataValueTypeEnum> fieldDataTypeMap, IDataEntityProperty property, String value) {
        if (property instanceof DateProp || property instanceof DateTimeProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Date);
        } else if (property instanceof BasedataProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.BaseProp);
        } else if (property instanceof AssistantProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.AssistProp);
        } else if (property instanceof DecimalProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Decimal);
        } else if (property instanceof IntegerProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Int);
        } else if (property instanceof BooleanProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Bool);
        } else if (property instanceof TextProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.String);
        } else if (property instanceof AmountProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Amount);
        } else if (property instanceof EntryProp) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Entry);
        } else if (property.getPropertyType() == String.class) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.String);
        } else if (property.getPropertyType() == Integer.class) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Int);
        } else if (property.getPropertyType() == Boolean.class) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Bool);
        } else if (property.getPropertyType() == Date.class) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Date);
        } else if (property.getPropertyType() == BigDecimal.class) {
            fieldDataTypeMap.put(value, DataValueTypeEnum.Decimal);
        }
    }

    public static EventRuleModelCfg loadEventRuleModel(Long id) {
        DynamicObject obj = FahEventRuleCfgDAO.loadEventRuleDyn(id);
        if (obj == null) {
            return null;
        }
        return EventRuleUtils.generateEventRuleModelByDyn(obj);
    }

    public static EventRuleModelCfg generateEventRuleModelByDyn(DynamicObject obj) {
        EventRuleModelCfg model = new EventRuleModelCfg();
        model.setId(obj.getLong("id"));
        model.setNumber(obj.getString("number"));
        model.setName(obj.getString("name"));
        model.setSourcePage(obj.getString("group.number"));
        model.setSourceEntry(obj.getString("sourceentry"));
        model.setBizOrgNum(obj.getString("bizorg"));
        model.setBizDateNum(obj.getString("bizdate"));
        model.setNeedAcct(obj.getBoolean("needacct"));
        model.setAcctDateNum(obj.getString("bookeddate"));
        model.setEventClassId(obj.getLong("eventclass.id"));
        model.setEventTypeId(obj.getLong("eventtype.id"));
        model.setMasterId(obj.getLong("masterid"));
        model.setStatus(obj.getString("status"));
        model.setEnable(obj.getBoolean("enable"));
        model.setCreator(obj.getLong("creator.id"));
        model.setModifier(obj.getLong("modifier.id"));
        model.setEnabledBy(obj.getLong("enabledby.id"));
        model.setDisabledBy(obj.getLong("disabledby.id"));
        model.setCreateTime(obj.getDate("createtime"));
        model.setModifyTime(obj.getDate("modifytime"));
        model.setEnabledTime(obj.getDate("enabledtime"));
        model.setDisabledTime(obj.getDate("disabledtime"));
        DynamicObjectCollection evtruleLines = obj.getDynamicObjectCollection("evtrule_line");
        if (!evtruleLines.isEmpty()) {
            ArrayList<EventRuleLineCfg> lines = new ArrayList<EventRuleLineCfg>(evtruleLines.size());
            Integer index = 0;
            for (DynamicObject evtruleLine : evtruleLines) {
                DynamicObjectCollection bizdims;
                DynamicExtractFieldValueSetData currency;
                EventRuleLineCfg line = new EventRuleLineCfg();
                line.setParent(model);
                line.setId(evtruleLine.getLong("id"));
                line.setSeq(evtruleLine.getInt("seq"));
                line.setEventLineTypeId(evtruleLine.getLong("entry_linetype.id"));
                line.setEnable(evtruleLine.getBoolean("entry_enable"));
                line.setAmountId(evtruleLine.getLong("entry_amountid"));
                DynamicExtractFieldValueSetData amount = ExtractFieldUtils.loadDynamicExtractFieldValueSetData(evtruleLine.getLong("entry_amountid"));
                if (amount != null) {
                    model.getDynamicExtractFieldCfgs().add(amount);
                    line.setAmountCfg(amount);
                }
                if ((currency = ExtractFieldUtils.loadDynamicExtractFieldValueSetData(evtruleLine.getLong("entry_currencyid"))) != null) {
                    model.getDynamicExtractFieldCfgs().add(currency);
                    line.setCurrencyCfg(currency);
                }
                if ((bizdims = evtruleLine.getDynamicObjectCollection("dimextract")) != null) {
                    EvtLineDimGrpGetValueCfgCollection bizDimGrpGetValueCfgs = new EvtLineDimGrpGetValueCfgCollection();
                    bizDimGrpGetValueCfgs.setEvtLineRuleId(evtruleLine.getLong("id"));
                    DynamicObject dynamicObject = (DynamicObject)evtruleLine.get("bizdim");
                    if (null != dynamicObject) {
                        bizDimGrpGetValueCfgs.setDimGrpTypeId(dynamicObject.getLong("id"));
                    }
                    int dimIndex = 0;
                    for (DynamicObject bizdim : bizdims) {
                        DynamicExtractFieldValueSetData sub_customvalue;
                        BizDimGetValueCfgDTO valueCfgDTO = new BizDimGetValueCfgDTO();
                        valueCfgDTO.setId(bizdim.getLong("id"));
                        valueCfgDTO.setIndex(dimIndex);
                        valueCfgDTO.setDimInnerId(bizdim.getLong("diminnerid"));
                        long presetValueId = bizdim.getLong("sub_presetvalueid");
                        long subCustomValueId = bizdim.getLong("sub_customvalueid");
                        valueCfgDTO.setSysPresetCfgGrpId(presetValueId);
                        valueCfgDTO.setCustomCfgGrpId(subCustomValueId);
                        DynamicExtractFieldValueSetData sub_presetvalue = ExtractFieldUtils.loadDynamicExtractFieldValueSetData(presetValueId);
                        if (sub_presetvalue != null) {
                            model.getDynamicExtractFieldCfgs().add(sub_presetvalue);
                            valueCfgDTO.setSysPresetCfgGrp(sub_presetvalue);
                        }
                        if ((sub_customvalue = ExtractFieldUtils.loadDynamicExtractFieldValueSetData(subCustomValueId)) != null) {
                            model.getDynamicExtractFieldCfgs().add(sub_customvalue);
                            valueCfgDTO.setCustomCfgGrp(sub_customvalue);
                        }
                        bizDimGrpGetValueCfgs.add(valueCfgDTO);
                        ++dimIndex;
                    }
                    line.setBizDimGrpGetValueCfgs(bizDimGrpGetValueCfgs);
                }
                lines.add(line);
                model.setEventRuleLineCfgs(lines);
            }
        }
        if (Boolean.parseBoolean(SysParamConfig.get("fah.evt.groupingRuleLine.version.new", "false"))) {
            EventRuleUtils.groupingRuleLineV2(model);
        } else {
            EventRuleUtils.groupingRuleLine(model);
        }
        EventRuleUtils.generateFieldAliasInfo(model);
        return model;
    }

    private static void generateFieldAliasInfo(EventRuleModelCfg model) {
        if (model.getEventRuleLineGroups().size() > 0) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)model.getSourcePage());
            LinkedList<FieldAliasInfo> headInfos = new LinkedList<FieldAliasInfo>();
            FieldAliasInfo billPK = new FieldAliasInfo(mainEntityType.getPrimaryKey().getName(), SOURCEBILL_PK_ALIAS, mainEntityType.getPrimaryKey().getName());
            headInfos.add(billPK);
            String billNoFormBill = DapBuildVoucherCommonUtil.getBillNoFormBill(model.getSourcePage());
            FieldAliasInfo billNO = new FieldAliasInfo(billNoFormBill, SOURCEBILL_NUMBER_ALIAS, billNoFormBill);
            headInfos.add(billNO);
            FieldAliasInfo billORG = new FieldAliasInfo(model.getBizOrgNum(), SOURCEBILL_ORG_NUMBER_ALIAS, model.getBizOrgNum());
            headInfos.add(billORG);
            FieldAliasInfo bizDate = new FieldAliasInfo(model.getBizDateNum(), SOURCEBILL_BIZDATE_NUMBER_ALIAS, model.getBizDateNum());
            headInfos.add(bizDate);
            if (StringUtils.isNotEmpty((String)model.getAcctDateNum())) {
                FieldAliasInfo acctDate = new FieldAliasInfo(model.getAcctDateNum(), SOURCEBILL_ACCTDATE_NUMBER_ALIAS, model.getAcctDateNum());
                headInfos.add(acctDate);
            }
            String sourceEntry = model.getSourceEntry();
            EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(sourceEntry);
            EventRuleUtils.addPkFieldAliasInfo((IDataEntityType)entityType, headInfos::add);
            String headOrderBy = EventRuleUtils.getOrderBy((IDataEntityType)entityType);
            model.setOrderBy(headOrderBy);
            for (FieldAliasInfo headinfo : headInfos) {
                model.getFieldAliasInfos().add(headinfo);
            }
            int headIndex = 0;
            for (FieldAliasInfo headinfo : model.getFieldAliasInfos()) {
                headinfo.setWritePos(headIndex);
                headinfo.setReadPos(headIndex);
                ++headIndex;
            }
            for (EventRuleLineGroup group : model.getEventRuleLineGroups()) {
                TreeMap<String, String> longAndShortFieldMap = new TreeMap<String, String>();
                MainEntityType dataEntityType = mainEntityType;
                for (EventRuleLineCfg eventRuleLineCfg : group.getEventRuleLineCfgs()) {
                    eventRuleLineCfg.setGroup(group);
                    IDataEntityType amountFieldDataEntityType = EventRuleUtils.generateDynamicExtractFieldCfg(eventRuleLineCfg.getAmountCfg(), model.getSourcePage(), longAndShortFieldMap);
                    if (amountFieldDataEntityType instanceof SubEntryType && !(dataEntityType instanceof SubEntryType)) {
                        dataEntityType = amountFieldDataEntityType;
                    } else if (amountFieldDataEntityType instanceof EntryType && !(dataEntityType instanceof EntryType)) {
                        dataEntityType = amountFieldDataEntityType;
                    }
                    eventRuleLineCfg.initAmountPKAlias(amountFieldDataEntityType);
                    EventRuleUtils.generateDynamicExtractFieldCfg(eventRuleLineCfg.getCurrencyCfg(), model.getSourcePage(), longAndShortFieldMap);
                }
                for (FieldAliasInfo fieldAliasInfo : headInfos) {
                    longAndShortFieldMap.remove(fieldAliasInfo.getQueryFieldNumber());
                    group.getFieldAliasInfos().add(fieldAliasInfo);
                }
                EventRuleUtils.addPkFieldAliasInfo((IDataEntityType)dataEntityType, group.getFieldAliasInfos()::add);
                int index = 0;
                for (FieldAliasInfo fieldAliasInfo : group.getFieldAliasInfos()) {
                    fieldAliasInfo.setWritePos(index);
                    fieldAliasInfo.setReadPos(index);
                    ++index;
                }
                for (Map.Entry fieldEntry : longAndShortFieldMap.entrySet()) {
                    FieldAliasInfo info = new FieldAliasInfo((String)fieldEntry.getValue(), "f" + index, (String)fieldEntry.getKey());
                    info.setReadPos(index);
                    info.setWritePos(index);
                    group.getFieldAliasInfos().add(info);
                    ++index;
                }
                String string = EventRuleUtils.getOrderBy((IDataEntityType)dataEntityType);
                group.setOrderBy(string);
            }
        }
    }

    private static void addPkFieldAliasInfo(IDataEntityType entityType, Consumer<FieldAliasInfo> addMethod) {
        if (entityType instanceof SubEntryType) {
            String entryPkNum = entityType.getParent().getName() + '.' + entityType.getParent().getPrimaryKey().getName();
            FieldAliasInfo entryPk = new FieldAliasInfo(entryPkNum, SOURCEBILL_ENTRY_PK_ALIAS, entryPkNum);
            addMethod.accept(entryPk);
            String subEntryPKNum = entityType.getParent().getName() + '.' + entityType.getName() + '.' + entityType.getPrimaryKey().getName();
            FieldAliasInfo subEntryPK = new FieldAliasInfo(subEntryPKNum, SOURCEBILL_SUBENTRY_PK_ALIAS, subEntryPKNum);
            addMethod.accept(subEntryPK);
        } else if (entityType instanceof EntryType) {
            String entryPkNum = entityType.getName() + '.' + entityType.getPrimaryKey().getName();
            FieldAliasInfo entryPk = new FieldAliasInfo(entryPkNum, SOURCEBILL_ENTRY_PK_ALIAS, entryPkNum);
            addMethod.accept(entryPk);
        }
    }

    private static String getOrderBy(IDataEntityType dataEntityType) {
        if (dataEntityType instanceof SubEntryType) {
            String pkNum = dataEntityType.getParent().getParent().getPrimaryKey().getName();
            String entryPkNum = dataEntityType.getParent().getName() + "." + dataEntityType.getParent().getPrimaryKey().getName();
            String subEntryPkNum = dataEntityType.getParent().getName() + "." + dataEntityType.getName() + "." + dataEntityType.getPrimaryKey().getName();
            return pkNum + "," + entryPkNum + "," + subEntryPkNum;
        }
        if (dataEntityType instanceof EntryType) {
            String pkNum = dataEntityType.getParent().getPrimaryKey().getName();
            String entryPkNum = dataEntityType.getName() + "." + dataEntityType.getPrimaryKey().getName();
            return pkNum + "," + entryPkNum;
        }
        return dataEntityType.getPrimaryKey().getName();
    }

    private static void groupingRuleLine(EventRuleModelCfg model) {
        List<EventRuleLineCfg> eventRuleLineCfgs = model.getEventRuleLineCfgs();
        EventRuleLineGroup headLineGroup = new EventRuleLineGroup();
        if (eventRuleLineCfgs.isEmpty()) {
            return;
        }
        HashMap<String, EventRuleLineGroup> map = new HashMap<String, EventRuleLineGroup>(16);
        for (EventRuleLineCfg lineCfg : eventRuleLineCfgs) {
            String amountShortNumber = lineCfg.fetchAmountNumber();
            if (StringUtils.isEmpty((String)amountShortNumber)) continue;
            IDataEntityType entityType = EventRuleUtils.getFieldEntityTypeByField(model.getSourcePage(), amountShortNumber);
            String amountFullNumber = EventRuleUtils.getFieldFullNumByBillType(model.getSourcePage(), amountShortNumber);
            if (StringUtils.isEmpty((String)amountFullNumber)) continue;
            if (EventRuleUtils.isHeadEntity(entityType)) {
                headLineGroup.addEventRuleLineCfg(lineCfg);
                continue;
            }
            List<String> matchedKeys = EventRuleUtils.findMatchingKeys(map, EventRuleUtils.getPrefix(entityType));
            if (matchedKeys.size() == 0) {
                EventRuleLineGroup group = new EventRuleLineGroup();
                group.addEventRuleLineCfg(lineCfg);
                map.put(EventRuleUtils.getPrefix(entityType), group);
                continue;
            }
            String key = EventRuleUtils.findMinGroupMemberKey(map, matchedKeys);
            EventRuleLineGroup lineGroup = (EventRuleLineGroup)map.get(key);
            lineGroup.addEventRuleLineCfg(lineCfg);
            String newKey = EventRuleUtils.getPrefix(entityType);
            if (key == null || newKey.length() <= key.length()) continue;
            map.put(newKey, lineGroup);
            map.remove(key);
        }
        String minGroupMemberKey = EventRuleUtils.findMinGroupMemberKey(map, null);
        if (StringUtils.isEmpty((String)minGroupMemberKey)) {
            model.getEventRuleLineGroups().add(headLineGroup);
        } else {
            ((EventRuleLineGroup)map.get(minGroupMemberKey)).addCfgGroup(headLineGroup);
        }
        model.getEventRuleLineGroups().addAll(map.values());
    }

    private static void groupingRuleLineV2(EventRuleModelCfg model) {
        List<EventRuleLineCfg> eventRuleLineCfgs = model.getEventRuleLineCfgs();
        if (eventRuleLineCfgs.isEmpty()) {
            return;
        }
        HashMap<String, Set<String>> fieldGroupMap = new HashMap<String, Set<String>>(16);
        HashMap<String, EventRuleLineGroup> eventRuleLineGroupMap = new HashMap<String, EventRuleLineGroup>(16);
        HashMap<String, List> amountShortNumberLineCfgMap = new HashMap<String, List>(eventRuleLineCfgs.size());
        for (EventRuleLineCfg lineCfg : eventRuleLineCfgs) {
            String amountShortNumber = lineCfg.fetchAmountNumber();
            if (StringUtils.isEmpty((String)amountShortNumber)) continue;
            amountShortNumberLineCfgMap.computeIfAbsent(amountShortNumber, k -> new LinkedList()).add(lineCfg);
            IDataEntityType entityType = EventRuleUtils.getFieldEntityTypeByField(model.getSourcePage(), amountShortNumber);
            fieldGroupMap.computeIfAbsent(EventRuleUtils.getPrefix(entityType), k -> new TreeSet()).add(amountShortNumber);
        }
        Map<String, Set<String>> mergedFieldGroupMap = EventRuleUtils.mergeFieldGroup(fieldGroupMap);
        logger.info("beforeMerge: {}, afterMerge: {}", fieldGroupMap, mergedFieldGroupMap);
        for (Map.Entry<String, Set<String>> mergedFieldGroupEntry : mergedFieldGroupMap.entrySet()) {
            EventRuleLineGroup eventRuleLineGroup = eventRuleLineGroupMap.computeIfAbsent(mergedFieldGroupEntry.getKey(), k -> new EventRuleLineGroup());
            for (String amountShortNumber : mergedFieldGroupEntry.getValue()) {
                for (EventRuleLineCfg lineCfg : (List)amountShortNumberLineCfgMap.get(amountShortNumber)) {
                    eventRuleLineGroup.addEventRuleLineCfg(lineCfg);
                }
            }
        }
        model.getEventRuleLineGroups().addAll(eventRuleLineGroupMap.values());
    }

    public static Map<String, Set<String>> mergeFieldGroup(Map<String, Set<String>> fieldGroupMap) {
        HashMap<String, Set> groupMap = new HashMap<String, Set>(8);
        for (String fieldGroupA : fieldGroupMap.keySet()) {
            for (String fieldGroupB : fieldGroupMap.keySet()) {
                if (Objects.equals(fieldGroupA, fieldGroupB) || !fieldGroupB.startsWith(fieldGroupA)) continue;
                groupMap.computeIfAbsent(fieldGroupA, k -> new TreeSet()).add(fieldGroupB);
            }
        }
        HashMap<String, Set<String>> mergedFieldGroupMap = new HashMap<String, Set<String>>(fieldGroupMap.size());
        for (Map.Entry<String, Set<String>> fieldGroupEntry : fieldGroupMap.entrySet()) {
            String group = fieldGroupEntry.getKey();
            Set subLevelGroups = (Set)groupMap.get(group);
            if (CollectionUtils.isEmpty((Collection)subLevelGroups)) {
                mergedFieldGroupMap.put(group, fieldGroupEntry.getValue());
                continue;
            }
            String minFieldsCntGroup = null;
            int minFieldsCnt = Integer.MAX_VALUE;
            for (String subLevelGroup : subLevelGroups) {
                int fieldsCnt = fieldGroupMap.get(subLevelGroup).size();
                if (minFieldsCnt <= fieldsCnt) continue;
                minFieldsCnt = fieldsCnt;
                minFieldsCntGroup = subLevelGroup;
            }
            fieldGroupMap.get(minFieldsCntGroup).addAll((Collection<String>)fieldGroupEntry.getValue());
        }
        return mergedFieldGroupMap;
    }

    private static boolean isHeadEntity(IDataEntityType entityType) {
        return entityType.getParent() == null;
    }

    public static String getFieldFullNumByBillType(String billType, String shortFieldNumber) {
        IDataEntityType entityType = EventRuleUtils.getFieldEntityTypeByField(billType, shortFieldNumber);
        return EventRuleUtils.getFieldFullNum(entityType, shortFieldNumber);
    }

    public static IDataEntityType getFieldEntityTypeByField(String billType, String shortFieldNumber) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        String currBillTypeFieldNum = shortFieldNumber.contains(".") ? shortFieldNumber.substring(0, shortFieldNumber.indexOf(".")) : shortFieldNumber;
        IDataEntityProperty property = mainEntityType.findProperty(currBillTypeFieldNum);
        return property.getParent();
    }

    private static String getPrefix(IDataEntityType entityType) {
        if (entityType instanceof SubEntryType) {
            return entityType.getParent().getName() + "." + entityType.getName();
        }
        if (entityType instanceof EntryType) {
            return entityType.getName();
        }
        return "";
    }

    private static String findMinGroupMemberKey(Map<String, EventRuleLineGroup> map, List<String> matchedKeys) {
        String key = null;
        if (matchedKeys != null && matchedKeys.size() > 0) {
            for (String matchedKey : matchedKeys) {
                if (key == null) {
                    key = matchedKey;
                    continue;
                }
                if (map.get(matchedKey).size() >= map.get(key).size()) continue;
                key = matchedKey;
            }
        } else {
            for (Map.Entry<String, EventRuleLineGroup> entrySet : map.entrySet()) {
                if (key == null) {
                    key = entrySet.getKey();
                    continue;
                }
                if (entrySet.getValue().size() >= map.get(key).size()) continue;
                key = entrySet.getKey();
            }
        }
        return key;
    }

    private static List<String> findMatchingKeys(Map<String, EventRuleLineGroup> map, String prefix) {
        ArrayList<String> result = new ArrayList<String>(3);
        List<String> split = EventRuleUtils.getLayerInfo(prefix);
        for (String key : map.keySet()) {
            List<String> keySplit = EventRuleUtils.getLayerInfo(key);
            if (!key.equals(prefix) && (keySplit.size() <= split.size() || !keySplit.contains(prefix)) && (split.size() <= keySplit.size() || !split.contains(key))) continue;
            result.add(key);
        }
        return result;
    }

    private static List<String> getLayerInfo(String key) {
        String[] split = key.split("\\.");
        ArrayList<String> result = new ArrayList<String>(split.length - 1);
        for (int i = 0; i < split.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                sb.append(split[j]).append(".");
            }
            sb.deleteCharAt(sb.lastIndexOf("."));
            result.add(sb.toString());
        }
        return result;
    }

    public static IDataEntityType generateDynamicExtractFieldCfg(DynamicExtractFieldValueSetData fieldCfgData, String billType, Map<String, String> longAndShortFieldMap) {
        if (fieldCfgData == null) {
            return null;
        }
        IDataEntityType amountFieldDataEntityType = null;
        for (DynamicExtractFieldValueSet fieldCfg : fieldCfgData.getFieldValueSetList()) {
            String[] varStrings;
            if (ExtractTypeEnum.SOURCE_FIELD == fieldCfg.getGetValueType()) {
                String sourceField = fieldCfg.getTextValue();
                String fieldFullNum = EventRuleUtils.getFieldFullNumByBillType(billType, sourceField);
                longAndShortFieldMap.put(fieldFullNum, sourceField);
                String currBillTypeFieldNum = sourceField.contains(".") ? sourceField.substring(0, sourceField.indexOf(".")) : sourceField;
                IDataEntityProperty property = MetadataServiceHelper.getDataEntityType((String)billType).findProperty(currBillTypeFieldNum);
                IDataEntityType dataEntityType = property.getParent();
                if (dataEntityType instanceof SubEntryType && !(amountFieldDataEntityType instanceof SubEntryType)) {
                    amountFieldDataEntityType = dataEntityType;
                    continue;
                }
                if (!(dataEntityType instanceof EntryType) || amountFieldDataEntityType instanceof EntryType) continue;
                amountFieldDataEntityType = dataEntityType;
                continue;
            }
            if (ExtractTypeEnum.EXPRESSION != fieldCfg.getGetValueType()) continue;
            String expression = fieldCfg.getExpressionValue();
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)expression, VchTplExpression.class);
            for (String field : varStrings = FormulaEngine.extractVariables((String)filterObj.getExpression())) {
                longAndShortFieldMap.put(EventRuleUtils.getFieldFullNumByBillType(billType, field), field);
            }
        }
        return amountFieldDataEntityType;
    }

    public static void showDynamicExtractFieldForm(IFormView view, Long id, IFormPlugin plugin, String sourcePage, String sourceField, String sourceBill, String entryNumber, DynamicExtractFieldValueSetData model) {
        EventRuleUtils.showDynamicExtractFieldForm(view, id, plugin, sourcePage, sourceField, sourceBill, entryNumber, model, false);
    }

    public static void showDynamicExtractFieldForm(IFormView view, Long id, IFormPlugin plugin, String sourcePage, String sourceField, String sourceBill, String entryNumber, DynamicExtractFieldValueSetData model, boolean isOpenDirectFrom) {
        DynamicExtractFieldCfg fieldCfg = ExtractFieldUtils.loadDynamicExtractFieldCfg(sourcePage, sourceField);
        if (null == fieldCfg) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u672a\u914d\u7f6e\u52a8\u6001\u5b57\u6bb5\u53d6\u503c\u914d\u7f6e\u3002", (String)"EventRuleUtils_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return;
        }
        List<ExtractModeEnum> functions = fieldCfg.getEnableFunctions();
        String formId = "fah_dyn_extfld_setdetail";
        if (null != functions) {
            functions.removeIf(f -> ExtractModeEnum.FILTER_CONDITION == f);
        }
        if (null == functions || functions.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u672a\u914d\u7f6e\u53d6\u503c\u65b9\u5f0f\u3002", (String)"EventRuleUtils_1", (String)"fi-ai-common", (Object[])new Object[0]));
            return;
        }
        String functionExt = (String)view.getFormShowParameter().getCustomParam("function_ext");
        if (StringUtils.isNotEmpty((String)functionExt)) {
            functions.addAll(0, (Collection)SerializationUtils.deSerializeFromBase64((String)functionExt));
        }
        if (isOpenDirectFrom && functions.size() == 1) {
            view.getFormShowParameter().setCustomParam("sourcePage", (Object)sourcePage);
            view.getFormShowParameter().setCustomParam("sourcePageField", (Object)sourceField);
            view.getFormShowParameter().setCustomParam("sourcePageId", (Object)id);
            view.getFormShowParameter().setCustomParam("entryNumber", (Object)entryNumber);
            if (StringUtils.isNotEmpty((String)sourceBill)) {
                view.getFormShowParameter().setCustomParam("sourceBill", (Object)sourceBill);
            }
            if (model != null) {
                view.getFormShowParameter().setCustomParam("SOURCE_MODEL", (Object)SerializationUtils.serializeToBase64((Object)model));
            }
            ExtractModeEnum modeEnum = functions.get(0);
            String actionId = sourceField + "#";
            switch (modeEnum) {
                case CONSTANT: {
                    DynFieldValueSetUtil.showConstantForm(view, plugin, actionId, fieldCfg, model);
                    break;
                }
                case EXPRESSION: {
                    DynFieldValueSetUtil.showExpressionForm(view, plugin, actionId, model);
                    break;
                }
                case MAPPING: {
                    DynFieldValueSetUtil.showMappingForm(view, plugin, actionId, model);
                    break;
                }
                case BILL_FIELD: {
                    DynFieldValueSetUtil.showBillFieldTreeForm(view, plugin, actionId);
                    break;
                }
            }
        } else {
            String param;
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack(plugin, sourceField));
            parameter.setCustomParam("sourcePage", (Object)sourcePage);
            parameter.setCustomParam("sourcePageField", (Object)sourceField);
            parameter.setCustomParam("sourcePageId", (Object)id);
            parameter.setCustomParam("entryNumber", (Object)entryNumber);
            parameter.setCustomParam("function_ext", (Object)functionExt);
            parameter.setCustomParam("dyn_param", view.getFormShowParameter().getCustomParam("dyn_param"));
            if (StringUtils.isNotEmpty((String)sourceBill)) {
                parameter.setCustomParam("sourceBill", (Object)sourceBill);
            }
            if (model != null) {
                parameter.setCustomParam("SOURCE_MODEL", (Object)SerializationUtils.serializeToBase64((Object)model));
            }
            if (StringUtils.isNotEmpty((String)(param = (String)view.getFormShowParameter().getCustomParam("param")))) {
                parameter.setCustomParam("param", (Object)param);
            }
            view.showForm(parameter);
        }
    }

    public static String getFieldFullNum(IDataEntityType entityType, String fieldNum) {
        String fieldFullNum = entityType instanceof SubEntryType ? entityType.getParent().getName() + "." + entityType.getName() + "." + fieldNum : (entityType instanceof EntryType ? entityType.getName() + "." + fieldNum : fieldNum);
        return fieldFullNum;
    }
}

