/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.constant.enums.CreateTypeEnum;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.context.ExtDataSaveCtx;
import kd.fi.v2.fah.converters.ObjectConvertHelper;
import kd.fi.v2.fah.converters.basedata.IDConverterHelper;
import kd.fi.v2.fah.models.dynamic.SimpleBasedataProp;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicCollectionProperty;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicMetadata;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObjectType;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicProperty;
import kd.fi.v2.fah.models.dynamic.SimpleEntityPropertyCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.validator.AbValidatorChain;
import kd.fi.v2.fah.validator.FieldValueValidateHelper;

public class ExtDataSdoHelper {
    private static final Log logger = LogFactory.getLog(ExtDataSdoHelper.class);
    private static final int DEFAULT_ENTRY_START_INDEX = 0;
    private ExtDataSaveCtx extDataSaveCtx;
    private ExtDataApiTypeEnum apiType = ExtDataApiTypeEnum.ImportData;

    public ExtDataSdoHelper(ExtDataSaveCtx extDataSaveCtx) {
        this.extDataSaveCtx = extDataSaveCtx;
    }

    public void parseFromJsonString(SimpleDynamicObject sdo, String jsonString) {
        JSONObject jsonObject = JSON.parseObject((String)jsonString, (Feature[])new Feature[]{Feature.UseBigDecimal});
        this.setDefaultValue(sdo);
        this.parseWithCheck(sdo, jsonObject);
    }

    private void parseWithCheck(SimpleDynamicObject sdo, JSONObject jsonObject) {
        Map<String, PairTuple<DataModelFieldCfg, AbValidatorChain>> fieldCfgAndValidatorsMap = this.extDataSaveCtx.getFieldCfgAndValidatorsMap();
        SimpleEntityPropertyCollection props = sdo.getDynamicObjectType().getProps();
        HashSet<String> fieldInJsonSet = new HashSet<String>(props.size());
        Map<String, String> fieldMap = this.extDataSaveCtx.getFieldNumMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            Object newValue;
            AbValidatorChain validator;
            String apiFieldNum = (String)entry.getKey();
            String fieldNum = fieldMap.get(apiFieldNum);
            if (StringUtils.isEmpty((String)fieldNum)) continue;
            Object fieldValue = entry.getValue();
            SimpleDynamicProperty prop = (SimpleDynamicProperty)props.get(fieldNum);
            if (null == prop) {
                if (!DebugTrace.enable()) continue;
                logger.info("not found field in ext data meta, apiFieldNum: {}, fieldNum: {}, fieldMap: {}, props: {}", new Object[]{apiFieldNum, fieldNum, JSON.toJSONString(fieldMap), JSON.toJSONString((Object)props.toString())});
                continue;
            }
            fieldInJsonSet.add(fieldNum.toLowerCase());
            if (prop instanceof SimpleDynamicCollectionProperty && fieldValue instanceof JSONArray) {
                SimpleDynamicCollectionProperty propsCollection = (SimpleDynamicCollectionProperty)prop;
                JSONArray fieldValueArray = (JSONArray)fieldValue;
                SimpleDynamicObject[] entries = this.parseEntry(propsCollection, fieldValueArray, sdo);
                propsCollection.setValueFast(sdo, entries);
                continue;
            }
            PairTuple<DataModelFieldCfg, AbValidatorChain> dataModelFieldCfgAbValidatorTuple = fieldCfgAndValidatorsMap.get(fieldNum);
            if (null == dataModelFieldCfgAbValidatorTuple) {
                if (!DebugTrace.enable()) continue;
                logger.info("\u5b57\u6bb5[{}]\u6ca1\u6709\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f, \u6a21\u578b\u5b57\u6bb5: [{}]", (Object)fieldNum, fieldCfgAndValidatorsMap.keySet());
                continue;
            }
            DataModelFieldCfg fieldCfg = (DataModelFieldCfg)dataModelFieldCfgAbValidatorTuple.getKey();
            if (!fieldCfg.getEnable().booleanValue()) continue;
            if (StringUtils.isEmpty(fieldValue)) {
                prop.setValueFast(sdo, null);
                if (fieldCfg.isRequired()) {
                    if (StringUtils.isEmpty((String)fieldCfg.getRequiredCondition()) || this.apiType == ExtDataApiTypeEnum.AppendEntries) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e3a\u7a7a", (String)"ExtDataSdoHelper_0", (String)"fi-ai-common", (Object[])new Object[0]), apiFieldNum);
                        this.extDataSaveCtx.addErrorMsg(msg, fieldCfg, sdo, fieldValue);
                        continue;
                    }
                    this.extDataSaveCtx.addRequiredConditionField(fieldNum);
                    continue;
                }
            }
            if (FieldValueValidateHelper.validate(fieldCfg, validator = (AbValidatorChain)dataModelFieldCfgAbValidatorTuple.getValue(), fieldValue, sdo)) {
                newValue = ObjectConvertHelper.convert(prop.getPropertyType(), fieldValue);
                this.collectNum(fieldCfg, fieldValue);
            } else {
                newValue = null;
            }
            prop.setValueFast(sdo, newValue);
        }
        for (SimpleDynamicProperty prop : props) {
            Object fieldValue;
            String fieldNum = prop.getName().toLowerCase();
            if (fieldInJsonSet.contains(fieldNum) || null != (fieldValue = prop.getValueFast(sdo))) continue;
            PairTuple<DataModelFieldCfg, AbValidatorChain> dataModelFieldCfgAbValidatorTuple = fieldCfgAndValidatorsMap.get(fieldNum);
            if (null == dataModelFieldCfgAbValidatorTuple) {
                if (!DebugTrace.enable()) continue;
                logger.info("\u5b57\u6bb5[{}]\u6ca1\u6709\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f, \u6a21\u578b\u5b57\u6bb5: [{}]", (Object)fieldNum, fieldCfgAndValidatorsMap.keySet());
                continue;
            }
            DataModelFieldCfg fieldCfg = (DataModelFieldCfg)dataModelFieldCfgAbValidatorTuple.getKey();
            if (!fieldCfg.getEnable().booleanValue() || StringUtils.isEmpty((String)fieldCfg.getApifield()) || CreateTypeEnum.SYSTEM.getName().equals(fieldCfg.getCreateType()) && (DataValueTypeEnum.BaseProp == fieldCfg.getDataType() || DataValueTypeEnum.AssistProp == fieldCfg.getDataType()) || !fieldCfg.isRequired()) continue;
            if (StringUtils.isEmpty((String)fieldCfg.getRequiredCondition())) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e3a\u7a7a", (String)"ExtDataSdoHelper_0", (String)"fi-ai-common", (Object[])new Object[0]), fieldNum);
                this.extDataSaveCtx.addErrorMsg(msg, fieldCfg, sdo, null);
                continue;
            }
            this.extDataSaveCtx.addRequiredConditionField(fieldNum);
        }
    }

    private void collectNum(DataModelFieldCfg fieldCfg, Object fieldValue) {
        if (null == fieldCfg) {
            return;
        }
        IDConverterHelper converterHelper = this.extDataSaveCtx.getConverterHelper();
        if (fieldCfg.getDataType() == DataValueTypeEnum.BaseProp) {
            converterHelper.collectBasedataNumber(fieldCfg.getRefBaseProp(), (String)fieldValue);
        } else if (fieldCfg.getDataType() == DataValueTypeEnum.AssistProp) {
            converterHelper.collectAssistantNumber(fieldCfg.getRefAssistProp(), (String)fieldValue);
        }
    }

    private SimpleDynamicObject parse(SimpleDynamicObjectType dt, JSONObject jsonObject, SimpleDynamicObject parent) {
        SimpleDynamicObject sdo = new SimpleDynamicObject(dt);
        sdo.setParent(parent);
        this.setDefaultValue(sdo);
        this.parseWithCheck(sdo, jsonObject);
        return sdo;
    }

    private void setDefaultValue(SimpleDynamicObject sdo) {
        SimpleDynamicObjectType dt = sdo.getDynamicObjectType();
        Map<String, DataModelFieldCfg> fieldCfgMap = this.extDataSaveCtx.getFieldCfgMap(dt.getRoot().getName());
        for (SimpleDynamicProperty prop : dt.getProps()) {
            String fieldNum = prop.getName();
            DataModelFieldCfg fieldCfg = fieldCfgMap.get(fieldNum);
            if (null == fieldCfg || !fieldCfg.getEnable().booleanValue() || StringUtils.isEmpty((String)fieldCfg.getApifield()) || null != prop.getValueFast(sdo) || CreateTypeEnum.SYSTEM.getName().equals(fieldCfg.getCreateType()) && (fieldCfg.getDataType() == DataValueTypeEnum.BaseProp || fieldCfg.getDataType() == DataValueTypeEnum.AssistProp)) continue;
            DataModelFieldPropCfg defaultValuePropCfg = (DataModelFieldPropCfg)fieldCfg.getProps().get(FieldPropEnum.DEFVALUE.getNumber());
            if (null != defaultValuePropCfg) {
                prop.setValueFast(sdo, defaultValuePropCfg.valueByType());
                continue;
            }
            DataModelFieldPropCfg bdDefaultValuePropCfg = (DataModelFieldPropCfg)fieldCfg.getProps().get(FieldPropEnum.DEFVALUEDESIGN.getNumber());
            if (null == bdDefaultValuePropCfg) continue;
            Object bdDefaultValue = bdDefaultValuePropCfg.valueByType();
            prop.setValueFast(sdo, bdDefaultValue);
            this.collectNum(fieldCfg, bdDefaultValue);
        }
    }

    private SimpleDynamicObject[] parseEntry(SimpleDynamicCollectionProperty propsCollection, JSONArray fieldValueArray, SimpleDynamicObject parent) {
        return this.parseEntry(propsCollection, fieldValueArray, parent, 0);
    }

    private SimpleDynamicObject[] parseEntry(SimpleDynamicCollectionProperty propsCollection, JSONArray fieldValueArray, SimpleDynamicObject parent, int startIndex) {
        SimpleDynamicObject[] entries = new SimpleDynamicObject[fieldValueArray.size()];
        SimpleDynamicObjectType collectionItemPropertyType = propsCollection.getCollectionItemPropertyType();
        for (int index = 0; index < fieldValueArray.size(); ++index) {
            JSONObject entryJsonObject = fieldValueArray.getJSONObject(index);
            SimpleDynamicObject entry = this.parse(collectionItemPropertyType, entryJsonObject, parent);
            entry.set("seq", (Object)(index + 1 + startIndex));
            entries[index] = entry;
        }
        return entries;
    }

    public void convertBasedata(SimpleDynamicObject sdo) {
        Map<String, DataModelFieldCfg> fieldCfgMap = this.extDataSaveCtx.getFieldCfgMap();
        IDConverterHelper converterHelper = this.extDataSaveCtx.getConverterHelper();
        SimpleDynamicObjectType dt = sdo.getDynamicObjectType();
        SimpleEntityPropertyCollection props = dt.getProps();
        for (SimpleDynamicProperty prop : props) {
            Object value;
            DataModelFieldCfg fieldCfg;
            if (prop instanceof SimpleDynamicCollectionProperty) {
                SimpleDynamicObject[] entries;
                for (SimpleDynamicObject entry : entries = sdo.getEntries((SimpleDynamicCollectionProperty)prop)) {
                    this.convertBasedata(entry);
                }
            }
            if (!prop.getConfigFlag(SimpleDynamicMetadata.BaseConfigFlag.IsBaseData) || !(prop instanceof SimpleBasedataProp) || (fieldCfg = fieldCfgMap.get(prop.getName())) == null || CreateTypeEnum.SYSTEM.getName().equals(fieldCfg.getCreateType()) || StringUtils.isEmpty(value = prop.getValueFast(sdo))) continue;
            List<Object> ids = null;
            String msg1 = null;
            String msg2 = null;
            if (fieldCfg.getDataType() == DataValueTypeEnum.BaseProp) {
                ids = converterHelper.convertBasedataNumber(fieldCfg.getRefBaseProp(), (String)value);
                msg1 = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u4e2d\u672a\u627e\u5230\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e", (String)"ExtDataSdoHelper_1", (String)"fi-ai-common", (Object[])new Object[0]), fieldCfg.getRefBaseProp(), value);
                msg2 = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u4e2d\u627e\u5230\u591a\u884c\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e", (String)"ExtDataSdoHelper_2", (String)"fi-ai-common", (Object[])new Object[0]), fieldCfg.getRefBaseProp(), value);
            } else if (fieldCfg.getDataType() == DataValueTypeEnum.AssistProp) {
                ids = converterHelper.convertAssistantNumber(fieldCfg.getRefAssistProp(), (String)value);
                String assistantGroupNumber = converterHelper.convertToBaseDataNumber("bos_assistantdatagroup", fieldCfg.getRefAssistProp());
                msg1 = String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u201c%1$s\u201d\u4e2d\u672a\u627e\u5230\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e", (String)"ExtDataSdoHelper_3", (String)"fi-ai-common", (Object[])new Object[0]), assistantGroupNumber, value);
                msg2 = String.format(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u201c%1$s\u201d\u4e2d\u627e\u5230\u591a\u884c\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e", (String)"ExtDataSdoHelper_4", (String)"fi-ai-common", (Object[])new Object[0]), assistantGroupNumber, value);
            }
            if (null == ids || ids.isEmpty()) {
                this.extDataSaveCtx.addErrorMsg(msg1, fieldCfg, sdo, value);
                continue;
            }
            if (ids.size() > 1) {
                this.extDataSaveCtx.addErrorMsg(msg2, fieldCfg, sdo, value);
                continue;
            }
            ((SimpleBasedataProp)prop).getRefIdProp().setValueFast(sdo, ids.get(0));
        }
    }

    public SimpleDynamicObject create(String modelNum) {
        String metaEntityNum = this.extDataSaveCtx.transToMetaNum(modelNum);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)metaEntityNum);
        SimpleDynamicObjectType dt = SimpleDynamicObjectType.getSimpleDynamicObjectType((IDataEntityType)type);
        return new SimpleDynamicObject(dt);
    }

    public void parseAppendEntries(SimpleDynamicObject sdo, String entryname, JSONArray jsonArray, int currentEntrySize) {
        SimpleEntityPropertyCollection props = sdo.getDynamicObjectType().getProps();
        SimpleDynamicCollectionProperty propsCollection = (SimpleDynamicCollectionProperty)props.get(entryname);
        SimpleDynamicObject[] entries = this.parseEntry(propsCollection, jsonArray, sdo, currentEntrySize);
        propsCollection.setValueFast(sdo, entries);
    }

    public void setApiTypeAppendEntries() {
        this.apiType = ExtDataApiTypeEnum.AppendEntries;
    }

    private static enum ExtDataApiTypeEnum {
        ImportData,
        AppendEntries;

    }
}

