/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kd.fi.v2.fah.iterator.IntArraySequenceIterator;
import kd.fi.v2.fah.iterator.IntArraySequenceIteratorBuilder;
import kd.fi.v2.fah.serializer.CustomJsonSerializeHelper;

public class FahBeanAccessUtils {
    public static List<Class> getPackageAllClasses(Collection<String> packageNames, Collection<String> skipClassNames) {
        List<URL> pkgDirList = FahBeanAccessUtils.getPackageDirectories(packageNames);
        List<String> classNames = FahBeanAccessUtils.findClassNames(pkgDirList, packageNames);
        boolean needSkipClass = skipClassNames != null && !skipClassNames.isEmpty();
        LinkedList<Class> resultClasses = new LinkedList<Class>();
        for (String name : classNames) {
            if (name == null || needSkipClass && skipClassNames.contains(name)) continue;
            try {
                resultClasses.add(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return resultClasses;
    }

    public static List<Class> getPackageAllClasses(String packageName, Collection<String> skipClassNames) {
        return FahBeanAccessUtils.getPackageAllClasses(Collections.singleton(packageName), skipClassNames);
    }

    public static List<Class> getPackageAllClasses(String packageName, Class invoker) {
        return FahBeanAccessUtils.getPackageAllClasses(Collections.singleton(packageName), invoker != null ? Collections.singleton(invoker.getName()) : null);
    }

    public static List<URL> getPackageDirectories(Collection<String> packageNames) {
        if (packageNames == null || packageNames.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<URL> result = new LinkedList<URL>();
        ClassLoader _classLoader = FahBeanAccessUtils.class.getClassLoader();
        for (String pkg : packageNames) {
            String pkgDirName = pkg.replace('.', '/');
            try {
                Enumeration<URL> urls = _classLoader.getResources(pkgDirName);
                block10: while (urls.hasMoreElements()) {
                    String protocol;
                    URL url = urls.nextElement();
                    if (url == null || (protocol = url.getProtocol()) == null) continue;
                    switch (protocol) {
                        case "file": 
                        case "jar": {
                            result.add(url);
                            continue block10;
                        }
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return result;
    }

    public static List<String> findClassNames(List<URL> srcDirectories, Collection<String> packageNames) {
        if (srcDirectories == null || srcDirectories.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<String> resultNames = new LinkedList<String>();
        for (URL uRL : srcDirectories) {
        }
        return resultNames;
    }

    public static List<String> findClasses(File directory, String packageName) {
        if (directory == null || !directory.exists()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<String> classNames = new LinkedList<String>();
        File[] files = directory.listFiles();
        try {
            for (File file : files) {
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classNames.addAll(FahBeanAccessUtils.findClasses(file, packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                classNames.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
            }
        }
        catch (Exception ex) {
            return Collections.EMPTY_LIST;
        }
        return classNames;
    }

    public static List<String> findClassesByFile(String pkgName, String pkgPath) {
        File dir = new File(pkgPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return Collections.EMPTY_LIST;
        }
        File[] dirFiles = dir.listFiles(pathname -> pathname.isDirectory() || pathname.getName().endsWith("class"));
        if (dirFiles == null || dirFiles.length == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<String> result = new LinkedList<String>();
        for (File f : dirFiles) {
            if (f.isDirectory()) {
                result.addAll(FahBeanAccessUtils.findClassesByFile(pkgName + "." + f.getName(), pkgPath + "/" + f.getName()));
                continue;
            }
            String className = f.getName();
            className = className.substring(0, className.length() - 6);
            result.add(pkgName + "." + className);
        }
        return result;
    }

    public static int tryAccessClassMethod(Class srcClazz, Consumer<Method> methodModifyConsumer) {
        if (srcClazz.isInterface() || Modifier.isAbstract(srcClazz.getModifiers())) {
            return 0;
        }
        Object newInstance = FahBeanAccessUtils.createObjectInstance(srcClazz);
        if (newInstance == null) {
            return 0;
        }
        int[] methodCnt = new int[]{0};
        try {
            CustomJsonSerializeHelper.visitClassAllMethods(srcClazz, method -> {
                if (methodModifyConsumer != null) {
                    methodModifyConsumer.accept((Method)method);
                }
                if (method.getParameterCount() == 0) {
                    try {
                        method.invoke(newInstance, new Object[0]);
                        methodCnt[0] = methodCnt[0] + 1;
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        FahBeanAccessUtils.doMethodAccessTest(srcClazz, method, newInstance);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return methodCnt[0];
    }

    protected static Object createObjectInstance(Class srcClazz) {
        Object newInstance = null;
        try {
            newInstance = srcClazz.newInstance();
        }
        catch (Exception e) {
            for (Constructor<?> constructor : srcClazz.getConstructors()) {
                IntArraySequenceIterator paramIterator = FahBeanAccessUtils.buildMethodAccessParams(srcClazz, constructor.getParameterTypes());
                if (paramIterator == null) continue;
                while (paramIterator.hasNext()) {
                    Object[] paramBuf = paramIterator.next();
                    try {
                        Object obj = constructor.newInstance(paramBuf);
                        newInstance = obj;
                        if (obj == null) continue;
                        return newInstance;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        return newInstance;
    }

    protected static void doMethodAccessTest(Class srcClazz, Method srcMethod, Object newInstance) throws InvocationTargetException, IllegalAccessException {
        IntArraySequenceIterator paramIterator = FahBeanAccessUtils.buildMethodAccessParams(srcClazz, srcMethod.getParameterTypes());
        if (paramIterator == null) {
            return;
        }
        while (paramIterator.hasNext()) {
            Object[] paramValues = paramIterator.next();
            if (paramValues == null) continue;
            srcMethod.invoke(newInstance, paramValues);
        }
    }

    protected static IntArraySequenceIterator buildMethodAccessParams(Class srcClass, Class[] paramClassTypes, BiFunction<Class, Class[], Object[]> paramBuilderFunc) {
        if (paramClassTypes == null || paramClassTypes.length == 0) {
            return null;
        }
        IntArraySequenceIteratorBuilder builder = new IntArraySequenceIteratorBuilder();
        int idx = 0;
        for (Class paramClass : paramClassTypes) {
            Object[] paramValues = paramClass.isEnum() ? FahBeanAccessUtils.buildEnumParamIteratorArray(srcClass, paramClass) : FahBeanAccessUtils.buildSimpleObjectParamIteratorArray(srcClass, paramClass);
            if (paramValues == null || paramValues.length == 0) {
                builder.addFixedValue(idx, null);
            } else {
                builder.addArrayValue(paramValues);
            }
            ++idx;
        }
        return builder.build();
    }

    protected static IntArraySequenceIterator buildMethodAccessParams(Class srcClass, Class[] paramClassTypes) {
        return FahBeanAccessUtils.buildMethodAccessParams(srcClass, paramClassTypes, null);
    }

    protected static Object[] buildSimpleObjectParamIteratorArray(Class srcClass, Class paramClass) {
        switch (paramClass.getSimpleName().toLowerCase(Locale.ENGLISH)) {
            case "string": {
                return new String[]{"ABC", "DEF", "HIJ"};
            }
            case "long": {
                return new Long[]{100000L, 100001L, 100002L};
            }
            case "int": 
            case "integer": {
                return new Integer[]{1, 2, 3};
            }
            case "date": {
                return new Date[]{new Date(), new Date()};
            }
            case "double": {
                return new Double[]{1001.0, 1002.0, 1003.0};
            }
            case "float": {
                return new Float[]{Float.valueOf(1001.0f), Float.valueOf(1002.0f), Float.valueOf(1003.0f)};
            }
            case "BigDecimal": {
                return new BigDecimal[]{BigDecimal.ONE, BigDecimal.valueOf(1001L), BigDecimal.valueOf(1002L)};
            }
            case "BigInteger": {
                return new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(1001L), BigInteger.valueOf(1002L)};
            }
            case "boolean": {
                return new Boolean[]{true, false};
            }
            case "character": 
            case "char": {
                return new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
            }
        }
        return null;
    }

    protected static Object[] buildEnumParamIteratorArray(Class srcClass, Class paramClass) {
        try {
            Method m = paramClass.getMethod("value", new Class[0]);
            return (Object[])m.invoke(srcClass.newInstance(), new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

