/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahSerializeHelper {
    private final SerializeConfig serializeConfig = new SerializeConfig();
    private final ParserConfig parserConfig = new ParserConfig();
    private static final FahSerializeHelper _instance = new FahSerializeHelper();

    private FahSerializeHelper() {
    }

    public static FahSerializeHelper getInstance() {
        return _instance;
    }

    public void registerDefaultCustomSerializer(Class clazz, ObjectSerializer serializer, ObjectDeserializer deserializer) {
        if (serializer != null) {
            this.serializeConfig.put((Type)clazz, serializer);
        }
        if (deserializer != null) {
            this.parserConfig.putDeserializer((Type)clazz, deserializer);
        }
    }

    public String toJSONString(Object source, boolean prettyFormat) {
        if (source == null) {
            return null;
        }
        if (prettyFormat) {
            return JSON.toJSONString((Object)source, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.SkipTransientField});
        }
        return JSON.toJSONString((Object)source, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SkipTransientField});
    }

    public String toJSONString(Object source) {
        return this.toJSONString(source, false);
    }

    public static <T> T fromJsonString(String jsonString, Class<T> classType) {
        return _instance.parse(jsonString, classType);
    }

    public static <T> List<T> fromJsonArrayString(String jsonArrayString, Class<T> classType) {
        return _instance.parseArray(jsonArrayString, classType);
    }

    public static String toJsonString(Object source) {
        return _instance.toJSONString(source);
    }

    public <T> T parse(String jsonString, Class<T> classType) {
        if (StringUtils.isEmpty((String)jsonString) || classType == null) {
            return null;
        }
        return (T)JSON.parseObject((String)jsonString, classType);
    }

    public <T> List<T> parseArray(String jsonString, Class<T> classType) {
        if (StringUtils.isEmpty((String)jsonString) || classType == null) {
            return null;
        }
        return JSON.parseArray((String)jsonString, classType);
    }

    public String serializeToBase64(Object source) {
        return SerializationUtils.serializeToBase64((Object)source);
    }

    public <T> T deSerializeFromBase64(String base64String) {
        return (T)SerializationUtils.deSerializeFromBase64((String)base64String);
    }

    public InputStream getJsonInputStream(Object source) {
        return StringUtils.getInputStream(this.toJSONString(source));
    }
}

