/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.v2.fah.cache.thread.ClassSerializePropsCache;
import kd.fi.v2.fah.serializer.CustomJsonSerializeHelper;
import kd.fi.v2.fah.serializer.ISupportDeepEqual;
import kd.fi.v2.fah.storage.IOpenDataStorage;
import kd.fi.v2.fah.utils.StringUtils;

public class ICommonDataValueUtil
extends IDataValueUtil {
    public static final String Default_Date_Format = "yyyy-MM-dd";
    public static final String Empty_String = "";
    private static final SimpleDateFormat _data_format = new SimpleDateFormat();

    public static int getObjectEnumerateType(Object src) {
        if (src == null) {
            return -1;
        }
        if (IOpenDataStorage.class.isAssignableFrom(src.getClass())) {
            return 4;
        }
        return ICommonDataValueUtil.getObjectEnumType((Object)src);
    }

    public static boolean isEquals(Object l1, Object l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 != null) {
            return l1.equals(l2);
        }
        return false;
    }

    public static boolean deepEquals(Object source, Object target) {
        if (source == null || target == null || source == target) {
            return true;
        }
        if (source == null || target == null) {
            return false;
        }
        Class<?> sourceClazz = source.getClass();
        Class<?> targetClazz = target.getClass();
        boolean src_match = source instanceof Collection;
        if (src_match || target instanceof Collection) {
            if (src_match && target instanceof Collection) {
                if (((Collection)source).size() != ((Collection)target).size()) {
                    return false;
                }
                Iterator srcItr = ((Collection)source).iterator();
                Iterator targetItr = ((Collection)target).iterator();
                while (srcItr.hasNext()) {
                    if (ICommonDataValueUtil.deepEquals(srcItr.next(), targetItr.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        src_match = source instanceof Map;
        if (src_match || target instanceof Map) {
            if (src_match && target instanceof Map) {
                if (((Map)source).size() != ((Map)target).size()) {
                    return false;
                }
                Iterator srcItr = ((Map)source).entrySet().iterator();
                Iterator targetItr = ((Map)target).entrySet().iterator();
                while (srcItr.hasNext()) {
                    Map.Entry srcBuf = srcItr.next();
                    Map.Entry targetBuf = targetItr.next();
                    if (ICommonDataValueUtil.deepEquals(srcBuf.getKey(), targetBuf.getKey()) && ICommonDataValueUtil.deepEquals(srcBuf.getValue(), targetBuf.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        src_match = sourceClazz.isArray();
        if (src_match || targetClazz.isArray()) {
            if (src_match && targetClazz.isArray()) {
                int sourceLength = Array.getLength(source);
                if (sourceLength != Array.getLength(target)) {
                    return false;
                }
                for (int i = 0; i < sourceLength; ++i) {
                    if (ICommonDataValueUtil.deepEquals(Array.get(source, i), Array.get(target, i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        src_match = IOpenDataStorage.class.isAssignableFrom(sourceClazz);
        if (src_match || IOpenDataStorage.class.isAssignableFrom(targetClazz)) {
            if (src_match && IOpenDataStorage.class.isAssignableFrom(targetClazz)) {
                IOpenDataStorage srcStore = (IOpenDataStorage)source;
                IOpenDataStorage targetStore = (IOpenDataStorage)target;
                int sourceLength = srcStore.size();
                if (sourceLength != targetStore.size()) {
                    return false;
                }
                for (int i = 0; i < sourceLength; ++i) {
                    if (ICommonDataValueUtil.deepEquals(srcStore.get(i), targetStore.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        src_match = ISupportDeepEqual.class.isAssignableFrom(sourceClazz);
        if (src_match || ISupportDeepEqual.class.isAssignableFrom(targetClazz)) {
            if (src_match && ISupportDeepEqual.class.isAssignableFrom(targetClazz)) {
                return ICommonDataValueUtil.compareISupportDeepEqualModel((ISupportDeepEqual)source, (ISupportDeepEqual)target, sourceClazz, true, false);
            }
            return false;
        }
        return Objects.equals(source, target);
    }

    public static boolean compareISupportDeepEqualModel(ISupportDeepEqual source, ISupportDeepEqual checkTarget, Class<?> clazz, boolean allowNonSerializableProps, boolean allowNonPublicWriteMethod) {
        if (source == null && checkTarget == null) {
            return true;
        }
        if (source == null || checkTarget == null) {
            return false;
        }
        Map<String, ClassSerializePropsCache> fieldInfos = CustomJsonSerializeHelper.parseSerializableProperties(clazz, allowNonSerializableProps, allowNonPublicWriteMethod);
        ClassSerializePropsCache currentFeild = null;
        try {
            Iterator<ClassSerializePropsCache> iterator = fieldInfos.values().iterator();
            while (iterator.hasNext()) {
                ClassSerializePropsCache field;
                currentFeild = field = iterator.next();
                Object expectValue = field.getReadMethod().invoke((Object)source, new Object[0]);
                Object checkValue = field.getReadMethod().invoke((Object)checkTarget, new Object[0]);
                if (Date.class.isAssignableFrom(field.getField().getDeclaringClass())) {
                    expectValue = ((Date)expectValue).getTime();
                    checkValue = ((Date)checkValue).getTime();
                }
                if (ICommonDataValueUtil.deepEquals(expectValue, checkValue)) continue;
                return false;
            }
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(currentFeild + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToString(Date srcDate, String formatPattern) {
        SimpleDateFormat simpleDateFormat = _data_format;
        synchronized (simpleDateFormat) {
            _data_format.applyPattern(formatPattern == null ? Default_Date_Format : formatPattern);
            return _data_format.format(srcDate);
        }
    }

    public static String dateToString(Date srcDate) {
        return ICommonDataValueUtil.dateToString(srcDate, Default_Date_Format);
    }

    public static boolean checkNumberScale(BigDecimal srcValue, int scale) {
        return srcValue.stripTrailingZeros().scale() <= scale;
    }

    public static boolean isEmptyObject(Object obj) {
        boolean isNull = false;
        if (obj == null) {
            isNull = true;
        } else if (obj instanceof String && StringUtils.isEmpty((String)((String)obj))) {
            isNull = true;
        } else if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            isNull = true;
        } else if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            isNull = true;
        }
        return isNull;
    }
}

