/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.fi.ai.util.DateUtil;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.models.dynamic.SimpleBasedataProp;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicCollectionProperty;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicProperty;
import kd.fi.v2.fah.models.dynamic.SimpleEntityPropertyCollection;

public class SdoUtil {
    public static Map<String, Object> toMap(SimpleDynamicObject sdo) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (null == sdo.getDynamicObjectType() || null == sdo.getDataStorage()) {
            return map;
        }
        if (null == sdo.getDynamicObjectType().getProps() || 0 == sdo.getDynamicObjectType().getProps().size()) {
            return map;
        }
        for (SimpleDynamicProperty prop : sdo.getDynamicObjectType().getProps()) {
            if (prop instanceof SimpleDynamicCollectionProperty) {
                SimpleDynamicCollectionProperty collectionProperty = (SimpleDynamicCollectionProperty)prop;
                Object entryValue = sdo.get(collectionProperty.getName());
                if (!(entryValue instanceof SimpleDynamicObject[])) continue;
                SimpleDynamicObject[] entries = (SimpleDynamicObject[])entryValue;
                LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
                for (SimpleDynamicObject entry : entries) {
                    Map<String, Object> entryMap = SdoUtil.toMap(entry);
                    if (entryMap.isEmpty()) continue;
                    list.add(entryMap);
                }
                if (list.isEmpty()) continue;
                map.put(collectionProperty.getName(), list);
                continue;
            }
            if (prop instanceof SimpleBasedataProp) {
                SimpleBasedataProp basedataProp = (SimpleBasedataProp)prop;
                Object value = sdo.get(basedataProp.getRefIdProp().getName());
                Long v = ObjectConverterFactory.getLong(value, 0L);
                map.put(basedataProp.getName(), v);
                continue;
            }
            Object value = sdo.get(prop.getName());
            if (null == value) continue;
            if (value instanceof Date) {
                value = DateUtil.getShortFormat().format(value);
            }
            map.put(prop.getName(), value);
        }
        return map;
    }

    public static int countAllDataLine(SimpleDynamicObject[] sdoList) {
        if (null == sdoList) {
            return 0;
        }
        int total = sdoList.length;
        for (SimpleDynamicObject sdo : sdoList) {
            SimpleEntityPropertyCollection props = sdo.getDynamicObjectType().getProps();
            for (SimpleDynamicProperty prop : props) {
                if (!(prop instanceof SimpleDynamicCollectionProperty)) continue;
                SimpleDynamicObject[] entries = sdo.getEntries((SimpleDynamicCollectionProperty)prop);
                total += SdoUtil.countAllDataLine(entries);
            }
        }
        return total;
    }
}

