/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.JsonSubEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class TreeBuildUtils {
    public static List<TreeNode> getThreeNodesWithOrgBD(String parentNodeId, EntityType entity, String preFixNumber, int currentLevel, int maxLevel, HashSet<String> filterField, Class<?> fieldClassType, String basePropType, boolean isRoot, String entryNumber) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (isRoot) {
            for (EntityType entityType : TreeBuildUtils.getAllEntities(entity, entryNumber)) {
                TreeNode node = new TreeNode();
                node.setDisabled(true);
                node.setColor("#000000");
                node.setParentid(parentNodeId);
                node.setId(entityType.getName());
                node.setChildren(new ArrayList());
                if (entityType instanceof MainEntityType) {
                    node.setId("headField");
                    node.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityTreeUtil_3", (String)"fi-ai-common", (Object[])new Object[0]));
                } else if (entityType instanceof SubEntryType) {
                    node.setText(EntityTreeUtil.getFullString(entityType.getParent().getDisplayName().getLocaleValue(), entityType.getDisplayName().getLocaleValue()));
                } else if (entityType instanceof EntryType) {
                    node.setText(entityType.getDisplayName().getLocaleValue());
                }
                nodes.add(node);
            }
        } else {
            for (IDataEntityProperty property : entity.getFields().values()) {
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)property.getAlias()) || property.getParent() instanceof JsonSubEntryType) continue;
                String number = EntityTreeUtil.getFullString(preFixNumber, property.getName());
                String name = property.getDisplayName().getLocaleValue();
                TreeNode treeNode = new TreeNode(parentNodeId, number, name);
                if (property instanceof BasedataProp && !(property instanceof FlexProp)) {
                    String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    if (currentLevel < maxLevel) {
                        treeNode.setParentid(parentNodeId);
                        treeNode.setChildren(Collections.emptyList());
                        nodes.add(treeNode);
                        if (filterField == null || filterField.isEmpty()) {
                            if (fieldClassType == null || property instanceof AssistantProp && Objects.equals(((AssistantProp)property).getAsstTypeId(), basePropType) || Objects.equals(baseEntityId, basePropType)) continue;
                            treeNode.setColor("#000000");
                            treeNode.setDisabled(true);
                            continue;
                        }
                        if (filterField.contains(property.getClass().getName())) continue;
                        treeNode.setDisabled(true);
                        treeNode.setColor("#000000");
                        continue;
                    }
                    if (filterField == null || filterField.isEmpty()) {
                        if (fieldClassType != null && (!(property instanceof AssistantProp) || !Objects.equals(((AssistantProp)property).getAsstTypeId(), basePropType)) && !Objects.equals(baseEntityId, basePropType)) continue;
                        treeNode.setParentid(parentNodeId);
                        nodes.add(treeNode);
                        continue;
                    }
                    if (!filterField.contains(property.getClass().getName())) continue;
                    treeNode.setParentid(parentNodeId);
                    nodes.add(treeNode);
                    continue;
                }
                if (fieldClassType == null) {
                    treeNode.setParentid(parentNodeId);
                    nodes.add(treeNode);
                    continue;
                }
                if (filterField == null || filterField.isEmpty()) {
                    if (fieldClassType == Boolean.class) {
                        if (property.getPropertyType() != Boolean.TYPE && property.getPropertyType() != Boolean.class) continue;
                        treeNode.setParentid(parentNodeId);
                        nodes.add(treeNode);
                        continue;
                    }
                    if (property.getPropertyType() != fieldClassType && (fieldClassType != BigDecimal.class || property.getPropertyType() != Integer.class)) continue;
                    treeNode.setParentid(parentNodeId);
                    nodes.add(treeNode);
                    continue;
                }
                if (!filterField.contains(property.getClass().getName())) continue;
                treeNode.setParentid(parentNodeId);
                nodes.add(treeNode);
            }
        }
        return nodes;
    }

    public static List<EntityType> getAllEntities(EntityType srcMainET, String entryNumber) {
        LinkedList<EntityType> allNeedEntities = new LinkedList<EntityType>();
        Map allEntities = ((MainEntityType)srcMainET).getAllEntities();
        HashSet<String> needentryNumber = EntityTreeUtil.getEntryNumberSet(entryNumber, allEntities);
        for (EntityType entityType : allEntities.values()) {
            if (StringUtils.isEmpty((String)entityType.getAlias()) || entityType instanceof JsonSubEntryType || !StringUtils.isEmpty((String)entryNumber) && !(entityType instanceof MainEntityType) && !needentryNumber.contains(entityType.getName())) continue;
            allNeedEntities.add(entityType);
        }
        return allNeedEntities;
    }

    public static List<TreeNode> getThreeNodesWithoutOrgBD(String parentNodeId, EntityType srcMainET, String preFixNumber, int currentLevel, int maxLevel, HashSet<String> filterField, boolean isRoot, String entryNumber) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (isRoot) {
            Map allEntities = ((MainEntityType)srcMainET).getAllEntities();
            HashSet<String> needentryNumber = EntityTreeUtil.getEntryNumberSet(entryNumber, allEntities);
            for (EntityType entityType : allEntities.values()) {
                if (StringUtils.isEmpty((String)entityType.getAlias())) continue;
                TreeNode node = new TreeNode();
                node.setDisabled(true);
                node.setColor("#000000");
                node.setParentid(parentNodeId);
                node.setId(entityType.getName());
                node.setChildren(new ArrayList());
                if (entityType instanceof MainEntityType) {
                    node.setId("headField");
                    node.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityTreeUtil_3", (String)"fi-ai-common", (Object[])new Object[0]));
                    nodes.add(node);
                    continue;
                }
                if (entityType instanceof SubEntryType) {
                    if (entityType instanceof JsonSubEntryType || entryNumber != null && !needentryNumber.contains(entityType.getName())) continue;
                    node.setText(EntityTreeUtil.getFullString(entityType.getParent().getDisplayName().getLocaleValue(), entityType.getDisplayName().getLocaleValue()));
                    nodes.add(node);
                    continue;
                }
                if (!(entityType instanceof EntryType) || entryNumber != null && !needentryNumber.contains(entityType.getName())) continue;
                node.setText(entityType.getDisplayName().getLocaleValue());
                nodes.add(node);
            }
        } else {
            for (IDataEntityProperty property : srcMainET.getFields().values()) {
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)property.getAlias()) || property.getParent() instanceof JsonSubEntryType) continue;
                String number = EntityTreeUtil.getFullString(preFixNumber, property.getName());
                String name = property.getDisplayName().getLocaleValue();
                TreeNode treeNode = new TreeNode(parentNodeId, number, name);
                if (property instanceof BasedataProp && !(property instanceof FlexProp)) {
                    String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                    if (currentLevel < maxLevel) {
                        treeNode.setParentid(parentNodeId);
                        treeNode.setChildren(new ArrayList());
                        nodes.add(treeNode);
                        if (filterField == null || filterField.isEmpty()) {
                            if (!(property instanceof AssistantProp) && !FahEntityMetaHelper.isOrgTplBaseData(baseEntityId)) continue;
                            treeNode.setColor("#000000");
                            treeNode.setDisabled(true);
                            continue;
                        }
                        if (filterField.contains(property.getClass().getName())) continue;
                        treeNode.setDisabled(true);
                        treeNode.setColor("#000000");
                        continue;
                    }
                    if (filterField == null || filterField.isEmpty()) {
                        if (property instanceof AssistantProp || FahEntityMetaHelper.isOrgTplBaseData(baseEntityId)) continue;
                        treeNode.setParentid(parentNodeId);
                        nodes.add(treeNode);
                        continue;
                    }
                    if (!filterField.contains(property.getClass().getName())) continue;
                    treeNode.setParentid(parentNodeId);
                    nodes.add(treeNode);
                    continue;
                }
                if (filterField == null || filterField.isEmpty()) {
                    if (currentLevel != 0 && (!(srcMainET instanceof BasedataEntityType) || FahEntityMetaHelper.isOrgTplBaseData(srcMainET.getName()))) continue;
                    treeNode.setParentid(parentNodeId);
                    nodes.add(treeNode);
                    continue;
                }
                if (!filterField.contains(property.getClass().getName())) continue;
                treeNode.setParentid(parentNodeId);
                nodes.add(treeNode);
            }
        }
        return nodes;
    }

    public static List<TreeNode> getTreeNodesByParent(String parentNodeId, EntityType srcMainET, String preFixNumber, int currentLevel, int maxLevel, HashSet<String> filterField, Class<?> fieldClassType, String basePropType, boolean isRoot, String entryNumber, boolean needFilterOrg) {
        if (needFilterOrg) {
            return TreeBuildUtils.getThreeNodesWithoutOrgBD(parentNodeId, srcMainET, preFixNumber, currentLevel, maxLevel, filterField, isRoot, entryNumber);
        }
        return TreeBuildUtils.getThreeNodesWithOrgBD(parentNodeId, srcMainET, preFixNumber, currentLevel, maxLevel, filterField, fieldClassType, basePropType, isRoot, entryNumber);
    }

    public static List<TreeNode> getTreeNodesByParent(String parentNodeId, EntityType srcMainET, String preFixNumber, int currentLevel, int maxLevel, HashSet<String> filterField, Class<?> fieldClassType, String basePropType, boolean isRoot, String entryNumber) {
        return TreeBuildUtils.getTreeNodesByParent(parentNodeId, srcMainET, preFixNumber, currentLevel, maxLevel, filterField, fieldClassType, basePropType, isRoot, entryNumber, false);
    }
}

