/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import kd.fi.v2.fah.models.common.tree.impl.SimpleTreeNode;
import kd.fi.v2.fah.models.dynvalfields.AbstractDynValFieldGetValueCfg;
import kd.fi.v2.fah.utils.Assert;
import kd.fi.v2.fah.utils.StringUtils;

public class TreeModelUtils {
    private final Consumer<String> logOutputFunc;
    private final boolean enableLogOutput;

    private TreeModelUtils(Consumer<String> logOutputFunc) {
        this.logOutputFunc = logOutputFunc;
        this.enableLogOutput = this.logOutputFunc != null;
    }

    public static TreeModelUtils getOrBuildInstance(Consumer<String> logOutputFunc) {
        return new TreeModelUtils(logOutputFunc);
    }

    private void printLog(String outputLogMsg) {
        if (this.enableLogOutput) {
            this.logOutputFunc.accept(outputLogMsg);
        }
    }

    public String dumpTreeNode(int idx, SimpleTreeNode<Object, AbstractDynValFieldGetValueCfg<?>> srcNode, boolean reverseMode, int level, boolean outputPathKey) {
        AbstractDynValFieldGetValueCfg cfgBuf = (AbstractDynValFieldGetValueCfg)srcNode.getNodeValues();
        if (cfgBuf == null) {
            return String.format("%s%d).(Level.Seq=null.null)[Num=%s, DataType=null, Val=null, Type=null, Name=null, Id=null] -> (MaxLevel=null, dep_Level=%d): PathKey=null", StringUtils.buildPrefix("   ", level), idx, srcNode.getKey(), srcNode.getDependencyLevel(reverseMode));
        }
        return String.format("%s%d).(Level.Seq=%s.%s)[Num=%s, DataType=%s, Val=%s, Type=%s, Name=%s, Id=%s] -> (MaxLevel=%d, depLevel=%d): PathKey=%s", new Object[]{StringUtils.buildPrefix("   ", level), idx, cfgBuf.getCompiler_temp_Level(), cfgBuf.getCompiler_temp_SeqNo(), cfgBuf.getNumber(), cfgBuf.getOutputDataType(), cfgBuf.getCfgValue(), cfgBuf.getExtractValueType(), cfgBuf.getName(), cfgBuf.getId(), cfgBuf.getMaxLevel(reverseMode), srcNode.getDependencyLevel(reverseMode), outputPathKey ? cfgBuf.getCfgModelPathKey() : "(Skip_Output)"});
    }

    protected String dumpTreeNode(int idx, SimpleTreeNode<Object, AbstractDynValFieldGetValueCfg<?>> srcNode, boolean reverseMode, int level) {
        return this.dumpTreeNode(idx, srcNode, reverseMode, level, false);
    }

    public String dumpTreeNode(int idx, SimpleTreeNode<Object, AbstractDynValFieldGetValueCfg<?>> srcNode, boolean reverseMode) {
        return this.dumpTreeNode(idx, srcNode, reverseMode, 0, false);
    }

    public String dumpCfgNode(int idx, AbstractDynValFieldGetValueCfg<?> srcCfg, boolean reverseMode, int level, boolean outputPathKey) {
        return String.format("%s%d).(Level.Seq=%s.%s)[Num=%s, DataType=%s, Val=%s, Type=%s, Name=%s, Id=%s] -> (MaxLevel=%d): PathKey=%s", new Object[]{StringUtils.buildPrefix("   ", level), idx, srcCfg.getCompiler_temp_Level(), srcCfg.getCompiler_temp_SeqNo(), srcCfg.getNumber(), srcCfg.getOutputDataType(), srcCfg.getCfgValue(), srcCfg.getExtractValueType(), srcCfg.getName(), srcCfg.getId(), srcCfg.getMaxLevel(reverseMode), outputPathKey ? srcCfg.getCfgModelPathKey() : "(Skip_Output)"});
    }

    public String dumpCfgNode(int idx, AbstractDynValFieldGetValueCfg<?> srcCfg, boolean reverseMode, int level) {
        return this.dumpCfgNode(idx, srcCfg, reverseMode, level, false);
    }

    public String dumpCfgNode(int idx, AbstractDynValFieldGetValueCfg<?> srcCfg, boolean reverseMode) {
        return this.dumpCfgNode(idx, srcCfg, reverseMode, 0, false);
    }

    public void checkDependencyFields(Collection<SimpleTreeNode<?, ?>>[] levelGrps, String[][] expect_result, boolean printLog, boolean validateResult, boolean dumpOrPrintNode) {
        Assert.assertNotNull(levelGrps);
        ArrayList<String> sorted_check_list = null;
        for (int level = 0; level < levelGrps.length; ++level) {
            if (printLog) {
                this.printLog(String.format("Level(%s): Cnt=%s", level, levelGrps[level].size()));
            }
            int j = 0;
            if (validateResult) {
                int length = expect_result[level].length;
                sorted_check_list = new ArrayList<String>(length);
            }
            for (SimpleTreeNode<Object, AbstractDynValFieldGetValueCfg<?>> simpleTreeNode : levelGrps[level]) {
                String nodeNumber;
                if (simpleTreeNode.getNodeValues() instanceof AbstractDynValFieldGetValueCfg) {
                    AbstractDynValFieldGetValueCfg nodeValueBuf = (AbstractDynValFieldGetValueCfg)simpleTreeNode.getNodeValues();
                    nodeNumber = String.format("num=%s, path=%s", nodeValueBuf.getNumber(), nodeValueBuf.getCfgModelPathKey());
                } else {
                    nodeNumber = String.valueOf(simpleTreeNode.getKey());
                }
                if (printLog) {
                    if (dumpOrPrintNode) {
                        this.printLog(this.dumpTreeNode(j, simpleTreeNode, false, 1));
                    } else {
                        this.printLog(String.format("\t%d). %s", j, nodeNumber));
                    }
                }
                if (validateResult && sorted_check_list != null) {
                    sorted_check_list.add(String.valueOf(nodeNumber));
                }
                ++j;
            }
            if (!validateResult) continue;
            ArrayList<String> sorted_expect_list = new ArrayList<String>(Arrays.asList(expect_result[level]));
            Collections.sort(sorted_expect_list);
            Collections.sort(sorted_check_list);
            Assert.assertTrue(String.format("Expect=%s but Actual=%s", sorted_expect_list, sorted_check_list), Objects.equals(sorted_expect_list, sorted_check_list));
        }
    }

    public void checkDependencyFields(Collection<SimpleTreeNode<?, ?>>[] levelGrps, String[][] expect_result, boolean printLog, boolean dumpOrPrintNode) {
        this.checkDependencyFields(levelGrps, expect_result, printLog, true, dumpOrPrintNode);
    }

    public void checkDependencyFields(Collection<SimpleTreeNode<?, ?>>[] levelGrps, String[][] expect_result, boolean printLog) {
        this.checkDependencyFields(levelGrps, expect_result, printLog, true, true);
    }

    public static int validatePathIndex(Object[] nodePath, int pathStartIndex) {
        if (nodePath == null) {
            return -1;
        }
        int length = nodePath.length;
        if (length == 0 || pathStartIndex >= length) {
            return -1;
        }
        return Math.max(pathStartIndex, 0);
    }

    public static int validatePathIndex(Collection nodePath, int pathStartIndex) {
        if (nodePath == null) {
            return -1;
        }
        int length = nodePath.size();
        if (length == 0 || pathStartIndex >= length) {
            return -1;
        }
        return Math.max(pathStartIndex, 0);
    }
}

