/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;

public class ValueSetUtil {
    public static String[] getValueSetTypeSort(FlexFieldGrpCfg meta) {
        if (meta == null || meta.getValues() == null) {
            return null;
        }
        int length = ((FlexFieldCfg[])meta.getValues()).length;
        String[] result = new String[length];
        for (FlexFieldCfg data : meta) {
            result[data.getSeq().intValue()] = data.getDbFieldNum();
        }
        return result;
    }

    public static Map<String, String[]> getMappingTypeSort(FlexFieldGrpCfg meta) {
        HashMap<String, String[]> result = new HashMap<String, String[]>(2);
        int index_in = 0;
        int index_out = 0;
        if (meta instanceof MappingStructureMeta) {
            MappingStructureMeta mappingMeta = (MappingStructureMeta)meta;
            index_in = mappingMeta.getInputParamMeta().size();
            index_out = mappingMeta.getOutputParamMeta().size();
        } else {
            Iterator iterator = meta.iterator();
            while (iterator.hasNext()) {
                if (MappingValueType.INPUT.getCode() == ((FlexFieldCfg)iterator.next()).getFieldUsageType()) {
                    ++index_in;
                    continue;
                }
                ++index_out;
            }
        }
        String[] input_prop = new String[index_in];
        String[] output_prop = new String[index_out];
        if (meta instanceof MappingStructureMeta) {
            MappingStructureMeta mappingMeta = (MappingStructureMeta)meta;
            for (FlexFieldCfg data_in : mappingMeta.getInputParamMeta()) {
                input_prop[data_in.getSeq().intValue()] = data_in.getDbFieldNum();
            }
            for (FlexFieldCfg data_out : mappingMeta.getOutputParamMeta()) {
                output_prop[data_out.getSeq().intValue()] = data_out.getDbFieldNum();
            }
        } else {
            for (FlexFieldCfg row : meta) {
                int seq = row.getSeq();
                String dbFieldNum = row.getDbFieldNum();
                if (MappingValueType.INPUT.getCode() == row.getFieldUsageType()) {
                    input_prop[seq] = dbFieldNum;
                    continue;
                }
                output_prop[seq] = dbFieldNum;
            }
        }
        result.put("input", input_prop);
        result.put("output", output_prop);
        return result;
    }
}

