/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils.pipe;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.bos.threads.ThreadPool;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.utils.pipe.FahAsyncStreamPipe;
import kd.fi.v2.fah.utils.pipe.FahRegisteredAsyncPipeTypeEnum;
import kd.fi.v2.fah.utils.pipe.IFahIAsyncStreamDataBlock;
import kd.fi.v2.fah.utils.pipe.RegisteredPipeInfo;

public class FahAsyncPipePoolMgr {
    private Map<Object, RegisteredPipeInfo> customPipeStorage;
    private RegisteredPipeInfo[] defaultPipes;
    private final BiFunction<String, int[], ThreadPool> threadPoolSupplier;

    protected FahAsyncPipePoolMgr(BiFunction<String, int[], ThreadPool> threadPoolSupplier) {
        this.threadPoolSupplier = threadPoolSupplier;
        this.customPipeStorage = new ConcurrentHashMap<Object, RegisteredPipeInfo>(4);
        this.initDefaultPipe();
    }

    protected ThreadPool createThreadPoolFunc(String name, int coreCnt, int maxCnt) {
        return this.threadPoolSupplier.apply(name, new int[]{coreCnt, maxCnt});
    }

    protected final void initDefaultPipe() {
        this.defaultPipes = new RegisteredPipeInfo[FahRegisteredAsyncPipeTypeEnum.values().length - 1];
        for (FahRegisteredAsyncPipeTypeEnum pipeType : FahRegisteredAsyncPipeTypeEnum.values()) {
            if (pipeType == FahRegisteredAsyncPipeTypeEnum.Custom_Temp) continue;
            int defaultMaxThreadCnt = pipeType.getDefaultMaxThreadCnt();
            ThreadPool pool = this.createThreadPoolFunc(pipeType.name(), 0, defaultMaxThreadCnt);
            FahAsyncStreamPipe pipe = new FahAsyncStreamPipe(defaultMaxThreadCnt, arg_0 -> ((ThreadPool)pool).submit(arg_0));
            pipe.getPipeCfgInfo().setQueuePreConsumerThreshold(pipeType.getDefaultMaxQueuePreThread());
            this.defaultPipes[pipeType.getIndex()] = new RegisteredPipeInfo(pipeType, pipe, pool);
        }
    }

    protected <E> RegisteredPipeInfo<E> createCustomPipeRegisterInfo(String pipeKey, int maxConsumerCnt, int maxQueuePreConsumer, BiConsumer<Integer, IFahIAsyncStreamDataBlock<E>> dataConsumer) {
        if (StringUtils.isEmpty((String)pipeKey)) {
            throw new IllegalArgumentException("Pipe cannot be null!");
        }
        ThreadPool pool = this.createThreadPoolFunc(pipeKey, 0, maxConsumerCnt);
        FahAsyncStreamPipe<E> pipe = new FahAsyncStreamPipe<E>(maxConsumerCnt, arg_0 -> ((ThreadPool)pool).submit(arg_0), dataConsumer);
        pipe.getPipeCfgInfo().setQueuePreConsumerThreshold(maxQueuePreConsumer);
        return new RegisteredPipeInfo<E>(pipeKey, pipe, pool);
    }

    public <E> RegisteredPipeInfo<E> registerCustomPipeInstance(String pipeKey, int maxConsumerCnt, int maxQueuePreConsumer, BiConsumer<Integer, IFahIAsyncStreamDataBlock<E>> dataConsumer) {
        return this.customPipeStorage.computeIfAbsent(pipeKey, v -> this.createCustomPipeRegisterInfo(pipeKey, maxConsumerCnt, maxQueuePreConsumer, dataConsumer));
    }

    public <E> RegisteredPipeInfo<E> removeCustomPipeInstance(String pipeKey) {
        return this.customPipeStorage.remove(pipeKey);
    }

    public Boolean startPipe(FahRegisteredAsyncPipeTypeEnum pipeType) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.startPipe());
    }

    public void stopPipe(FahRegisteredAsyncPipeTypeEnum pipeType, boolean force) {
        this.accessPipeInstance(pipeType, pipe -> {
            pipe.close(force);
            return true;
        });
    }

    public Integer getPipeWaitingDataBlockCnt(FahRegisteredAsyncPipeTypeEnum pipeType) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.getWaitingDataBlockCnt());
    }

    protected <T> T accessPipeInstance(FahRegisteredAsyncPipeTypeEnum pipeType, Function<FahAsyncStreamPipe, T> accessFunc, T defaultValue) {
        FahAsyncStreamPipe pipe;
        if (pipeType == null || pipeType.getIndex() < 0) {
            return defaultValue;
        }
        RegisteredPipeInfo pipeInfo = this.defaultPipes[pipeType.getIndex()];
        if (pipeInfo != null && (pipe = pipeInfo.getPipe()) != null) {
            return accessFunc.apply(pipe);
        }
        return defaultValue;
    }

    protected <T> T accessPipeInstance(FahRegisteredAsyncPipeTypeEnum pipeType, Function<FahAsyncStreamPipe, T> accessFunc) {
        return this.accessPipeInstance(pipeType, accessFunc, null);
    }

    public <E> FahAsyncStreamPipe<E> getPipe(FahRegisteredAsyncPipeTypeEnum pipeType) {
        return this.accessPipeInstance(pipeType, pipe -> pipe);
    }

    public <E> IFahIAsyncStreamDataBlock<E> putToQueue(FahRegisteredAsyncPipeTypeEnum pipeType, E srcData, boolean wait) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.putToQueue(srcData, wait));
    }

    public void waitQueueDataCompleted(FahRegisteredAsyncPipeTypeEnum pipeType) {
        this.accessPipeInstance(pipeType, pipe -> pipe.waitQueueDataCompleted());
    }

    public Integer getWaitingDataBlockCnt(FahRegisteredAsyncPipeTypeEnum pipeType) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.getWaitingDataBlockCnt());
    }

    public Integer getActiveConsumerCnt(FahRegisteredAsyncPipeTypeEnum pipeType) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.getActiveConsumerCnt());
    }

    public Integer getMaxQueueSize(FahRegisteredAsyncPipeTypeEnum pipeType, int queueSizePreConsumer) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.getPipeCfgInfo().getMaxQueueSize(queueSizePreConsumer));
    }

    public Integer getMaxQueueSize(FahRegisteredAsyncPipeTypeEnum pipeType) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.getPipeCfgInfo().getMaxQueueSize());
    }

    public Boolean isQueueFull(FahRegisteredAsyncPipeTypeEnum pipeType, int queueSizePreConsumer) {
        return this.accessPipeInstance(pipeType, pipe -> pipe.isQueueFull(queueSizePreConsumer));
    }
}

