/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils.pipe;

import java.io.Serializable;
import java.util.Objects;

public class FahPipeCfgInfo
implements Serializable {
    protected volatile int maxConsumerCnt = 10;
    protected volatile int queuePreConsumerThreshold = 5;
    protected volatile long ConsumerOnEmptyQueue_SleepTime = 10L;
    protected volatile int EmptyQueue_ReCheckTimes = 4;
    protected volatile long pipeLock_WaitInterval = 200L;
    protected volatile long waitingDataBlock_WaitInterval = 500L;

    public FahPipeCfgInfo() {
    }

    public FahPipeCfgInfo(int maxConsumerCnt) {
        this.maxConsumerCnt = maxConsumerCnt;
    }

    public void copy(FahPipeCfgInfo src) {
        if (src == null) {
            throw new IllegalArgumentException("Source Pipe Config is null!");
        }
        this.maxConsumerCnt = src.maxConsumerCnt;
        this.queuePreConsumerThreshold = src.queuePreConsumerThreshold;
        this.ConsumerOnEmptyQueue_SleepTime = src.ConsumerOnEmptyQueue_SleepTime;
        this.EmptyQueue_ReCheckTimes = src.EmptyQueue_ReCheckTimes;
        this.pipeLock_WaitInterval = src.pipeLock_WaitInterval;
        this.waitingDataBlock_WaitInterval = src.waitingDataBlock_WaitInterval;
    }

    public String toString() {
        return "FahPipeCfgInfo{maxConsumerCnt=" + this.maxConsumerCnt + ", queuePreConsumerThreshold=" + this.queuePreConsumerThreshold + ", ConsumerOnEmptyQueue_SleepTime=" + this.ConsumerOnEmptyQueue_SleepTime + ", EmptyQueue_ReCheckTimes=" + this.EmptyQueue_ReCheckTimes + ", pipeLock_WaitInterval=" + this.pipeLock_WaitInterval + ", waitingDataBlock_WaitInterval=" + this.waitingDataBlock_WaitInterval + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FahPipeCfgInfo)) {
            return false;
        }
        FahPipeCfgInfo that = (FahPipeCfgInfo)o;
        return this.maxConsumerCnt == that.maxConsumerCnt && this.queuePreConsumerThreshold == that.queuePreConsumerThreshold && this.ConsumerOnEmptyQueue_SleepTime == that.ConsumerOnEmptyQueue_SleepTime && this.EmptyQueue_ReCheckTimes == that.EmptyQueue_ReCheckTimes && this.pipeLock_WaitInterval == that.pipeLock_WaitInterval && this.waitingDataBlock_WaitInterval == that.waitingDataBlock_WaitInterval;
    }

    public int hashCode() {
        return Objects.hash(this.maxConsumerCnt, this.queuePreConsumerThreshold, this.ConsumerOnEmptyQueue_SleepTime, this.EmptyQueue_ReCheckTimes, this.pipeLock_WaitInterval, this.waitingDataBlock_WaitInterval);
    }

    public int getMaxConsumerCnt() {
        return this.maxConsumerCnt;
    }

    public void setMaxConsumerCnt(int maxConsumerCnt) {
        this.maxConsumerCnt = maxConsumerCnt;
    }

    public int getQueuePreConsumerThreshold() {
        return this.queuePreConsumerThreshold;
    }

    public void setQueuePreConsumerThreshold(int queuePreConsumerThreshold) {
        this.queuePreConsumerThreshold = queuePreConsumerThreshold;
    }

    public long getConsumerOnEmptyQueue_SleepTime() {
        return this.ConsumerOnEmptyQueue_SleepTime;
    }

    public void setConsumerOnEmptyQueue_SleepTime(long consumerOnEmptyQueue_SleepTime) {
        this.ConsumerOnEmptyQueue_SleepTime = consumerOnEmptyQueue_SleepTime;
    }

    public int getEmptyQueue_ReCheckTimes() {
        return this.EmptyQueue_ReCheckTimes;
    }

    public void setEmptyQueue_ReCheckTimes(int emptyQueue_ReCheckTimes) {
        this.EmptyQueue_ReCheckTimes = emptyQueue_ReCheckTimes;
    }

    public long getPipeLock_WaitInterval() {
        return this.pipeLock_WaitInterval;
    }

    public void setPipeLock_WaitInterval(long pipeLock_WaitInterval) {
        this.pipeLock_WaitInterval = pipeLock_WaitInterval;
    }

    public long getWaitingDataBlock_WaitInterval() {
        return this.waitingDataBlock_WaitInterval;
    }

    public void setWaitingDataBlock_WaitInterval(long waitingDataBlock_WaitInterval) {
        this.waitingDataBlock_WaitInterval = waitingDataBlock_WaitInterval;
    }

    public int getMaxQueueSize(int queueSizePreConsumer) {
        return this.maxConsumerCnt * queueSizePreConsumer;
    }

    public int getMaxQueueSize() {
        return this.getMaxQueueSize(this.queuePreConsumerThreshold);
    }
}

