/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils.pipe;

import kd.bos.threads.ThreadPool;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.utils.pipe.FahAsyncStreamPipe;
import kd.fi.v2.fah.utils.pipe.FahPipeCfgInfo;
import kd.fi.v2.fah.utils.pipe.FahRegisteredAsyncPipeTypeEnum;

public class RegisteredPipeInfo<E>
implements IDataItemKey<String> {
    protected String pipeRegisterKey;
    protected FahRegisteredAsyncPipeTypeEnum pipeType;
    protected FahAsyncStreamPipe<E> pipe;
    protected ThreadPool threadPool;

    public RegisteredPipeInfo(FahRegisteredAsyncPipeTypeEnum pipeType, FahAsyncStreamPipe<E> pipe, ThreadPool threadPool) {
        this.pipeType = pipeType;
        this.pipe = pipe;
        this.threadPool = threadPool;
        this.pipeRegisterKey = pipeType.name();
    }

    public RegisteredPipeInfo(String pipeRegisterKey, FahAsyncStreamPipe<E> pipe, ThreadPool threadPool) {
        this(FahRegisteredAsyncPipeTypeEnum.Custom_Temp, pipe, threadPool);
        this.pipeRegisterKey = pipeRegisterKey;
    }

    public void startPipe() {
        if (this.pipe.isStopped()) {
            this.pipe.startPipe();
        }
    }

    @Override
    public String getItemKey() {
        return this.pipeRegisterKey;
    }

    public FahRegisteredAsyncPipeTypeEnum getPipeType() {
        return this.pipeType;
    }

    public void setPipeType(FahRegisteredAsyncPipeTypeEnum pipeType) {
        this.pipeType = pipeType;
    }

    public FahAsyncStreamPipe<E> getPipe() {
        return this.pipe;
    }

    public void setPipe(FahAsyncStreamPipe<E> pipe) {
        this.pipe = pipe;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public FahPipeCfgInfo getPipeCfgInfo() {
        return this.pipe != null ? this.pipe.getPipeCfgInfo() : null;
    }

    public void setPipeCfgInfo(FahPipeCfgInfo pipeCfgInfo) {
        if (this.pipe != null) {
            this.pipe.setPipeCfgInfo(pipeCfgInfo);
        }
    }

    public String getPipeRegisterKey() {
        return this.pipeRegisterKey;
    }

    public void setPipeRegisterKey(String pipeRegisterKey) {
        this.pipeRegisterKey = pipeRegisterKey;
    }
}

