/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.v2.fah.validator.AbValidator;

public class ValidatorFactory {
    private static volatile NumberTypeValidator numberInstance;
    private static volatile IntTypeValidator intInstance;
    private static volatile BoolTypeValidator boolInstance;
    private static volatile StringTypeValidator stringInstance;

    public static synchronized NumberTypeValidator getNumberInstance() {
        if (numberInstance == null) {
            numberInstance = new NumberTypeValidator();
        }
        return numberInstance;
    }

    public static synchronized IntTypeValidator getIntInstance() {
        if (intInstance == null) {
            intInstance = new IntTypeValidator();
        }
        return intInstance;
    }

    public static synchronized BoolTypeValidator getBoolInstance() {
        if (boolInstance == null) {
            boolInstance = new BoolTypeValidator();
        }
        return boolInstance;
    }

    public static synchronized StringTypeValidator getStringInstance() {
        if (stringInstance == null) {
            stringInstance = new StringTypeValidator();
        }
        return stringInstance;
    }

    public static TextLengthValidator createTextLengthValidator(int maxLength) {
        return new TextLengthValidator(maxLength);
    }

    public static PrecisionValidator createPrecisionValidator(int precision) {
        return new PrecisionValidator(precision);
    }

    public static DateValidator createDateValidator(String datePattern) {
        return new DateValidator(datePattern);
    }

    public static AbValidator createNothingValidator() {
        return new AbValidator(){

            protected String doValidate(Object value) {
                return null;
            }
        };
    }

    public static class DateValidator
    extends AbValidator<String> {
        private String datePattern;
        private SimpleDateFormat sdf;

        public DateValidator(String datePattern) {
            this.datePattern = datePattern;
            this.sdf = new SimpleDateFormat(datePattern);
        }

        @Override
        protected String doValidate(String value) {
            try {
                Date date = this.sdf.parse(value);
                String format = this.sdf.format(date);
                return value.equals(format) ? null : this.getErrorMsg(value);
            }
            catch (Exception e) {
                return this.getErrorMsg(value);
            }
        }

        private String getErrorMsg(String value) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff1a\u201c%2$s\u201d", (String)"ValidatorFactory_5", (String)"fi-ai-common", (Object[])new Object[0]), value, this.datePattern);
        }
    }

    public static class PrecisionValidator
    extends AbValidator<Number> {
        private Integer precision;

        public PrecisionValidator(Integer precision) {
            this.precision = precision;
        }

        @Override
        protected String doValidate(Number value) {
            String numStr = value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : new BigDecimal(value.toString()).toPlainString();
            if (numStr.contains(".")) {
                String decimal = numStr.substring(numStr.indexOf(".") + 1);
                String s = decimal.replaceAll("0+$", "");
                return this.precision < s.length() ? this.getErrorMsg(value) : null;
            }
            return null;
        }

        private String getErrorMsg(Number value) {
            return String.format(ResManager.loadKDString((String)"\u6570\u503c\u201c%1$s\u201d\u7cbe\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u7cbe\u5ea6\uff1a\u201c%2$d\u201d", (String)"ValidatorFactory_4", (String)"fi-ai-common", (Object[])new Object[0]), value, this.precision);
        }
    }

    public static class StringTypeValidator
    extends AbValidator<Object> {
        private StringTypeValidator() {
        }

        @Override
        protected String doValidate(Object value) {
            return value instanceof String ? null : this.buildErrorMsg(value);
        }

        private String buildErrorMsg(Object value) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u5b57\u7b26\u7c7b\u578b", (String)"ValidatorFactory_3", (String)"fi-ai-common", (Object[])new Object[0]), value);
        }
    }

    public static class BoolTypeValidator
    extends AbValidator<Object> {
        private BoolTypeValidator() {
        }

        @Override
        protected String doValidate(Object value) {
            return value instanceof Boolean ? null : this.buildErrorMsg(value);
        }

        private String buildErrorMsg(Object value) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u5e03\u5c14\u7c7b\u578b", (String)"ValidatorFactory_2", (String)"fi-ai-common", (Object[])new Object[0]), value);
        }
    }

    public static class IntTypeValidator
    extends AbValidator<Object> {
        private IntTypeValidator() {
        }

        @Override
        protected String doValidate(Object value) {
            if (value instanceof Integer || value instanceof Short) {
                return null;
            }
            if (value instanceof BigDecimal || value instanceof Double || value instanceof Float) {
                return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u6574\u6570\u7c7b\u578b", (String)"ValidatorFactory_6", (String)"fi-ai-common", (Object[])new Object[0]), value);
            }
            if (value instanceof Number) {
                return String.format(ResManager.loadKDString((String)"\u6574\u6570\u8303\u56f4\u5e94\u8be5\u5728-2147483648\u52302147483647\u4e4b\u95f4", (String)"ValidatorFactory_7", (String)"fi-ai-common", (Object[])new Object[0]), value);
            }
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u6574\u6570\u7c7b\u578b", (String)"ValidatorFactory_6", (String)"fi-ai-common", (Object[])new Object[0]), value);
        }
    }

    public static class NumberTypeValidator
    extends AbValidator<Object> {
        private NumberTypeValidator() {
        }

        @Override
        protected String doValidate(Object value) {
            return value instanceof Number ? null : this.buildErrorMsg(value);
        }

        private String buildErrorMsg(Object value) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u662f\u6570\u503c\u7c7b\u578b", (String)"ValidatorFactory_1", (String)"fi-ai-common", (Object[])new Object[0]), value);
        }
    }

    public static class TextLengthValidator
    extends AbValidator<String> {
        private Integer maxLength;

        public TextLengthValidator(Integer maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        protected String doValidate(String value) {
            return this.maxLength < value.length() ? this.buildErrorMsg(value) : null;
        }

        private String buildErrorMsg(String value) {
            return String.format(ResManager.loadKDString((String)"\u5b57\u7b26\u201c%1$s\u201d\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\uff1a\u201c%2$d\u201d", (String)"ValidatorFactory_0", (String)"fi-ai-common", (Object[])new Object[0]), value, this.maxLength);
        }
    }
}

