/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validator.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.MasterDataGroupTypeEnum;
import kd.fi.v2.fah.constant.enums.NotNull;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.filters.MasterDataFilterHelper;
import kd.fi.v2.fah.validator.IUpdatableRef;
import kd.fi.v2.fah.validator.context.BasePropReferenceInfo;

public abstract class AbstractMasterDataValidateContext<DATA_TYPE, DATA_KEY, DATA_VALUE, REF extends IUpdatableRef<DATA_VALUE>>
implements Serializable {
    protected MasterDataGroupTypeEnum masterDataGrpType;
    protected Long orgId;
    protected Map<DATA_TYPE, Map<DATA_KEY, BasePropReferenceInfo<DATA_VALUE, REF>>> values;

    protected AbstractMasterDataValidateContext(MasterDataGroupTypeEnum masterDataGrpType, Long orgId) {
        this.masterDataGrpType = masterDataGrpType;
        this.orgId = orgId;
    }

    public AbstractMasterDataValidateContext(MasterDataGroupTypeEnum masterDataGrpType) {
        this(masterDataGrpType, null);
    }

    public boolean isEmpty() {
        return this.values == null || this.values.isEmpty();
    }

    public int size() {
        return this.values != null && !this.values.isEmpty() ? this.values.size() : 0;
    }

    public void clear() {
        if (this.values != null && !this.values.isEmpty()) {
            this.values.clear();
        }
    }

    public BasePropReferenceInfo<DATA_VALUE, REF> registerValidateData(@NotNull DATA_TYPE dataType, @NotNull DATA_KEY dataKey, DATA_VALUE dataValue, REF reference) {
        if (this.values == null) {
            this.values = new LinkedHashMap<DATA_TYPE, Map<DATA_KEY, BasePropReferenceInfo<DATA_VALUE, REF>>>(4);
        }
        BasePropReferenceInfo result = this.values.computeIfAbsent(dataType, tKey -> new LinkedHashMap(4)).computeIfAbsent(dataKey, dkey -> new BasePropReferenceInfo(dataValue, null));
        result.addReference(reference);
        return result;
    }

    public BasePropReferenceInfo<DATA_VALUE, REF> registerValidateData(DATA_TYPE dataType, DATA_KEY dataKey, REF reference) {
        return this.registerValidateData(dataType, dataKey, null, reference);
    }

    public BasePropReferenceInfo<DATA_VALUE, REF> registerValidateData(DATA_TYPE dataType, DATA_KEY dataKey) {
        return this.registerValidateData(dataType, dataKey, null, null);
    }

    public BasePropReferenceInfo<DATA_VALUE, REF> getValidateDataInfo(DATA_TYPE dataType, DATA_KEY dataKey) {
        return (BasePropReferenceInfo)this.values.getOrDefault(dataType, Collections.emptyMap()).get(dataKey);
    }

    public boolean updateValidateValue(@NotNull DATA_TYPE dataType, @NotNull DATA_KEY dataKey, @NotNull DATA_VALUE newValue, boolean needUpdateRef) {
        BasePropReferenceInfo<DATA_VALUE, REF> ref = this.getValidateDataInfo(dataType, dataKey);
        if (ref != null) {
            return ref.updateValue(newValue, needUpdateRef, new Object[0]);
        }
        return false;
    }

    public QFilter[] getQueryFilter(Object dataType) {
        String filterKeyName = this.getDataKeyFieldName();
        switch (this.masterDataGrpType) {
            case Base_Prop: {
                return MasterDataFilterHelper.buildQueryBasePropByUniqueKeysFilter(this.values.getOrDefault(dataType, Collections.emptyMap()).keySet(), filterKeyName, false).toArray(new QFilter[0]);
            }
            case Assist_Prop: 
            case GL_Account: {
                PairTuple<List<DATA_TYPE>, List<DATA_KEY>> filterValueBuf = this.collectAllDataTypeAndKeys();
                List<String> dataTypeList = ((List)filterValueBuf.getKey()).stream().map(l -> ObjectConverterFactory.convert(l, String.class)).collect(Collectors.toList());
                return MasterDataGroupTypeEnum.Assist_Prop == this.masterDataGrpType ? MasterDataFilterHelper.buildQueryAssistantPropByUniqueKeysFilter(dataTypeList, (Collection)filterValueBuf.getValue(), filterKeyName, false) : MasterDataFilterHelper.buildQueryAccountViewByUniqueKeysFilter(dataTypeList, (Collection)filterValueBuf.getValue(), filterKeyName, false);
            }
        }
        return null;
    }

    protected abstract String getDataKeyFieldName();

    protected abstract String getValidateValueFieldName();

    public abstract boolean processValidateResult(@NotNull DATA_TYPE var1, @NotNull Map<String, Object> var2, boolean var3);

    protected PairTuple<List<DATA_TYPE>, List<DATA_KEY>> collectAllDataTypeAndKeys() {
        LinkedHashSet validatedKeys = new LinkedHashSet();
        this.values.values().forEach(map -> {
            if (map != null && !map.isEmpty()) {
                validatedKeys.addAll(map.keySet());
            }
        });
        return new PairTuple(new ArrayList<DATA_TYPE>(this.values.keySet()), new ArrayList(validatedKeys));
    }

    public Iterator<Map.Entry<DATA_TYPE, Map<DATA_KEY, BasePropReferenceInfo<DATA_VALUE, REF>>>> getValueIterator() {
        return this.values == null ? null : this.values.entrySet().iterator();
    }

    public Map<DATA_TYPE, Map<DATA_KEY, BasePropReferenceInfo<DATA_VALUE, REF>>> getValues() {
        return this.values;
    }

    public Collection<String> getRefPropReferenceInfoErrorMsgs() {
        LinkedList<String> errorMsg = new LinkedList<String>();
        if (this.values != null && !this.values.isEmpty()) {
            for (Map<DATA_KEY, BasePropReferenceInfo<DATA_VALUE, REF>> map : this.values.values()) {
                if (map == null || map.isEmpty()) continue;
                for (Map.Entry<DATA_KEY, BasePropReferenceInfo<DATA_VALUE, REF>> entry : map.entrySet()) {
                    errorMsg.addAll(entry.getValue().collectUpdateErrorMsg(this.masterDataGrpType, entry.getKey()));
                }
            }
        }
        return errorMsg;
    }

    public MasterDataGroupTypeEnum getMasterDataGrpType() {
        return this.masterDataGrpType;
    }

    public void setMasterDataGrpType(MasterDataGroupTypeEnum masterDataGrpType) {
        this.masterDataGrpType = masterDataGrpType;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}

