/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validator.processor;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kd.fi.v2.fah.constant.MasterDataGroupTypeEnum;
import kd.fi.v2.fah.constant.enums.NotNull;
import kd.fi.v2.fah.log.ILogHandler;
import kd.fi.v2.fah.migration.enums.MigrationProcessStageEnum;
import kd.fi.v2.fah.task.context.BaseBackgroundTaskContext;
import kd.fi.v2.fah.validator.IUpdatableRef;
import kd.fi.v2.fah.validator.context.AbstractMasterDataValidateContext;
import kd.fi.v2.fah.validator.context.BasePropReferenceInfo;
import kd.fi.v2.fah.validator.context.IDKeyBatchValidateContext;
import kd.fi.v2.fah.validator.context.NumberKeyBatchValidateContext;
import kd.fi.v2.fah.validator.processor.IMasterDataBatchValidateProcessor;
import kd.fi.v2.fah.validator.processor.QueryMasterDataTask;

public class MasterDataBatchValidateProcessor<DATA_KEY, DATA_VALUE, REF extends IUpdatableRef<DATA_VALUE>, LOG extends ILogHandler>
implements IMasterDataBatchValidateProcessor<DATA_KEY, DATA_VALUE, REF> {
    protected LOG logHandler;
    protected BaseBackgroundTaskContext<Object> taskContext;
    protected boolean enableParallel;
    protected AbstractMasterDataValidateContext<?, DATA_KEY, DATA_VALUE, REF>[] valueGroup;
    protected Long orgId;

    public MasterDataBatchValidateProcessor(Long orgId, LOG logHandler, boolean enableParallel, BaseBackgroundTaskContext<Object> taskContext) {
        this.orgId = orgId;
        this.logHandler = logHandler;
        this.enableParallel = enableParallel;
        this.taskContext = taskContext;
        this.valueGroup = new AbstractMasterDataValidateContext[MasterDataGroupTypeEnum.values().length];
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.valueGroup.length; ++i) {
            if (this.valueGroup[i] == null) continue;
            this.valueGroup[i].clear();
        }
    }

    @Override
    public BasePropReferenceInfo<DATA_VALUE, REF> registerValidateData(@NotNull MasterDataGroupTypeEnum dataGrpType, @NotNull Object dataType, @NotNull DATA_KEY dataKey, DATA_VALUE dataValue, REF reference) {
        AbstractMasterDataValidateContext model = this.valueGroup[dataGrpType.getCode()];
        if (model == null) {
            AbstractMasterDataValidateContext abstractMasterDataValidateContext = this.createMasterDataValidateModel(dataGrpType, dataType);
            this.valueGroup[dataGrpType.getCode()] = abstractMasterDataValidateContext;
            model = abstractMasterDataValidateContext;
        }
        return model.registerValidateData(dataType, dataKey, dataValue, reference);
    }

    protected AbstractMasterDataValidateContext createMasterDataValidateModel(@NotNull MasterDataGroupTypeEnum dataGrpType, Object masterDataType) {
        if (masterDataType instanceof String) {
            return new NumberKeyBatchValidateContext(dataGrpType);
        }
        if (masterDataType instanceof Long) {
            return new IDKeyBatchValidateContext(dataGrpType);
        }
        throw new IllegalArgumentException(String.format("Unknown Master Data [Grp=%s, Type=%s]", new Object[]{dataGrpType, masterDataType}));
    }

    @Override
    public boolean doQueryAndValidate(Long orgId, BaseBackgroundTaskContext<Object> taskContext) {
        for (MasterDataGroupTypeEnum masterDataType : MasterDataGroupTypeEnum.values()) {
            if (this.valueGroup[masterDataType.getCode()] == null) continue;
            this.queryMasterData(this.valueGroup[masterDataType.getCode()], orgId, this.logHandler, this.enableParallel);
        }
        return true;
    }

    protected <DATA_TYPE> boolean queryMasterData(@NotNull AbstractMasterDataValidateContext<DATA_TYPE, DATA_KEY, DATA_VALUE, REF> dataValidateModel, Long orgId, LOG logHandler, boolean enableParallel) {
        MasterDataGroupTypeEnum masterDataGrpType = dataValidateModel.getMasterDataGrpType();
        try {
            switch (masterDataGrpType) {
                case Base_Prop: {
                    LinkedList futureList = new LinkedList();
                    for (Map.Entry<DATA_TYPE, Map<DATA_KEY, BasePropReferenceInfo<DATA_VALUE, REF>>> en : dataValidateModel.getValues().entrySet()) {
                        DATA_TYPE dataType;
                        QueryMasterDataTask task;
                        Object resultMap;
                        Object errorMsgs;
                        if (en == null || null == (errorMsgs = (resultMap = (task = QueryMasterDataTask.createQueryBasePropTask(orgId, dataType = en.getKey(), dataValidateModel, logHandler, dataValidateModel.getQueryFilter(dataType))).call()).get("errorMsgs"))) continue;
                        this.taskContext.setErrorMsg((List)errorMsgs);
                    }
                    if (!futureList.isEmpty()) {
                        for (Future future : futureList) {
                            future.get();
                        }
                    }
                    break;
                }
                case Assist_Prop: {
                    QueryMasterDataTask task = QueryMasterDataTask.createQueryAssistPropTask(dataValidateModel, logHandler, dataValidateModel.getQueryFilter(null));
                    task.call();
                    break;
                }
                case GL_Account: {
                    QueryMasterDataTask task = QueryMasterDataTask.createQueryGlAccountTask(orgId, dataValidateModel, logHandler, dataValidateModel.getQueryFilter(null));
                    task.call();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception ex) {
            logHandler.onFatal((MigrationProcessStageEnum)MigrationProcessStageEnum.Process_Migrate_Data, dataValidateModel, "Error on Create Query Task", ex, this.taskContext);
            throw new RuntimeException(String.format("Error on Execute Query Master Data Task:org=%s, model=%s,", orgId, dataValidateModel), ex);
        }
        return true;
    }

    public LOG getLogHandler() {
        return this.logHandler;
    }

    public void setLogHandler(LOG logHandler) {
        this.logHandler = logHandler;
    }

    @Override
    public boolean isEnableParallel() {
        return this.enableParallel;
    }

    @Override
    public void setEnableParallel(boolean enableParallel) {
        this.enableParallel = enableParallel;
    }

    @Override
    public Long getOrgId() {
        return this.orgId;
    }

    @Override
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}

