/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validator.processor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.dataentity.Consumer;
import kd.bos.orm.query.QFilter;
import kd.fi.v2.fah.constant.MasterDataGroupTypeEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import kd.fi.v2.fah.log.ILogHandler;
import kd.fi.v2.fah.migration.enums.MigrationProcessStageEnum;
import kd.fi.v2.fah.validator.context.AbstractMasterDataValidateContext;

public class QueryMasterDataTask<DATA_TYPE>
implements Callable<Map<String, Object>> {
    final MasterDataGroupTypeEnum masterDataGrpType;
    DATA_TYPE dataTypeKey;
    final Long orgId;
    final ILogHandler<MigrationProcessStageEnum, ?> errorHandler;
    final AbstractMasterDataValidateContext<DATA_TYPE, ?, ?, ?> srcValidateModel;
    final QFilter[] filter;
    private boolean autoUpdateRef;
    private long queryTimeCost;
    private Map<String, Object> taskResult;
    static final String TimeCost_Log_Template = "%s Query [MasterData:%s: Group:%s, Org:%s] Cnt=%d, TimeCost=%d(ms)";

    public QueryMasterDataTask(MasterDataGroupTypeEnum masterDataGrpType, DATA_TYPE dataTypeKey, Long orgId, AbstractMasterDataValidateContext srcValidateModel, ILogHandler<MigrationProcessStageEnum, ?> errorHandler, QFilter[] filter) {
        this.masterDataGrpType = masterDataGrpType;
        if (this.masterDataGrpType == null) {
            throw new IllegalArgumentException("Master Data Group Type cannot be null!");
        }
        this.srcValidateModel = srcValidateModel;
        if (this.srcValidateModel == null) {
            throw new IllegalArgumentException("Source Validation Model cannot be null!");
        }
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            throw new IllegalArgumentException("Thread Error Handler cannot be null!");
        }
        this.dataTypeKey = dataTypeKey;
        this.orgId = orgId;
        this.autoUpdateRef = true;
        this.filter = filter;
    }

    public QueryMasterDataTask(MasterDataGroupTypeEnum masterDataGrpType, Long orgId, AbstractMasterDataValidateContext srcValidateModel, ILogHandler<MigrationProcessStageEnum, ?> errorHandler, QFilter[] filter) {
        this(masterDataGrpType, null, orgId, srcValidateModel, errorHandler, filter);
    }

    public static <DATA_TYPE> QueryMasterDataTask createQueryBasePropTask(Long orgId, DATA_TYPE dataTypeKey, AbstractMasterDataValidateContext srcValidateModel, ILogHandler<MasterDataGroupTypeEnum, ?> errorHandler, QFilter[] filter) {
        return new QueryMasterDataTask<DATA_TYPE>(MasterDataGroupTypeEnum.Base_Prop, dataTypeKey, orgId, srcValidateModel, errorHandler, filter);
    }

    public static QueryMasterDataTask createQueryAssistPropTask(AbstractMasterDataValidateContext srcValidateModel, ILogHandler<MigrationProcessStageEnum, ?> errorHandler, QFilter[] filter) {
        return new QueryMasterDataTask(MasterDataGroupTypeEnum.Assist_Prop, null, srcValidateModel, errorHandler, filter);
    }

    public static QueryMasterDataTask createQueryGlAccountTask(Long orgId, AbstractMasterDataValidateContext srcValidateModel, ILogHandler<MasterDataGroupTypeEnum, ?> errorHandler, QFilter[] filter) {
        return new QueryMasterDataTask(MasterDataGroupTypeEnum.GL_Account, orgId, srcValidateModel, errorHandler, filter);
    }

    protected String getTimeCostLog(String prefix, int result, long startTime) {
        return String.format(TimeCost_Log_Template, new Object[]{prefix, this.masterDataGrpType, this.dataTypeKey, this.orgId, result, System.currentTimeMillis() - startTime});
    }

    @Override
    public Map<String, Object> call() throws Exception {
        this.queryTimeCost = System.currentTimeMillis();
        this.taskResult = new HashMap<String, Object>(4);
        this.taskResult.put("masterDataGrpType", (Object)this.masterDataGrpType);
        this.taskResult.put("dataTypeKey", this.dataTypeKey);
        this.taskResult.put("orgId", this.orgId);
        this.taskResult.put("model", this.srcValidateModel);
        this.taskResult.put("filter", this.filter);
        int queryResult = 0;
        switch (this.masterDataGrpType) {
            case Base_Prop: {
                queryResult = SysBasePropDataDaoImpl.queryBaseDataPkAndNumber((String)this.dataTypeKey, this.orgId, (Consumer<Map<String, Object>>)((Consumer)rowData -> this.srcValidateModel.processValidateResult(this.dataTypeKey, (Map<String, Object>)rowData, this.autoUpdateRef)), this.filter);
                break;
            }
            case Assist_Prop: {
                queryResult = SysBasePropDataDaoImpl.queryAssistantPkAndNumber((Consumer<Map<String, Object>>)((Consumer)rowData -> this.srcValidateModel.processValidateResult(ObjectConverterFactory.convert(rowData.get("group.number"), String.class), (Map<String, Object>)rowData, this.autoUpdateRef)), this.filter);
                break;
            }
            default: {
                queryResult = this.doCustomQuery(this.filter);
            }
        }
        Collection<String> errorMsgs = this.srcValidateModel.getRefPropReferenceInfoErrorMsgs();
        this.taskResult.put("errorMsgs", errorMsgs);
        this.taskResult.put("result", queryResult);
        return this.taskResult;
    }

    protected int doCustomQuery(QFilter[] filter) {
        return 0;
    }

    public MasterDataGroupTypeEnum getMasterDataGrpType() {
        return this.masterDataGrpType;
    }

    public Object getDataTypeKey() {
        return this.dataTypeKey;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public ILogHandler<MigrationProcessStageEnum, ?> getErrorHandler() {
        return this.errorHandler;
    }

    public AbstractMasterDataValidateContext getSrcValidateModel() {
        return this.srcValidateModel;
    }

    public long getQueryTimeCost() {
        return this.queryTimeCost;
    }

    public boolean isAutoUpdateRef() {
        return this.autoUpdateRef;
    }

    public void setAutoUpdateRef(boolean autoUpdateRef) {
        this.autoUpdateRef = autoUpdateRef;
    }

    public Map<String, Object> getTaskResult() {
        return this.taskResult;
    }
}

