/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validator.vchTemplate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.VchTemplateMatchKeyEnum;
import kd.fi.v2.fah.utils.StringUtils;

public class VchTemplateRefValidator {
    public static void checkVchTemplateRefessrence(String entityNumber, List<String> checkFields, BiConsumer<Long, PairTuple<String, String>> consumer) {
        Map<Long, String> voucherTemplateJsonMap = VchTemplateRefValidator.getVoucherTemplateJsonMap(entityNumber);
        for (Map.Entry<Long, String> entry : voucherTemplateJsonMap.entrySet()) {
            PairTuple matchFieldBuffer = new PairTuple(null, null);
            for (String checkField : checkFields) {
                Long templateId = entry.getKey();
                String json = entry.getValue();
                char[] sourceCharts = json.toCharArray();
                int counts = 0;
                int startPos = json.indexOf(checkField);
                while (startPos != -1) {
                    int leftPos = StringUtils.findWordLeftPos(sourceCharts, startPos, '\"', '\\');
                    int kvSplitterPos = StringUtils.findWordLeftPos(sourceCharts, leftPos - 1, '\"', '\\');
                    String key = StringUtils.parseWord(sourceCharts, kvSplitterPos - 1, '\"', '\\');
                    if (VchTemplateMatchKeyEnum.isKeyMatched(key)) {
                        ++counts;
                    }
                    startPos = json.indexOf(checkField, startPos + 1);
                }
                if (counts <= 0) continue;
                matchFieldBuffer.setKey((Object)checkField);
                consumer.accept(templateId, (PairTuple<String, String>)matchFieldBuffer);
            }
        }
    }

    public static Map<Long, Set<String>> checkVchTemplateRefessrence(String entityNumber, List<String> checkFields) {
        HashMap<Long, Set<String>> result = new HashMap<Long, Set<String>>();
        VchTemplateRefValidator.checkVchTemplateRefessrence(entityNumber, checkFields, (templateId, matchFieldBuffer) -> {
            HashSet<Object> fields = (HashSet<Object>)result.get(templateId);
            if (fields == null) {
                fields = new HashSet<Object>();
                fields.add(matchFieldBuffer.getKey());
            } else {
                fields.add(matchFieldBuffer.getKey());
            }
            result.put((Long)templateId, (Set<String>)fields);
        });
        return result;
    }

    public static Map<Long, String> getVoucherTemplateJsonMap(String entityNumber) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter billTypeFilter = new QFilter("fsourcebill", "=", (Object)entityNumber);
        DynamicObject dapConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_dapconfig", (String)"parentbill.id", (QFilter[])new QFilter("billentity.id", "=", (Object)entityNumber).toArray());
        if (dapConfig != null && StringUtils.isNotEmpty((String)dapConfig.getString("parentbill.id"))) {
            billTypeFilter.or(new QFilter("fsourcebill", "=", (Object)dapConfig.getString("parentbill.id")));
        }
        filterList.add(billTypeFilter);
        DynamicObject[] templateCol = BusinessDataServiceHelper.loadFromCache((String)"ai_vchtemplate", (QFilter[])filterList.toArray(new QFilter[0])).values().toArray(new DynamicObject[0]);
        HashMap<Long, String> result = new HashMap<Long, String>(templateCol.length);
        Arrays.stream(templateCol).forEach(o -> result.put(o.getLong("id"), o.getString("fxml")));
        return result;
    }
}

