/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.bizvoucher.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.bizvoucher.opplugin.BizVoucherDeleteValidator;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class BizGlVoucherDeleteValidator
extends AbstractValidator {
    private static final String QUERY_SQL = "SELECT FID,FGLVOUCHERID FROM T_AI_BIZVOUCHER WHERE ";

    public void validate() {
        List<Long> bizVoucherIdList = this.getBizVoucherId(this.dataEntities);
        Map<Long, Long> voucherMap = this.getBizVoucherBill(bizVoucherIdList);
        ArrayList<Long> glIdList = new ArrayList<Long>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> entityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dynamic = entity.getDataEntity();
            Long bizId = dynamic.getLong("id");
            Long glvoucherId = voucherMap.get(bizId);
            if (glvoucherId == null || 0L == glvoucherId) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u51ed\u8bc1\u672a\u751f\u6210\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"BizGlVoucherDeleteValidator_0", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                continue;
            }
            glIdList.add(glvoucherId);
            entityMap.put(glvoucherId, entity);
        }
        if (!glIdList.isEmpty()) {
            Map<Long, String> map = this.getVoucherStatus(glIdList);
            Iterator iterator = glIdList.iterator();
            while (iterator.hasNext()) {
                Long glId = (Long)iterator.next();
                if (!"C".equalsIgnoreCase(map.get(glId))) continue;
                this.addErrorMessage((ExtendedDataEntity)entityMap.get(glId), ResManager.loadKDString((String)"\u51ed\u8bc1\u5df2\u5ba1\u6838\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"BizGlVoucherDeleteValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                iterator.remove();
            }
        }
        if (!glIdList.isEmpty()) {
            this.bizDeleteGlVoucher(glIdList, entityMap);
        }
    }

    private void bizDeleteGlVoucher(List<Long> glIdList, Map<Long, ExtendedDataEntity> entityMap) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isBizDeleteVoucher", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])glIdList.toArray(), (OperateOption)operateOption);
        HashSet<Long> voucherIdSet = new HashSet<Long>(glIdList);
        if (!result.isSuccess()) {
            List allInfo = result.getAllErrorOrValidateInfo();
            for (IOperateInfo info : allInfo) {
                Long glvoucherId = (Long)info.getPkValue();
                voucherIdSet.remove(glvoucherId);
                this.addErrorMessage(entityMap.get(glvoucherId), info.getMessage());
            }
        }
        if (!voucherIdSet.isEmpty()) {
            String joinIds = QFilterBuilder.buildSQLParamHolder((int)voucherIdSet.size());
            DB.execute((DBRoute)FAHCommonConstant.AI, (String)("Update t_ai_bizvoucher set FBuildGLVoucher = '0', FGLVoucherId = 0 where fglvoucherid in " + joinIds), (Object[])voucherIdSet.toArray());
        }
    }

    private Map<Long, String> getVoucherStatus(List<Long> ids) {
        HashMap<Long, String> map = new HashMap<Long, String>(this.dataEntities.length);
        if (!ids.isEmpty()) {
            QFilter fid = new QFilter("id", "in", ids);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)BizVoucherDeleteValidator.class.getName(), (String)"gl_voucher", (String)"id,billstatus", (QFilter[])new QFilter[]{fid}, null);){
                for (Row row : ds) {
                    map.put(row.getLong("id"), row.getString("billstatus"));
                }
            }
        }
        return map;
    }

    private Map<Long, Long> getBizVoucherBill(List<Long> billIds) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(billIds.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(QUERY_SQL, new Object[0]).appendIn("FID", new ArrayList<Long>(billIds));
        try (DataSet qd = DB.queryDataSet((String)BizVoucherDeleteValidator.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                map.put(row.getLong("FID"), row.getLong("FGLVOUCHERID"));
            }
        }
        return map;
    }

    private List<Long> getBizVoucherId(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject v = entity.getDataEntity();
            ids.add(v.getLong("id"));
        }
        return ids;
    }
}

