/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.bizvoucher.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.BizVoucherValidatorParam;
import kd.fi.ai.BussinessVoucher;
import kd.fi.ai.bizvoucher.opplugin.BaseBizVoucherValidator;
import kd.fi.ai.bizvoucher.opplugin.BizVoucherEntryQtyAndPriceValidator;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.GLUtil;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;

public class BizVoucherSaveValidator
extends BaseBizVoucherValidator {
    public BizVoucherSaveValidator() {
        this.init();
    }

    @Override
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.validateHandle(dataEntity);
        }
    }

    @Override
    protected void baseValidate(DynamicObject vo) {
        String billno = vo.getString("billno");
        if (StringUtils.isEmpty((String)billno)) {
            this.getErrorMsg().append(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BizVoucherSaveValidator_0", (String)"fi-ai-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    @Override
    public void entryValidate(ExtendedDataEntity dataEntity) {
        DynamicObject vo = dataEntity.getDataEntity();
        DynamicObjectCollection entries = vo.getDynamicObjectCollection("entryentity");
        if (entries.size() == 0) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BizVoucherSaveValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = vo.getLong(BussinessVoucher.id_((String)"org"));
        long bookId = vo.getLong(BussinessVoucher.id_((String)"book"));
        this.checkComAssist(bookId, entries, dataEntity);
        BizVoucherValidatorParam bizVoucherParam = new BizVoucherValidatorParam();
        boolean checkOriAmount = !"2".equals(dataEntity.getDataEntity().getString("sourcetype"));
        bizVoucherParam.setCheckOriAmount(checkOriAmount);
        int amtprecision = vo.getDynamicObject("localcur").getInt("amtprecision");
        int counts = 0;
        for (DynamicObject entry : entries) {
            BizVoucherEntryQtyAndPriceValidator.appendEntryMsg(this.getEntryMsg(), BizVoucherEntryQtyAndPriceValidator.validate(orgId, entry));
            this.setCheckOriAmountParam(bizVoucherParam, entry);
            this.setCheckCashFlowParam(bizVoucherParam, amtprecision, entry, dataEntity);
            this.checkExpireDate(entry, vo.getDate("bizdate"), dataEntity);
            ++counts;
        }
        if (bizVoucherParam.isCheckOriAmount()) {
            checkOriAmount = GLUtil.getBooleanParam((String)"checkoriamount", (long)orgId, (boolean)false);
            bizVoucherParam.setCheckOriAmount(checkOriAmount);
        }
        this.checkVoucherAmount(bizVoucherParam, dataEntity, orgId);
        boolean includeBWAccount = bizVoucherParam.isIncludeBWAccount();
        this.checkAccountEntry(counts, !includeBWAccount, includeBWAccount, dataEntity);
        OperateOption option = this.getOption();
        boolean noverifybal = option.containsVariable("noVerifyBal");
        if (!noverifybal) {
            // empty if block
        }
    }

    private void checkComAssist(Long bookId, DynamicObjectCollection entries, ExtendedDataEntity dataEntity) {
        if (!this.isValidateBizVoucherDCBalance()) {
            return;
        }
        String sql = "select faccounttableid from t_bd_accountbooks where fid =" + bookId;
        Long attableId = 0L;
        try (DataSet queryDataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            Iterator iterator = queryDataSet.iterator();
            if (iterator.hasNext()) {
                attableId = ((Row)iterator.next()).getLong("faccounttableid");
            }
        }
        if (attableId == 0L) {
            return;
        }
        List comAssist = AiCommonFieldUtils.getComAssist((Long)attableId);
        if (comAssist.isEmpty()) {
            return;
        }
        HashSet<String> isrequire = new HashSet<String>(2);
        HashSet<String> isbalance = new HashSet<String>(2);
        String sourceName = "";
        for (Object cai : comAssist) {
            if (cai.isIsrequire()) {
                isrequire.add("comassist" + cai.getSeq() + "_id");
            }
            if (!cai.isIsbalance()) continue;
            isbalance.add("comassist" + cai.getSeq() + "_id");
            sourceName = cai.getValuesource() != null ? cai.getValuesource().toString() : "";
        }
        if (isrequire.isEmpty() && isbalance.isEmpty()) {
            return;
        }
        HashMap<Long, BigDecimal> balanceMoney = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject entry : entries) {
            Object value;
            int seq = entry.getInt("seq");
            for (String key : isrequire) {
                value = entry.get(key);
                if (value != null && !value.equals("")) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u672a\u586b\u5199\u3002", (String)"BizVoucherSaveValidator_22", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq));
            }
            for (String key : isbalance) {
                value = entry.get(key);
                if (value == null) continue;
                long comassistId = Long.parseLong(value.toString());
                BigDecimal money = balanceMoney.computeIfAbsent(comassistId, v -> new BigDecimal(0)).add(entry.getBigDecimal("creditlocal")).subtract(entry.getBigDecimal("debitlocal"));
                balanceMoney.put(comassistId, money);
            }
        }
        Set collect = balanceMoney.entrySet().stream().filter(f -> ((BigDecimal)f.getValue()).compareTo(new BigDecimal(0)) != 0).map(m -> (Long)m.getKey()).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            String name = "";
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)sourceName, (String)"name", (QFilter[])new QFilter("id", "in", collect).toArray());
            if (queryOne != null) {
                name = queryOne.getString("name");
            }
            this.addMessage(dataEntity, name + String.format(ResManager.loadKDString((String)"\u5c5e\u4e8e\u5e73\u8861\u516c\u5171\u7ef4\u5ea6\uff0c\u4f46\u662f\u5b58\u5728\u501f\u8d37\u4e0d\u5e73\u3002", (String)"BizVoucherSaveValidator_23", (String)"fi-ai-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void setCheckCashFlowParam(BizVoucherValidatorParam bizParam, int amtprecision, DynamicObject entry, ExtendedDataEntity dataEntity) {
        BigDecimal rate;
        DynamicObject mainItem = entry.getDynamicObject("maincfitem");
        DynamicObject suppItem = entry.getDynamicObject("supcfitem");
        BigDecimal mainCFAmt = entry.getBigDecimal("maincfamount");
        BigDecimal suppCFAmt = entry.getBigDecimal("supfamount");
        DynamicObject acct = (DynamicObject)entry.get("account");
        int seq = entry.getInt("seq");
        if (null == acct) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u672a\u586b\u5199\u3002", (String)"BizVoucherSaveValidator_2", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq));
            return;
        }
        BigDecimal creditLoc = entry.getBigDecimal("creditlocal");
        BigDecimal debitLoc = entry.getBigDecimal("debitlocal");
        BigDecimal creditOri = entry.getBigDecimal("creditori");
        BigDecimal debitOri = entry.getBigDecimal("debitori");
        BigDecimal quantity = entry.getBigDecimal("quantity");
        BigDecimal price = entry.getBigDecimal("price");
        String vdesc = entry.getString("edescription");
        String accountNumber = entry.getString("account.number");
        if (StringUtils.isEmpty((String)vdesc)) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u6458\u8981\u672a\u586b\u5199\u3002", (String)"BizVoucherSaveValidator_3", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq, accountNumber));
        }
        if ((rate = entry.getBigDecimal("localrate")) != null && rate.compareTo(BigDecimal.ZERO) < 0) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u6c47\u7387\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"BizVoucherSaveValidator_4", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq, accountNumber));
        }
        if (creditLoc.signum() == 0 && debitLoc.signum() == 0 && (creditOri.signum() != 0 || debitOri.signum() != 0)) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u4e0d\u5141\u8bb8\u539f\u5e01\u91d1\u989d\u4e0d\u4e3a\u96f6\uff0c\u4f46\u672c\u4f4d\u5e01\u91d1\u989d\u4e3a\u96f6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizVoucherSaveValidator_5", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq, accountNumber));
        }
        if (!(creditOri.signum() == 0 && creditLoc.signum() == 0 || debitOri.signum() == 0 && debitLoc.signum() == 0)) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u501f\u8d37\u65b9\u90fd\u6709\u503c\u3002", (String)"BizVoucherSaveValidator_6", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq, accountNumber));
        }
        if (acct.getBoolean("isqty") && (creditOri.signum() != 0 || debitOri.signum() != 0) && creditLoc.signum() == 0 && debitLoc.signum() == 0) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u4e0d\u5141\u8bb8\u539f\u5e01\u91d1\u989d\u4e0d\u4e3a\u96f6\uff0c\u4f46\u672c\u4f4d\u5e01\u91d1\u989d\u4e3a\u96f6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizVoucherSaveValidator_5", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq, accountNumber));
        }
        int priceprecision = entry.getDynamicObject("currency").getInt("priceprecision");
        if (price.multiply(quantity).doubleValue() > 0.0 && price.multiply(quantity).setScale(amtprecision, RoundingMode.HALF_UP).compareTo(debitOri) != 0 && price.multiply(quantity).setScale(amtprecision, RoundingMode.HALF_UP).compareTo(creditOri) != 0 && creditOri.divide(quantity, priceprecision, RoundingMode.HALF_UP).compareTo(price) != 0 && debitOri.divide(quantity, priceprecision, RoundingMode.HALF_UP).compareTo(price) != 0) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u79d1\u76ee\u201c%2$s\u201d\uff1a\u5355\u4ef7\u3001\u6570\u91cf\u4e0e\u5b9e\u9645\u53d1\u751f\u989d\u4e0d\u4e00\u81f4\u3002", (String)"BizVoucherSaveValidator_8", (String)"fi-ai-opplugin", (Object[])new Object[0]), seq, accountNumber));
        }
        if (!bizParam.isMainCF() && mainItem != null) {
            bizParam.setMainCF(true);
        }
        if (!bizParam.isSuppCF() && suppItem != null) {
            bizParam.setSuppCF(true);
        }
        boolean isCash = GLUtil.isCashAcct((DynamicObject)acct);
        boolean isPL = GLUtil.isPLAcct((DynamicObject)acct);
        if (!bizParam.isHashCash() && isCash) {
            bizParam.setHashCash(true);
        }
        if (!bizParam.isHasPL() && isPL) {
            bizParam.setHasPL(true);
        }
        if (!(bizParam.isNotC_NotPL() || isPL || isCash)) {
            bizParam.setNotC_NotPL(true);
        }
        BigDecimal[] cashAmt = bizParam.getCashAmt();
        if (isCash) {
            cashAmt[0] = cashAmt[0].add(debitLoc).subtract(creditLoc);
        }
        if (mainItem != null) {
            boolean in = true;
            if ("o".equals(mainItem.getString("direction"))) {
                in = false;
            }
            cashAmt[1] = in ? cashAmt[1].add(mainCFAmt) : cashAmt[1].subtract(mainCFAmt);
            boolean isDealactivity = mainItem.getBoolean("isdealactivity");
            if (isDealactivity) {
                BigDecimal bigDecimal = cashAmt[2] = in ? cashAmt[2].add(mainCFAmt) : cashAmt[2].subtract(mainCFAmt);
            }
            if (!bizParam.isNeedDesign()) {
                if (isPL) {
                    if (!isDealactivity) {
                        bizParam.setNeedDesign(true);
                    }
                } else if (isDealactivity) {
                    bizParam.setNeedDesign(true);
                }
            }
            if (!bizParam.isPlMainCf() && isPL) {
                bizParam.setPlMainCf(true);
            }
        } else if (!isCash && bizParam.isHashCash() && !bizParam.isNeedDesign()) {
            bizParam.setNeedDesign(true);
        }
        if (isPL) {
            cashAmt[3] = cashAmt[3].add(creditLoc).subtract(debitLoc);
        }
        if (suppItem != null) {
            cashAmt[4] = cashAmt[4].add(suppCFAmt);
        }
    }

    private void checkExpireDate(DynamicObject entry, Date bizDate, ExtendedDataEntity dataEntity) {
        DynamicObject acct = (DynamicObject)entry.get("account");
        if (acct != null && acct.getBoolean("accheck")) {
            Date expireDate = entry.getDate("expiredate");
            int entrySeq = entry.getInt("seq") + 1;
            if (null == expireDate) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%d\u201d\u884c\uff0c\u5f80\u6765\u79d1\u76ee\u7684\u5230\u671f\u65e5\u672a\u586b\u5199\u3002", (String)"BizVoucherSaveValidator_11", (String)"fi-ai-opplugin", (Object[])new Object[0]), entrySeq));
            } else {
                Calendar c = Calendar.getInstance();
                c.setTime(expireDate);
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                if (c.getTime().before(bizDate)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%d\u201d\u884c\uff0c\u5230\u671f\u65e5\u4e0d\u80fd\u65e9\u4e8e\u4e1a\u52a1\u65e5\u671f\u3002", (String)"BizVoucherSaveValidator_12", (String)"fi-ai-opplugin", (Object[])new Object[0]), entrySeq));
                }
            }
        }
    }

    private void setCheckOriAmountParam(BizVoucherValidatorParam bizParam, DynamicObject entry) {
        BigDecimal creditOri = entry.getBigDecimal("creditori");
        BigDecimal creditLoc = entry.getBigDecimal("creditlocal");
        BigDecimal debitOri = entry.getBigDecimal("debitori");
        BigDecimal debitLoc = entry.getBigDecimal("debitlocal");
        Long currencyIdForCheckOriAmount = 0L;
        BigDecimal[][] amounts = bizParam.getAmounts();
        if (creditLoc.signum() == 0) {
            amounts[0][0] = amounts[0][0].add(debitOri);
            amounts[0][1] = amounts[0][1].add(debitLoc);
        } else {
            amounts[1][0] = amounts[1][0].add(creditOri);
            amounts[1][1] = amounts[1][1].add(creditLoc);
        }
        DynamicObject acct = (DynamicObject)entry.get("account");
        if (acct != null && acct.getBoolean("bw")) {
            bizParam.setIncludeBWAccount(true);
        }
        Long currencyID = entry.getLong("currency.id");
        if (bizParam.isCheckOriAmount() && currencyIdForCheckOriAmount == 0L) {
            currencyIdForCheckOriAmount = currencyID;
        } else if (bizParam.isCheckOriAmount() && !currencyIdForCheckOriAmount.equals(currencyID)) {
            bizParam.setCheckOriAmount(false);
        }
    }

    private void checkAccountEntry(int counts, boolean includeBNAccount, boolean includeBWAccount, ExtendedDataEntity dataEntity) {
        if (!this.isValidateBizVoucherDCBalance()) {
            return;
        }
        if (includeBNAccount && includeBWAccount) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u51ed\u8bc1\u4e0d\u5141\u8bb8\u540c\u65f6\u5305\u542b\u8868\u5185\u79d1\u76ee\u4e0e\u8868\u5916\u79d1\u76ee\u3002", (String)"BizVoucherSaveValidator_18", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
        if (!includeBWAccount && counts < 2) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u5e94\u8be5\u81f3\u5c11\u5b58\u5728\u4e24\u6761\u5206\u5f55\u3002", (String)"BizVoucherSaveValidator_19", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkVoucherAmount(BizVoucherValidatorParam bizParam, ExtendedDataEntity dataEntity, Long orgId) {
        if (!this.isValidateBizVoucherDCBalance()) {
            return;
        }
        boolean checkBwAccount = GLUtil.getBooleanParam((String)"checkbwaccount", (long)orgId, (boolean)false);
        if ((!bizParam.isIncludeBWAccount() || checkBwAccount) && bizParam.getAmounts()[0][1].compareTo(bizParam.getAmounts()[1][1]) != 0) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u501f\u8d37\u4e0d\u76f8\u7b49\uff0c\u501f\u65b9\u91d1\u989d\u201c%1$s\u201d\uff0c\u8d37\u65b9\u91d1\u989d\u201c%2$s\u201d\u3002", (String)"BizVoucherSaveValidator_24", (String)"fi-ai-opplugin", (Object[])new Object[0]), bizParam.getAmounts()[0][1].toString(), bizParam.getAmounts()[1][1].toString()));
            return;
        }
        if (bizParam.isCheckOriAmount() && (!bizParam.isIncludeBWAccount() || checkBwAccount) && bizParam.getAmounts()[0][0].compareTo(bizParam.getAmounts()[1][0]) != 0) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u539f\u5e01\u501f\u8d37\u4e0d\u76f8\u7b49\uff0c\u501f\u65b9\u91d1\u989d\u201c%1$s\u201d\uff0c\u8d37\u65b9\u91d1\u989d\u201c%2$s\u201d\u3002%3$s", (String)"BizVoucherSaveValidator_25", (String)"fi-ai-opplugin", (Object[])new Object[0]), bizParam.getAmounts()[0][0].toString(), bizParam.getAmounts()[1][0].toString(), "\n"));
            return;
        }
    }

    private boolean isValidateBizVoucherDCBalance() {
        return (Boolean)ThreadCache.get((Object)"isValidateBizVoucherDCBalance", FahOptimizeControlPanel::isValidateBizVoucherDCBalance);
    }
}

