/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.bizvoucher.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class GenerateBizVoucherValidator
extends AbstractValidator {
    public void validate() {
        int length = this.dataEntities.length;
        HashMap<Long, ExtendedDataEntity> entityMap = new HashMap<Long, ExtendedDataEntity>(length);
        HashMap<String, Set> billTypAndBillids = new HashMap<String, Set>(2);
        HashMap<Long, Long> billToVoucherID = new HashMap<Long, Long>(length);
        HashMap<Long, Long> billToBizVoucherID = new HashMap<Long, Long>(length);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject dynamicObject = entity.getDataEntity();
            billToVoucherID.put(dynamicObject.getLong("id"), dynamicObject.getLong("voucherid"));
            billToBizVoucherID.put(dynamicObject.getLong("id"), dynamicObject.getLong("bizvoucherid"));
        }
        HashSet existVids = new HashSet(QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{new QFilter("id", "in", billToVoucherID.values())}, null, (int)-1));
        Set<Long> hasEntry = this.hasEntryBizVoucherIds(billToBizVoucherID.values());
        HashSet<Long> invalidIDs = new HashSet<Long>(2);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject v = entity.getDataEntity();
            if (!existVids.contains(billToVoucherID.get(v.getLong("id")))) {
                invalidIDs.add(v.getLong("id"));
                continue;
            }
            if (hasEntry.contains(billToBizVoucherID.get(v.getLong("id")))) {
                invalidIDs.add(v.getLong("id"));
                continue;
            }
            String key = v.getString("billtype.id") + "&" + v.getString("vchtemplateid");
            Set billIds = billTypAndBillids.computeIfAbsent(key, c -> new HashSet());
            billIds.add(v.getLong("sourcebillid"));
            entityMap.put(v.getLong("sourcebillid"), entity);
        }
        if (invalidIDs.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)this.dataEntities[0].getDataEntity().getDataEntityType(), (Object[])invalidIDs.toArray());
        }
        for (Map.Entry entry : billTypAndBillids.entrySet()) {
            this.genBizVoucher(entry, entityMap);
        }
    }

    private void genBizVoucher(Map.Entry<String, Set<Long>> entry, Map<Long, ExtendedDataEntity> entityMap) {
        String key = entry.getKey();
        String entityName = key.split("&")[0];
        String vchtemplateid = key.split("&")[1];
        Set<Long> billIds = entry.getValue();
        OperateOption operateOption = OperateOption.create();
        HashMap map = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(vchtemplateid);
        Long id = billIds.iterator().next();
        map.put(id, ids);
        operateOption.setVariableValue("tempId", SerializationUtils.toJsonString(map));
        operateOption.setVariableValue("BuildVoucherType", "1");
        operateOption.setVariableValue("buildBizvoucherFromMidle", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"generatevoucher", (String)entityName, (Object[])billIds.toArray(), (OperateOption)operateOption);
        if (!result.isSuccess()) {
            List allInfo = result.getAllErrorOrValidateInfo();
            for (IOperateInfo info : allInfo) {
                Long sourceId = (Long)info.getPkValue();
                this.addErrorMessage(entityMap.get(sourceId), info.getMessage());
            }
        }
    }

    private Set<Long> hasEntryBizVoucherIds(Collection<Long> bizVoucherIdList) {
        HashSet<Long> normalIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fid as id from t_ai_bizvoucher as b where ", new Object[0]).appendIn(" b.fid", new ArrayList<Long>(bizVoucherIdList)).append(" and exists ( select 1 from t_ai_bizvoucherentry as e where e.fid=b.fid )", new Object[0]);
        try (DataSet qd = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                normalIds.add(row.getLong("id"));
            }
        }
        return normalIds;
    }
}

