/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.datamapping.opplugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.v2.fah.context.ExtDataSaveCtx;
import kd.fi.v2.fah.context.ExtDataSaveCtxHelper;
import kd.fi.v2.fah.dao.biz.ExtDataSaveHelper;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.validate.ExtDataValidateUtils;
import kd.fi.v2.fah.validator.MsgInfo;

public class AiEventRecalibrationOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AiEventRecalibrationValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("eventclass.number");
        e.getFieldKeys().add("eventclass_id");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("versionnum");
        e.getFieldKeys().add("description");
        e.getFieldKeys().add("paging");
        e.getFieldKeys().add("sourcesys");
        e.getFieldKeys().add("data_tag");
        e.getFieldKeys().add("org_id");
        e.getFieldKeys().add("createtime");
    }

    public static class AiEventRecalibrationValidator
    extends AbstractValidator {
        public void validate() {
            ExtendedDataEntity[] oldEntities;
            Tuple<Map<String, Map<Long, List<ExtendedDataEntity>>>, ExtendedDataEntity[]> newAndOldData = ExtDataValidateUtils.checkModelOrg(this.getDataEntities());
            for (ExtendedDataEntity entity : oldEntities = (ExtendedDataEntity[])newAndOldData.item2) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e3a\u65e7\u6a21\u578b\u7684\u5916\u90e8\u6570\u636e\uff0c\u4e0d\u652f\u6301\u91cd\u65b0\u6821\u9a8c\u529f\u80fd\u3002", (String)"AiEventRecalibrationOp_0", (String)"fi-ai-opplugin", (Object[])new Object[0]), entity.getValue("number")));
            }
            LinkedList requestEntities = new LinkedList();
            if (null != newAndOldData.item1 && ((Map)newAndOldData.item1).size() > 0) {
                Map newEntities = (Map)newAndOldData.item1;
                for (Map.Entry entry : newEntities.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        List list = ((List)entry2.getValue()).stream().filter(s -> !"3".equals(s.getValue("status"))).collect(Collectors.toList());
                        for (ExtendedDataEntity entity : list) {
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u53ea\u6709\u6821\u9a8c\u5931\u8d25\u7684\u5916\u90e8\u6570\u636e\uff0c\u624d\u5141\u8bb8\u91cd\u65b0\u6821\u9a8c\u3002", (String)"AiEventRecalibrationOp_1", (String)"fi-ai-opplugin", (Object[])new Object[0]), entity.getValue("number")));
                        }
                        List requestEntity = ((List)entry2.getValue()).stream().filter(s -> "3".equals(s.getValue("status"))).collect(Collectors.toList());
                        entry2.setValue(requestEntity);
                        requestEntities.addAll(requestEntity);
                    }
                }
                if (requestEntities.size() < 1) {
                    return;
                }
                ExtDataSaveCtx extDataSaveCtx = ExtDataSaveCtxHelper.createExtDataSaveCtx();
                ExtDataValidateUtils.validateAndRecaliBration((Map)newAndOldData.item1, true);
                this.saveData(extDataSaveCtx, this.getDataEntities());
                List allErrorMsgInfo = extDataSaveCtx.getAllErrorMsgInfo();
                if (allErrorMsgInfo != null && allErrorMsgInfo.size() > 0) {
                    for (MsgInfo msgInfo : allErrorMsgInfo) {
                        ExtendedDataEntity entity = extDataSaveCtx.getExtDataEntity(msgInfo.getModelNum(), msgInfo.getOrgId(), msgInfo.getExtDataNum());
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5916\u90e8\u6570\u636e\u6821\u9a8c\u5931\u8d25\uff1a%2$s\u201c%3$s\u201d\u3002", (String)"AiEventRecalibrationOp_2", (String)"fi-ai-opplugin", (Object[])new Object[0]), entity.getValue("number"), "\n", msgInfo.getMsg()));
                    }
                }
            }
        }

        private void saveData(ExtDataSaveCtx extDataSaveCtx, ExtendedDataEntity[] entities) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    HashMap<String, Set> allExtDataSdoMap = new HashMap<String, Set>();
                    Map failedExtDataMap = extDataSaveCtx.getAllFailedExtDataSdoMap();
                    Map successExtDataSdoMap = extDataSaveCtx.getAllSuccessExtDataSdoMap();
                    for (Map.Entry entry : failedExtDataMap.entrySet()) {
                        allExtDataSdoMap.computeIfAbsent((String)entry.getKey(), key -> new HashSet()).addAll(((List)entry.getValue()).stream().map(SimpleDynamicObject::getPkValue).collect(Collectors.toSet()));
                    }
                    HashSet successIds = new HashSet();
                    for (Map.Entry entry : successExtDataSdoMap.entrySet()) {
                        successIds.addAll(((List)entry.getValue()).stream().map(SimpleDynamicObject::getPkValue).collect(Collectors.toSet()));
                        allExtDataSdoMap.computeIfAbsent((String)entry.getKey(), key -> new HashSet()).addAll(successIds);
                    }
                    HashSet hashSet = new HashSet();
                    for (Map.Entry entry : allExtDataSdoMap.entrySet()) {
                        String metaName = DataModelDaoImpl.getMetaEntityNumber((String)((String)entry.getKey()));
                        Set ids = (Set)entry.getValue();
                        BusinessDataWriter.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)metaName), (Object[])ids.toArray(new Object[0]), (boolean)true);
                        hashSet.addAll(ids);
                    }
                    ExtDataSaveHelper.updateErrorDataToExpired(hashSet);
                    for (List list : failedExtDataMap.values()) {
                        ExtDataSaveHelper.saveExtDataBatch((List)list);
                    }
                    if (successIds.size() > 0) {
                        Map map = extDataSaveCtx.getModelTables();
                        ExtDataSaveHelper.checkRepeatDataAndUpdateToExpired((Map)successExtDataSdoMap, (Map)map);
                        List<DynamicObject> list = Arrays.stream(entities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()).stream().filter(s -> successIds.contains(s.get("id"))).collect(Collectors.toList());
                        ExtDataSaveHelper.updateRepeatEventData((DynamicObject[])list.toArray(new DynamicObject[0]));
                        ExtDataSaveHelper.updateToActive(successIds);
                        for (List sdoList : successExtDataSdoMap.values()) {
                            ExtDataSaveHelper.saveExtDataBatch((List)sdoList);
                        }
                    }
                    List list = extDataSaveCtx.getAllErrorMsgInfoNeedSave();
                    ExtDataSaveHelper.saveErrorMsg((List)list);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

