/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.datamapping.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.cache.AiEntityMetadataLocalCache;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.ai.enums.EventPreStatusEnum;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.event.BuildVoucherMqUtil;
import kd.fi.ai.validate.AiEventSaveValidator;
import kd.fi.v2.fah.context.ExtDataSaveCtxHelper;
import kd.fi.v2.fah.dao.biz.ExtDataSaveHelper;
import kd.fi.v2.fah.datamapping.opplugin.ExtDataSaveOp;
import kd.fi.v2.fah.log.FahPoaFeatureMonitor;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.utils.DateValueUtils;
import kd.fi.v2.fah.utils.SdoUtil;

public class AiEventSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AiEventSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ExtDataSaveHelper.updateRepeatEventData((DynamicObject[])e.getDataEntities());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.saveEvtIndex(e.getDataEntities());
        this.deleteEventBlock(e.getDataEntities());
        ExtDataSaveOp.saveSuccessExtData();
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String lockId;
        super.afterExecuteOperationTransaction(e);
        List<Long> onTimeIds = this.getOnTimeIds(e);
        if (!onTimeIds.isEmpty()) {
            BuildVoucherMqUtil.buildVoucherByMq(onTimeIds);
        }
        if (this.getOption().containsVariable("lockId") && StringUtils.isNotBlank((CharSequence)(lockId = this.operateOption.getVariableValue("lockId")))) {
            Set lockIDs = (Set)SerializationUtils.fromJsonString((String)lockId, HashSet.class);
            MutexRequireUtil.batchReleaseForScheme((Collection)lockIDs, (String)"ai_event");
        }
        ExtDataSaveOp.releaseLockedIds();
        ExtDataSaveOp.triggerBizEventForBuildVoucher();
        this.poaFeatureMonitor_output(e.getDataEntities().length);
    }

    private void poaFeatureMonitor_output(int dataCount) {
        Map allSuccessExtDataSdoMap = ExtDataSaveCtxHelper.getExtDataSaveCtx().getAllSuccessExtDataSdoMap();
        HashMap<String, String> varMap = new HashMap<String, String>(allSuccessExtDataSdoMap.size());
        varMap.put("API", "saveAiEvent");
        int entryCount = 0;
        for (Map.Entry entry : allSuccessExtDataSdoMap.entrySet()) {
            entryCount += SdoUtil.countAllDataLine((SimpleDynamicObject[])((List)entry.getValue()).toArray(new SimpleDynamicObject[0]));
            varMap.put((String)entry.getKey(), String.valueOf(((List)entry.getValue()).size()));
        }
        varMap.put("entryCount", String.valueOf(entryCount));
        long cost = DateValueUtils.cost();
        FahPoaFeatureMonitor.output(null, (String)"EAH-2023-ZT02-TX01", (int)dataCount, (Long)cost, (String)"ai_event", varMap);
    }

    private void deleteEventBlock(DynamicObject[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        HashMap<Long, Set> evtMap = new HashMap<Long, Set>();
        for (DynamicObject dynamicObject : objs) {
            evtMap.computeIfAbsent(dynamicObject.getLong("eventclass.masterid"), p -> new HashSet()).add(dynamicObject.getLong("id"));
        }
        HashSet<Long> deleteClassPkIds = new HashSet<Long>();
        QFilter[] filters = new QFilter[]{new QFilter("preevent.preeventclass.masterid", "in", evtMap.keySet())};
        Throwable throwable = null;
        try (DataSet dsEventClass = QueryServiceHelper.queryDataSet((String)"AiEventSaveOp.deleteEventBlock", (String)"ai_eventclass", (String)"preevent.preeventclass.masterid evtclassid,preevent.prestatus prestatus", (QFilter[])filters, null);){
            Iterator rows = dsEventClass.iterator();
            while (rows != null && rows.hasNext()) {
                Row row = (Row)rows.next();
                Long id = row.getLong("evtclassid");
                String prestatus = row.getString("prestatus");
                if (!EventPreStatusEnum.EVENT.getValue().equals(prestatus)) continue;
                deleteClassPkIds.add(id);
            }
        }
        catch (Throwable rows) {
            Throwable throwable2 = rows;
            throw rows;
        }
        for (Long l : deleteClassPkIds) {
            Set deletePkIds = (Set)evtMap.get(l);
            if (CollectionUtils.isEmpty((Collection)deletePkIds)) continue;
            Map blockEventMap = AiEventUtil.getEventBlockEventInfoV2((Long)l, new LinkedList(deletePkIds));
            AiEventUtil.deleteEventBlock(blockEventMap == null ? null : blockEventMap.keySet());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void saveEvtIndex(DynamicObject[] objs) {
        void var6_8;
        HashSet<Object> evtClassPkSet = new HashSet<Object>(objs.length);
        LocalMemoryCache localCache = AiEntityMetadataLocalCache.getLocalCache();
        DynamicObject[] dynamicObjectArray = objs;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            DynamicObject obj = dynamicObjectArray[var6_8];
            evtClassPkSet.add(obj.get("eventclass.masterid"));
            ++var6_8;
        }
        HashMap refFieldMap = new HashMap();
        for (Object e : evtClassPkSet) {
            String cacheKey = CacheKey.getKey((Object)"pre-eventclass-cache", e);
            ArrayList<String> preEvtFieldList = (ArrayList<String>)localCache.get(cacheKey);
            if (preEvtFieldList == null) {
                DynamicObjectCollection objColl = QueryServiceHelper.query((String)"ai_eventclass", (String)"preevent.preevtfield", (QFilter[])new QFilter("preevent.preeventclass.masterid", "=", e).toArray());
                preEvtFieldList = new ArrayList<String>();
                for (DynamicObject preEvt : objColl) {
                    preEvtFieldList.add(preEvt.getString("preevent.preevtfield"));
                }
                localCache.put(cacheKey, preEvtFieldList);
            }
            if (preEvtFieldList.isEmpty()) continue;
            refFieldMap.put(e, preEvtFieldList);
        }
        if (!refFieldMap.isEmpty()) {
            ArrayList<DynamicObject> evtIndexList = new ArrayList<DynamicObject>();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"ai_event_index");
            Map<Long, SimpleDynamicObject> sdoMap = this.getSdoMap();
            for (DynamicObject evt : objs) {
                long id;
                SimpleDynamicObject sdo;
                Long evtClassPk = evt.getLong("eventclass.masterid");
                List fields = (List)refFieldMap.get(evtClassPk);
                Map eventdata = (Map)SerializationUtils.fromJsonString((String)evt.getString("data_tag"), Map.class);
                if (CollectionUtils.isEmpty((Collection)fields) || null != (sdo = sdoMap.get(id = evt.getLong("id")))) continue;
                for (String field : fields) {
                    Object val = this.getFieldVal(eventdata, field);
                    if (val == null) continue;
                    DynamicObject index = new DynamicObject((DynamicObjectType)mainEntityType);
                    index.set("eventclassid", (Object)evtClassPk);
                    index.set("eventid", evt.getPkValue());
                    index.set("fieldname", (Object)field);
                    index.set("fieldvalue", val);
                    evtIndexList.add(index);
                }
            }
            BusinessDataWriter.save((IDataEntityType)mainEntityType, (Object[])evtIndexList.toArray(new DynamicObject[0]));
        }
    }

    private Map<Long, SimpleDynamicObject> getSdoMap() {
        HashMap<Long, SimpleDynamicObject> sdoMap = new HashMap<Long, SimpleDynamicObject>(8);
        Map allSuccessExtDataSdoMap = ExtDataSaveCtxHelper.getExtDataSaveCtx().getAllSuccessExtDataSdoMap();
        for (List list : allSuccessExtDataSdoMap.values()) {
            for (SimpleDynamicObject sdo : list) {
                sdoMap.put(sdo.getLong("id"), sdo);
            }
        }
        return sdoMap;
    }

    private List<Long> getOnTimeIds(AfterOperationArgs e) {
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (DynamicObject dyo : e.getDataEntities()) {
            Set idSet = map.computeIfAbsent(dyo.getString("eventclass.number"), fun -> new HashSet());
            if (!EventPagingEnum.COMMIT.getStatus().equals(dyo.getString("paging")) && !EventPagingEnum.NOT_PAGE.getStatus().equals(dyo.getString("paging"))) continue;
            idSet.add(dyo.getLong("id"));
        }
        ArrayList<Long> idSet = new ArrayList<Long>();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_opbizruleset", (String)"objecttype", (QFilter[])new QFilter("objecttype", "in", map.keySet()).toArray());
        for (DynamicObject dyo : query) {
            if (!map.containsKey(dyo.getString("objecttype"))) continue;
            idSet.addAll((Collection)map.get(dyo.getString("objecttype")));
        }
        return idSet;
    }

    private Object getFieldVal(Map<String, Object> data, String fs) {
        Object obj = data.get(fs);
        if (obj != null) {
            return obj;
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            List entries = (List)entry.getValue();
            if (!entries.isEmpty()) {
                return ((Map)entries.get(0)).get(fs);
            }
            return null;
        }
        return null;
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        String lockId;
        if (this.getOption().containsVariable("lockId") && StringUtils.isNotBlank((CharSequence)(lockId = this.operateOption.getVariableValue("lockId")))) {
            Set lockIDs = (Set)SerializationUtils.fromJsonString((String)lockId, HashSet.class);
            MutexRequireUtil.batchReleaseForScheme((Collection)lockIDs, (String)"ai_event");
        }
        ExtDataSaveOp.releaseLockedIds();
    }
}

