/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.datamapping.validate;

import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class BaseDataMappingCashflowSaveValidator
extends AbstractValidator {
    private static final String GL_CASHFLOWITEM = "gl_cashflowitem";
    private static final String CAS_FUNDFLOWITEM = "cas_fundflowitem";
    private static final String IMPORTTYPE = "importtype";

    public void validate() {
        block0: for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObject dynObject = entity.getDataEntity();
            String sourceNumber = dynObject.getString("factorvalue_base");
            String destNumber = dynObject.getDynamicObject("destbasedata").getString("number");
            boolean byCustom = dynObject.getBoolean("bycustom");
            boolean needValidate = false;
            if (byCustom && GL_CASHFLOWITEM.equalsIgnoreCase(destNumber) && null != sourceNumber && sourceNumber.contains(CAS_FUNDFLOWITEM)) {
                needValidate = true;
            }
            DynamicObjectCollection entrys = dynObject.getDynamicObjectCollection("entryentity");
            boolean isExcelImport = Objects.nonNull(this.getOption().getVariables().get(IMPORTTYPE));
            HashSet<String> soucesSet = new HashSet<String>(entrys.size());
            int rowIndexTip = isExcelImport ? 5 : 1;
            for (DynamicObject entry : entrys) {
                String cashflowItemType;
                DynamicObject destdatamapping = entry.getDynamicObject("destdatamapping");
                if (null == destdatamapping) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c\u201c%s\u201d\u884c\uff0c\u76ee\u6807\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BaseDataMappingCashflowSaveValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]), rowIndexTip), ErrorLevel.Error);
                    continue block0;
                }
                StringBuilder builder = new StringBuilder();
                if (needValidate && "3".equals(cashflowItemType = destdatamapping.getString("type"))) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c\u201c%s\u201d\u884c\uff0c\u5728\u6620\u5c04\u89c4\u5219\u4e2d\u4e0d\u80fd\u5b58\u5728\u8d44\u91d1\u7528\u9014\u6620\u5c04\u5230\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7684\u8865\u5145\u8d44\u6599\u3002", (String)"BaseDataMappingCashflowSaveValidator_2", (String)"fi-ai-opplugin", (Object[])new Object[0]), rowIndexTip), ErrorLevel.Error);
                    continue block0;
                }
                for (int i = 0; i < 10; ++i) {
                    DynamicObject asstDyo;
                    DynamicObject baseDyo = entry.getDynamicObject("srcdatamapping" + i);
                    if (baseDyo != null && null != baseDyo.getPkValue() && !"0".equals(String.valueOf(baseDyo.getPkValue()))) {
                        builder.append(baseDyo.getPkValue());
                        builder.append('+');
                    }
                    if ((asstDyo = entry.getDynamicObject("assistsouce" + i)) == null || null == asstDyo.getPkValue() || "0".equals(String.valueOf(asstDyo.getPkValue()))) continue;
                    builder.append(asstDyo.getPkValue());
                    builder.append('+');
                }
                if (builder.length() <= 0) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c\u201c%s\u201d\u884c\uff0c\u6e90\u6570\u636e\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"BaseDataMappingCashflowSaveValidator_3", (String)"fi-ai-opplugin", (Object[])new Object[0]), rowIndexTip), ErrorLevel.Error);
                    continue block0;
                }
                String souceStr = builder.toString();
                if (soucesSet.contains(souceStr)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c\u201c%s\u201d\u884c\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4e00\u7ec4\u6e90\u6570\u636e\u3002", (String)"BaseDataMappingCashflowSaveValidator_4", (String)"fi-ai-opplugin", (Object[])new Object[0]), rowIndexTip), ErrorLevel.Error);
                    continue block0;
                }
                soucesSet.add(souceStr);
                ++rowIndexTip;
            }
        }
    }
}

