/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.validate;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.ai.event.validator.AiEventValidatorUtil;
import kd.fi.ai.event.validator.ValidatorResultData;
import kd.fi.v2.fah.validate.ExtDataBeinvalidValidator;
import kd.fi.v2.fah.validate.ExtDataValidateUtils;

public class AiEventBeinvalidValidator
extends AbstractValidator {
    public void validate() {
        Tuple<Map<String, List<ExtendedDataEntity>>, ExtendedDataEntity[]> newAndOldData = ExtDataValidateUtils.checkModel(this.getDataEntities());
        if (null != newAndOldData.item1 && ((Map)newAndOldData.item1).size() > 0) {
            ExtDataBeinvalidValidator beinvalidValidator = new ExtDataBeinvalidValidator((Map)newAndOldData.item1, this::addErrorMessageExt);
            beinvalidValidator.validate();
        }
        if (null == newAndOldData.item2 || ((ExtendedDataEntity[])newAndOldData.item2).length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : (ExtendedDataEntity[])newAndOldData.item2) {
            HashSet<Long> ids = new HashSet<Long>();
            Long pk = entity.getDataEntity().getLong("id");
            String status = entity.getDataEntity().getString("status");
            ids.add(pk);
            if ("2".equals(status)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03\u7684\u5916\u90e8\u6570\u636e\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"AiEventBeinvalidValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if ("3".equals(status)) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6821\u9a8c\u5931\u8d25\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"AiEventBeinvalidValidator_2", (String)"fi-ai-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String paging = entity.getDataEntity().getString("paging");
            if (EventPagingEnum.NO_COMMIT.getStatus().equals(paging.trim())) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u5206\u5f55\u6570\u636e\u5bfc\u5165\u672a\u5b8c\u6210\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"AiEventBeinvalidValidator_3", (String)"fi-ai-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            ValidatorResultData retData = AiEventValidatorUtil.checkPreEvent(ids);
            if (retData.isStatus()) continue;
            this.addMessage(entity, retData.getMessage(), ErrorLevel.Error);
        }
    }

    private void addErrorMessageExt(ExtendedDataEntity dataEntity, String msg) {
        this.addMessage(dataEntity, msg, ErrorLevel.Error);
    }
}

