/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.validate;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.ai.event.AiEventData;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.validate.AiEventClassMustInputValidator;
import kd.fi.v2.fah.validate.ExtDataSaveValidator;
import kd.fi.v2.fah.validate.ExtDataValidateUtils;

public class AiEventSaveValidator
extends AbstractValidator {
    private static final String ALL_MUSTINP = "allmustinp";
    private Map<Long, Map<String, String>> eventClassIdAndnumberAndName = new HashMap<Long, Map<String, String>>(16);

    /*
     * WARNING - void declaration
     */
    public void validate() {
        String number;
        Long pk;
        Tuple<Map<String, Map<Long, List<ExtendedDataEntity>>>, ExtendedDataEntity[]> newAndOldData = ExtDataValidateUtils.checkModelOrg(this.getDataEntities());
        if (null != newAndOldData.item1 && ((Map)newAndOldData.item1).size() > 0) {
            ExtDataSaveValidator extDataSaveValidator = new ExtDataSaveValidator((Map)newAndOldData.item1, (arg_0, arg_1) -> ((AiEventSaveValidator)this).addErrorMessage(arg_0, arg_1));
            extDataSaveValidator.validate();
        }
        if (null == newAndOldData.item2 || ((ExtendedDataEntity[])newAndOldData.item2).length == 0) {
            return;
        }
        ExtendedDataEntity[] entities = (ExtendedDataEntity[])newAndOldData.item2;
        ArrayList<Long> ids = new ArrayList<Long>(entities.length);
        HashMap<Object, Set<String>> evtMap = new HashMap<Object, Set<String>>();
        HashSet<Long> eventClassIds = new HashSet<Long>(100);
        Set lockIDs = new HashSet(16);
        HashSet<String> keys = new HashSet<String>(16);
        for (ExtendedDataEntity entity : entities) {
            pk = entity.getDataEntity().getLong("eventclass_id");
            String number2 = entity.getDataEntity().getString("number");
            eventClassIds.add(pk);
            ids.add(pk);
            if (evtMap.containsKey(pk)) {
                ((Set)evtMap.get(pk)).add(number2);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add(number2);
                evtMap.put(pk, set);
            }
            String key = pk + number2;
            keys.add(key);
        }
        try {
            lockIDs = MutexRequireUtil.eventRequireMutex((String)"ai_event", keys);
            this.getOption().setVariableValue("lockId", SerializationUtils.toJsonString(lockIDs));
            if (lockIDs.size() < keys.size()) {
                for (ExtendedDataEntity entity : entities) {
                    pk = entity.getDataEntity().getLong("eventclass_id");
                    String number2 = entity.getDataEntity().getString("number");
                    if (lockIDs.contains(pk + number2)) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6709\u5916\u90e8\u6570\u636e\u7c7b\u578b\u548c\u7f16\u53f7\u76f8\u540c\u7684\u6570\u636e\u6b63\u5728\u5bfc\u5165\u6216\u8005\u6b63\u5728\u751f\u6210\u51ed\u8bc1\u3002", (String)"AiEventSaveValidator_11", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            MutexRequireUtil.batchReleaseForScheme(lockIDs, (String)"ai_event");
        }
        this.eventClassIdAndnumberAndName = this.getEventNumberAndName(eventClassIds);
        Map<Object, Set<String>> hasVoucherEvts = this.getBuildVoucher(evtMap);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ai_eventclass"));
        Map<Long, Map<String, String>> allFieldMap = this.getFieldMap(dyns, ALL_MUSTINP);
        Map<String, Set<String>> entityNameAndNumber = this.getEntityNameAndNumber(dyns);
        Map<Long, Set<String>> assistIdAndNumber = this.getAssistIdAndNumber(dyns);
        Map<Long, Map<String, Map<String, String>>> classIdAndBasedataInfo = this.getClassIdAndBasedataInfo(dyns);
        Map<Long, Map<String, Map<String, Long>>> classIdAndAssassdataInfo = this.getClassIdAndAssassdataInfo(dyns);
        Map<Long, Map<String, Map<String, String>>> numberAndFieldtypes = this.getNumberAndFieldtypes(dyns);
        HashMap eventDataMap = new HashMap();
        HashSet<String> lockIds = new HashSet<String>();
        HashSet<String> eventClassIdAndNumbers = new HashSet<String>();
        for (ExtendedDataEntity entity : entities) {
            void var33_43;
            Object fieldValue;
            Object entry32;
            Object formatMessage;
            Set<String> hasVchEvtIdSet;
            Long eventClassId = (Long)entity.getValue("eventclass_id");
            number = entity.getDataEntity().getString("number");
            String eventClassIdAndNumber = eventClassId + number;
            if (eventClassIdAndNumbers.contains(eventClassIdAndNumber)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d", (String)"AiEventSaveValidator_6", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                lockIds.add(entity.getValue("eventclass_id") + number);
                continue;
            }
            eventClassIdAndNumbers.add(eventClassIdAndNumber);
            Map<String, String> numberAndName = this.eventClassIdAndnumberAndName.get(eventClassId);
            Long orgId = (Long)entity.getValue("org_id");
            Map eventdata = (Map)SerializationUtils.fromJsonString((String)((String)entity.getValue("data_tag")), Map.class);
            if (eventdata == null || eventdata.isEmpty()) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6ca1\u6709\u5f55\u5165\u6570\u636e", (String)"AiEventSaveValidator_0", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                lockIds.add(entity.getValue("eventclass_id") + number);
                continue;
            }
            if (hasVoucherEvts != null && !hasVoucherEvts.isEmpty() && (hasVchEvtIdSet = hasVoucherEvts.get(eventClassId)).contains(entity.getDataEntity().getString("number"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u5df2\u751f\u6210\u51ed\u8bc1", (String)"AiEventSaveValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]));
                lockIds.add(entity.getValue("eventclass_id") + number);
                continue;
            }
            Map<String, Map<String, String>> fieldtypes = numberAndFieldtypes.get(eventClassId);
            for (Map.Entry<String, Map<String, String>> entry : fieldtypes.entrySet()) {
                Iterator fieldName;
                String entityName = entry.getKey();
                String string = "head" + ((DynamicObject)entity.getValue("eventclass")).getString("number");
                if (string.equals(entityName)) {
                    for (Map.Entry<String, String> fieldInfo : entry.getValue().entrySet()) {
                        String formatMessage2;
                        fieldName = fieldInfo.getKey();
                        String fieldValue2 = fieldInfo.getValue();
                        if (!eventdata.containsKey(fieldName) || !StringUtils.isNotEmpty((CharSequence)(eventdata.get(fieldName) + "")) || !StringUtils.isNotEmpty((CharSequence)(formatMessage2 = this.getFormatMessage(eventdata, (String)((Object)fieldName), fieldValue2, numberAndName)))) continue;
                        this.addErrorMessage(entity, formatMessage2);
                        lockIds.add(entity.getValue("eventclass_id") + number);
                    }
                    continue;
                }
                for (Map.Entry<String, String> fieldInfo : entry.getValue().entrySet()) {
                    fieldName = fieldInfo.getKey();
                    String fieldValue2 = fieldInfo.getValue();
                    if (!eventdata.containsKey(entityName)) continue;
                    List list = (List)eventdata.get(entityName);
                    for (Map map : list) {
                        if (!map.containsKey(fieldName) || !StringUtils.isNotEmpty((CharSequence)(map.get(fieldName) + "")) || !StringUtils.isNotEmpty((CharSequence)(formatMessage = this.getFormatMessage(map, (String)((Object)fieldName), fieldValue2, numberAndName)))) continue;
                        this.addErrorMessage(entity, (String)formatMessage);
                        lockIds.add(entity.getValue("eventclass_id") + number);
                    }
                }
            }
            Map<String, Map<String, String>> baseDataInfo = classIdAndBasedataInfo.get(eventClassId);
            for (Object entry32 : baseDataInfo.entrySet()) {
                String fieldName;
                HashMap<String, HashMap<String, Long>> map1;
                String string = entry32.getKey();
                String hedaname = "head" + ((DynamicObject)entity.getValue("eventclass")).getString("number");
                if (hedaname.equals(string)) {
                    HashMap<String, HashMap<String, Long>> mapAllHead = new HashMap<String, HashMap<String, Long>>();
                    for (Map.Entry fieldInfo : ((Map)entry32.getValue()).entrySet()) {
                        String fieldValue3 = (String)fieldInfo.getValue();
                        if (mapAllHead.containsKey(fieldValue3) || (map1 = this.getBaseDataIds(fieldValue3, orgId)).isEmpty()) continue;
                        mapAllHead.put(fieldValue3, map1.get(fieldValue3));
                    }
                    for (Map.Entry fieldInfo : ((Map)entry32.getValue()).entrySet()) {
                        fieldName = (String)fieldInfo.getKey();
                        fieldValue = (String)fieldInfo.getValue();
                        if (eventdata.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)(eventdata.get(fieldName) + ""))) {
                            if (!entityNameAndNumber.get(fieldValue).contains(eventdata.get(fieldName))) {
                                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_7", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), eventdata.get(fieldName)));
                                eventdata.put(fieldName, 0L);
                                lockIds.add(entity.getValue("eventclass_id") + number);
                                continue;
                            }
                            if (!mapAllHead.isEmpty() && mapAllHead.containsKey(fieldValue) && ((HashMap)mapAllHead.get(fieldValue)).containsKey(eventdata.get(fieldName))) {
                                eventdata.put(fieldName, (Long)((HashMap)mapAllHead.get(fieldValue)).get(eventdata.get(fieldName)));
                                continue;
                            }
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_7", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), eventdata.get(fieldName)));
                            eventdata.put(fieldName, 0L);
                            lockIds.add(entity.getValue("eventclass_id") + number);
                            continue;
                        }
                        eventdata.put(fieldName, 0L);
                    }
                    continue;
                }
                HashMap<String, HashMap<String, Long>> mapAllBody = new HashMap<String, HashMap<String, Long>>();
                for (Map.Entry fieldInfo : ((Map)entry32.getValue()).entrySet()) {
                    String fieldValue3 = (String)fieldInfo.getValue();
                    if (mapAllBody.containsKey(fieldValue3) || (map1 = this.getBaseDataIds(fieldValue3, orgId)).isEmpty()) continue;
                    mapAllBody.put(fieldValue3, map1.get(fieldValue3));
                }
                for (Map.Entry fieldInfo : ((Map)entry32.getValue()).entrySet()) {
                    fieldName = (String)fieldInfo.getKey();
                    fieldValue = (String)fieldInfo.getValue();
                    if (!eventdata.containsKey(string)) continue;
                    List list = (List)eventdata.get(string);
                    formatMessage = list.iterator();
                    while (formatMessage.hasNext()) {
                        Map map = (Map)formatMessage.next();
                        if (map.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)(map.get(fieldName) + ""))) {
                            if (!entityNameAndNumber.get(fieldValue).contains(map.get(fieldName))) {
                                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_7", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), map.get(fieldName)));
                                map.put(fieldName, 0L);
                                lockIds.add(entity.getValue("eventclass_id") + number);
                                continue;
                            }
                            if (!mapAllBody.isEmpty() && mapAllBody.containsKey(fieldValue) && ((HashMap)mapAllBody.get(fieldValue)).containsKey(map.get(fieldName))) {
                                map.put(fieldName, (Long)((HashMap)mapAllBody.get(fieldValue)).get(map.get(fieldName)));
                                continue;
                            }
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_7", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), eventdata.get(fieldName)));
                            map.put(fieldName, 0L);
                            lockIds.add(entity.getValue("eventclass_id") + number);
                            continue;
                        }
                        map.put(fieldName, 0L);
                    }
                }
            }
            Map<String, Map<String, Long>> map = classIdAndAssassdataInfo.get(eventClassId);
            entry32 = map.entrySet().iterator();
            while (entry32.hasNext()) {
                String fieldName;
                HashMap<Long, HashMap<String, Long>> map1;
                Map.Entry entry = (Map.Entry)entry32.next();
                String entityName = (String)entry.getKey();
                String hedaname = "head" + ((DynamicObject)entity.getValue("eventclass")).getString("number");
                if (hedaname.equals(entityName)) {
                    HashMap<Object, HashMap<String, Long>> mapAllHead = new HashMap<Object, HashMap<String, Long>>();
                    for (Map.Entry fieldInfo : ((Map)entry.getValue()).entrySet()) {
                        fieldValue = (Long)fieldInfo.getValue();
                        if (mapAllHead.containsKey(fieldValue) || (map1 = this.getAssistantDataIds((Long)fieldValue)).isEmpty()) continue;
                        mapAllHead.put(fieldValue, map1.get(fieldValue));
                    }
                    for (Map.Entry fieldInfo : ((Map)entry.getValue()).entrySet()) {
                        fieldName = (String)fieldInfo.getKey();
                        Long fieldValue4 = (Long)fieldInfo.getValue();
                        if (eventdata.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)(eventdata.get(fieldName) + ""))) {
                            if (!assistIdAndNumber.get(fieldValue4).contains(eventdata.get(fieldName))) {
                                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_8", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), eventdata.get(fieldName)));
                                eventdata.put(fieldName, 0L);
                                lockIds.add(entity.getValue("eventclass_id") + number);
                                continue;
                            }
                            if (!mapAllHead.isEmpty() && mapAllHead.containsKey(fieldValue4) && ((HashMap)mapAllHead.get(fieldValue4)).containsKey(eventdata.get(fieldName))) {
                                eventdata.put(fieldName, (Long)((HashMap)mapAllHead.get(fieldValue4)).get(eventdata.get(fieldName)));
                                continue;
                            }
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_8", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), eventdata.get(fieldName)));
                            eventdata.put(fieldName, 0L);
                            lockIds.add(entity.getValue("eventclass_id") + number);
                            continue;
                        }
                        eventdata.put(fieldName, 0L);
                    }
                    continue;
                }
                HashMap<Object, HashMap<String, Long>> mapAllBody = new HashMap<Object, HashMap<String, Long>>();
                for (Map.Entry fieldInfo : ((Map)entry.getValue()).entrySet()) {
                    fieldValue = (Long)fieldInfo.getValue();
                    if (mapAllBody.containsKey(fieldValue) || (map1 = this.getAssistantDataIds((Long)fieldValue)).isEmpty()) continue;
                    mapAllBody.put(fieldValue, map1.get(fieldValue));
                }
                for (Map.Entry fieldInfo : ((Map)entry.getValue()).entrySet()) {
                    fieldName = (String)fieldInfo.getKey();
                    Long fieldValue4 = (Long)fieldInfo.getValue();
                    if (!eventdata.containsKey(entityName)) continue;
                    List list = (List)eventdata.get(entityName);
                    for (Map map2 : list) {
                        if (map2.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)(map2.get(fieldName) + ""))) {
                            if (!assistIdAndNumber.get(fieldValue4).contains(map2.get(fieldName))) {
                                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_8", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), map2.get(fieldName)));
                                map2.put(fieldName, 0L);
                                lockIds.add(entity.getValue("eventclass_id") + number);
                                continue;
                            }
                            if (!mapAllBody.isEmpty() && mapAllBody.containsKey(fieldValue4) && ((HashMap)mapAllBody.get(fieldValue4)).containsKey(map2.get(fieldName))) {
                                map2.put(fieldName, (Long)((HashMap)mapAllBody.get(fieldValue4)).get(map2.get(fieldName)));
                                continue;
                            }
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u7f16\u7801\u201c%3$s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"AiEventSaveValidator_8", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldName, numberAndName.get(fieldName), eventdata.get(fieldName)));
                            map2.put(fieldName, 0L);
                            lockIds.add(entity.getValue("eventclass_id") + number);
                            continue;
                        }
                        map2.put(fieldName, 0L);
                    }
                }
            }
            entity.setValue("data_tag", (Object)SerializationUtils.toJsonString((Object)eventdata));
            Object eventClassNumber = entity.getValue("eventclass_id");
            Object var33_50 = null;
            List list = (List)eventDataMap.get(eventClassNumber);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                eventDataMap.put(eventClassNumber, arrayList);
            }
            DynamicObject dy = entity.getDataEntity();
            AiEventData data = new AiEventData();
            data.setNumber(dy.getString("number"));
            data.setOrgId(dy.getLong("org_id"));
            data.setData_tag(dy.getString("data_tag"));
            var33_43.add(data);
        }
        HashMap<String, String> allInfo = new HashMap<String, String>();
        for (Map.Entry dataEntry : eventDataMap.entrySet()) {
            Long eventClassPK = (Long)dataEntry.getKey();
            if (allFieldMap.get(eventClassPK) == null) continue;
            try {
                AiEventClassMustInputValidator validator = new AiEventClassMustInputValidator(allFieldMap.get(eventClassPK), eventClassPK, (List)dataEntry.getValue(), this.eventClassIdAndnumberAndName.get(eventClassPK));
                Map<String, String> msg = validator.validateMustInput();
                for (Map.Entry<String, String> entry : msg.entrySet()) {
                    allInfo.put(entry.getKey(), entry.getValue());
                }
            }
            catch (Exception e) {
                lockIds.add(eventClassPK + ((AiEventData)((List)dataEntry.getValue()).get(0)).getNumber());
            }
        }
        for (ExtendedDataEntity entity : entities) {
            number = (String)entity.getValue("number");
            if (!allInfo.containsKey(number)) continue;
            this.addErrorMessage(entity, (String)allInfo.get(number));
            lockIds.add(entity.getValue("eventclass_id") + number);
        }
        if (!lockIds.isEmpty()) {
            MutexRequireUtil.batchReleaseForScheme(lockIds, (String)"ai_event");
        }
    }

    private Map<Long, Map<String, String>> getEventNumberAndName(Set<Long> eventClassIds) {
        Map dyns = BusinessDataServiceHelper.loadFromCache((Object[])eventClassIds.toArray(), (String)"ai_eventclass");
        for (DynamicObject dyn : dyns.values()) {
            Long id = dyn.getLong("id");
            HashMap<String, String> map = new HashMap<String, String>(16);
            DynamicObjectCollection fieldentryentity = dyn.getDynamicObjectCollection("fieldentryentity");
            for (DynamicObject entryentity : fieldentryentity) {
                if ("entry".equals(entryentity.getString("fieldtype"))) {
                    DynamicObjectCollection entrys = entryentity.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entrys) {
                        map.put(entry.getString("entryfieldname"), entry.getString("entryfieldalias"));
                    }
                    continue;
                }
                map.put(entryentity.getString("fieldname"), entryentity.getString("fieldalias"));
            }
            this.eventClassIdAndnumberAndName.put(id, map);
        }
        return this.eventClassIdAndnumberAndName;
    }

    private HashMap<Long, HashMap<String, Long>> getAssistantDataIds(Long fieldValue) {
        HashMap<Long, HashMap<String, Long>> outer = new HashMap<Long, HashMap<String, Long>>();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        QFilter groupFilter = new QFilter("group.id", "=", (Object)fieldValue);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"number,id", (QFilter[])new QFilter[]{groupFilter, statusFilter});
        for (DynamicObject object : collections) {
            inner.put(object.getString("number"), object.getLong("id"));
            outer.put(fieldValue, inner);
        }
        return outer;
    }

    private HashMap<String, HashMap<String, Long>> getBaseDataIds(String entityName, Long orgId) {
        HashMap<String, HashMap<String, Long>> outer = new HashMap<String, HashMap<String, Long>>();
        HashMap<String, Long> inner = new HashMap<String, Long>();
        DynamicObjectCollection queryBaseData = BaseDataServiceHelper.queryBaseData((String)entityName, (Long)orgId, null, (String)"id,number");
        for (DynamicObject object : queryBaseData) {
            inner.put(object.getString("number"), object.getLong("id"));
            outer.put(entityName, inner);
        }
        return outer;
    }

    private String getFormatMessage(Map<String, Object> eventdata, String fieldValue, String format, Map<String, String> numberAndName) {
        Object obj = eventdata.get(fieldValue);
        String message = "";
        switch (format) {
            case "txt": 
            case "basedata": 
            case "event": {
                if (obj instanceof String) break;
                message = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AiEventSaveValidator_10", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldValue, numberAndName.get(fieldValue));
                break;
            }
            case "number": {
                if (obj instanceof BigDecimal || obj instanceof Integer || obj instanceof Double || obj instanceof Long) break;
                try {
                    if (StringUtils.isEmpty((CharSequence)obj.toString())) break;
                    Double.parseDouble(obj.toString());
                }
                catch (Exception e) {
                    message = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AiEventSaveValidator_10", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldValue, numberAndName.get(fieldValue));
                }
                break;
            }
            case "date": {
                String dateStr = obj + "";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    sdf.parse(dateStr);
                    break;
                }
                catch (ParseException e) {
                    message = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AiEventSaveValidator_10", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldValue, numberAndName.get(fieldValue));
                    return message;
                }
            }
            case "boolean": {
                if (!(obj instanceof Boolean || "false".equals(obj) || "true".equals(obj))) {
                    message = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u548c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AiEventSaveValidator_10", (String)"fi-ai-opplugin", (Object[])new Object[0]), fieldValue, numberAndName.get(fieldValue));
                }
                String value = Boolean.parseBoolean(obj + "") ? "1" : "0";
                eventdata.put(fieldValue, value);
                break;
            }
        }
        return message;
    }

    private Map<Long, Map<String, Map<String, String>>> getNumberAndFieldtypes(DynamicObject[] dyns) {
        HashMap<Long, Map<String, Map<String, String>>> numberAndFieldtypes = new HashMap<Long, Map<String, Map<String, String>>>(dyns.length);
        for (DynamicObject dyn : dyns) {
            HashMap map = new HashMap();
            DynamicObjectCollection fieldentryentity = dyn.getDynamicObjectCollection("fieldentryentity");
            String headname = "head" + dyn.getString("number");
            for (DynamicObject fieldentry : fieldentryentity) {
                String fieldtype = fieldentry.getString("fieldtype");
                if ("entry".equals(fieldtype)) {
                    String entityName = fieldentry.getString("fieldname");
                    DynamicObjectCollection entryentity = fieldentry.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryentity) {
                        if (map.containsKey(entityName)) {
                            ((Map)map.get(entityName)).put(entry.getString("entryfieldname"), entry.getString("entryfieldtype"));
                            continue;
                        }
                        HashMap<String, String> numberAndType = new HashMap<String, String>();
                        numberAndType.put(entry.getString("entryfieldname"), entry.getString("entryfieldtype"));
                        map.put(entityName, numberAndType);
                    }
                    continue;
                }
                if (map.containsKey(headname)) {
                    ((Map)map.get(headname)).put(fieldentry.getString("fieldname"), fieldentry.getString("fieldtype"));
                    continue;
                }
                HashMap<String, String> numberAndType = new HashMap<String, String>();
                numberAndType.put(fieldentry.getString("fieldname"), fieldentry.getString("fieldtype"));
                map.put(headname, numberAndType);
            }
            numberAndFieldtypes.put(dyn.getLong("id"), map);
        }
        return numberAndFieldtypes;
    }

    private Map<Long, Map<String, Map<String, Long>>> getClassIdAndAssassdataInfo(DynamicObject[] dyns) {
        HashMap<Long, Map<String, Map<String, Long>>> classIdAndAssassdataInfo = new HashMap<Long, Map<String, Map<String, Long>>>(dyns.length);
        for (DynamicObject dyn : dyns) {
            HashMap assassInfo = new HashMap();
            String headname = "head" + dyn.getString("number");
            DynamicObjectCollection fieldentryentity = dyn.getDynamicObjectCollection("fieldentryentity");
            for (DynamicObject fieldentry : fieldentryentity) {
                String fieldtype = fieldentry.getString("fieldtype");
                if ("assistant".equals(fieldtype)) {
                    if (assassInfo.containsKey(headname)) {
                        ((Map)assassInfo.get(headname)).put(fieldentry.getString("fieldname"), fieldentry.getLong("assistant.id"));
                        continue;
                    }
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    map.put(fieldentry.getString("fieldname"), fieldentry.getLong("assistant.id"));
                    assassInfo.put(headname, map);
                    continue;
                }
                if (!"entry".equals(fieldtype)) continue;
                DynamicObjectCollection entryentity = fieldentry.getDynamicObjectCollection("entryentity");
                String entityName = fieldentry.getString("fieldname");
                for (DynamicObject entry : entryentity) {
                    fieldtype = entry.getString("entryfieldtype");
                    if (!"assistant".equals(fieldtype)) continue;
                    if (assassInfo.containsKey(entityName)) {
                        ((Map)assassInfo.get(entityName)).put(entry.getString("entryfieldname"), entry.getLong("entryassistant.id"));
                        continue;
                    }
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    map.put(entry.getString("entryfieldname"), entry.getLong("entryassistant.id"));
                    assassInfo.put(entityName, map);
                }
            }
            classIdAndAssassdataInfo.put(Long.valueOf(dyn.getPkValue() + ""), assassInfo);
        }
        return classIdAndAssassdataInfo;
    }

    private Map<Long, Map<String, Map<String, String>>> getClassIdAndBasedataInfo(DynamicObject[] dyns) {
        HashMap<Long, Map<String, Map<String, String>>> classIdAndBasedataInfo = new HashMap<Long, Map<String, Map<String, String>>>(dyns.length);
        for (DynamicObject dyn : dyns) {
            HashMap basedataInfo = new HashMap();
            String headname = "head" + dyn.getString("number");
            DynamicObjectCollection fieldentryentity = dyn.getDynamicObjectCollection("fieldentryentity");
            for (DynamicObject fieldentry : fieldentryentity) {
                String fieldtype = fieldentry.getString("fieldtype");
                if ("basedata".equals(fieldtype)) {
                    if (basedataInfo.containsKey(headname)) {
                        ((Map)basedataInfo.get(headname)).put(fieldentry.getString("fieldname"), fieldentry.getString("refobj.id"));
                        continue;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(fieldentry.getString("fieldname"), fieldentry.getString("refobj.id"));
                    basedataInfo.put(headname, map);
                    continue;
                }
                if (!"entry".equals(fieldtype)) continue;
                DynamicObjectCollection entryentity = fieldentry.getDynamicObjectCollection("entryentity");
                String entityName = fieldentry.getString("fieldname");
                for (DynamicObject entry : entryentity) {
                    fieldtype = entry.getString("entryfieldtype");
                    if (!"basedata".equals(fieldtype)) continue;
                    if (basedataInfo.containsKey(entityName)) {
                        ((Map)basedataInfo.get(entityName)).put(entry.getString("entryfieldname"), entry.getString("entryrefobj.id"));
                        continue;
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(entry.getString("entryfieldname"), entry.getString("entryrefobj.id"));
                    basedataInfo.put(entityName, map);
                }
            }
            classIdAndBasedataInfo.put(Long.valueOf(dyn.getPkValue() + ""), basedataInfo);
        }
        return classIdAndBasedataInfo;
    }

    private Map<Long, Set<String>> getAssistIdAndNumber(DynamicObject[] dyns) {
        HashMap<Long, Set<String>> assistIdAndNumber = new HashMap<Long, Set<String>>();
        HashSet<Long> assistIds = new HashSet<Long>();
        for (DynamicObject dyn : dyns) {
            DynamicObjectCollection fieldentryentity = dyn.getDynamicObjectCollection("fieldentryentity");
            for (DynamicObject fieldentry : fieldentryentity) {
                String fieldtype = fieldentry.getString("fieldtype");
                if ("assistant".equals(fieldtype)) {
                    assistIds.add(fieldentry.getLong("assistant.id"));
                    continue;
                }
                if (!"entry".equals(fieldtype)) continue;
                DynamicObjectCollection entryentity = fieldentry.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    fieldtype = entry.getString("entryfieldtype");
                    if (!"assistant".equals(fieldtype)) continue;
                    assistIds.add(entry.getLong("entryassistant.id"));
                }
            }
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"group.id groupid,number", (QFilter[])new QFilter("group.id", "in", assistIds).toArray());
        if (collection.size() > 0) {
            for (DynamicObject collec : collection) {
                Long groupid = collec.getLong("groupid");
                String number = collec.getString("number");
                if (assistIdAndNumber.containsKey(groupid)) {
                    ((Set)assistIdAndNumber.get(groupid)).add(number);
                    continue;
                }
                HashSet<String> numbers = new HashSet<String>(collection.size());
                numbers.add(number);
                assistIdAndNumber.put(groupid, numbers);
            }
        }
        return assistIdAndNumber;
    }

    private Map<String, Set<String>> getEntityNameAndNumber(DynamicObject[] dyns) {
        HashMap<String, Set<String>> entityNameAndNumber = new HashMap<String, Set<String>>();
        HashSet<String> entityNames = new HashSet<String>();
        for (DynamicObject dyn : dyns) {
            DynamicObjectCollection fieldentryentity = dyn.getDynamicObjectCollection("fieldentryentity");
            for (DynamicObject fieldentry : fieldentryentity) {
                String fieldtype = fieldentry.getString("fieldtype");
                if ("basedata".equals(fieldtype)) {
                    entityNames.add(fieldentry.getString("refobj.id"));
                    continue;
                }
                if (!"entry".equals(fieldtype)) continue;
                DynamicObjectCollection entryentity = fieldentry.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    fieldtype = entry.getString("entryfieldtype");
                    if (!"basedata".equals(fieldtype)) continue;
                    entityNames.add(entry.getString("entryrefobj.id"));
                }
            }
        }
        for (String entityName : entityNames) {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)"number", null);
            if (collection.size() <= 0) continue;
            HashSet<String> numbers = new HashSet<String>(collection.size());
            for (DynamicObject collec : collection) {
                numbers.add(collec.getString("number"));
            }
            entityNameAndNumber.put(entityName, numbers);
        }
        return entityNameAndNumber;
    }

    private Map<Object, Set<String>> getBuildVoucher(Map<Object, Set<String>> eventNumberMap) {
        HashMap<Object, Set<String>> evtMap = new HashMap<Object, Set<String>>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(eventNumberMap.size());
        HashMap<Object, String> idNumMap = new HashMap<Object, String>();
        for (Map.Entry<Object, Set<String>> entry : eventNumberMap.entrySet()) {
            qFilters.add(new QFilter("eventclass", "=", entry.getKey()));
            qFilters.add(new QFilter("number", "in", entry.getValue()));
            qFilters.add(new QFilter("status", "=", (Object)Character.valueOf('1')));
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"ai_event", (String)"id,number", (QFilter[])qFilters.toArray(new QFilter[0]));
            ArrayList<Object> idList = new ArrayList<Object>();
            for (DynamicObject dyn : dyns) {
                idList.add(dyn.get("id"));
                idNumMap.put(dyn.get("id"), dyn.getString("number"));
            }
            if (idList.isEmpty()) {
                return null;
            }
            qFilters.clear();
            qFilters.add(new QFilter("billtype.number", "=", (Object)"ai_event"));
            qFilters.add(new QFilter("sourcebillid", "in", idList));
            DynamicObjectCollection traColl = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])qFilters.toArray(new QFilter[0]));
            Set evtNumberSet = evtMap.computeIfAbsent(entry.getKey(), key -> new HashSet());
            for (DynamicObject tra : traColl) {
                evtNumberSet.add(idNumMap.get(tra.getLong("sourcebillid")));
            }
            qFilters.clear();
            idNumMap.clear();
        }
        return evtMap;
    }

    private Map<Long, Map<String, String>> getFieldMap(DynamicObject[] dyns, String type) {
        HashMap<Long, Map<String, String>> map = new HashMap<Long, Map<String, String>>(6);
        if (dyns != null && dyns.length > 0) {
            for (DynamicObject dyn : dyns) {
                Long eventClassId = (Long)dyn.getPkValue();
                MainEntityType eventClassType = AiEventMetaUtil.getEntityType((Object)eventClassId);
                DynamicObjectCollection fieldEntrys = dyn.getDynamicObjectCollection("fieldentryentity");
                for (DynamicObject fieldEntry : fieldEntrys) {
                    if (!"entry".equals(fieldEntry.getString("fieldtype")) && fieldEntry.getBoolean("ismustinput")) {
                        if (map.containsKey(eventClassId)) {
                            String desc = fieldEntry.getString("mustinputformuladesc_tag");
                            String expression = AiEventUtil.getFilterExpression((String)desc, (MainEntityType)eventClassType);
                            ((Map)map.get(eventClassId)).put(fieldEntry.getString("fieldname"), expression);
                            continue;
                        }
                        HashMap<String, String> set = new HashMap<String, String>();
                        map.put(eventClassId, set);
                        String desc = fieldEntry.getString("mustinputformuladesc_tag");
                        String expression = AiEventUtil.getFilterExpression((String)desc, (MainEntityType)eventClassType);
                        set.put(fieldEntry.getString("fieldname"), expression);
                        continue;
                    }
                    if (!"entry".equals(fieldEntry.getString("fieldtype")) || !fieldEntry.getBoolean("ismustinput") || !ALL_MUSTINP.equals(type)) continue;
                    DynamicObjectCollection entryfields = fieldEntry.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entryfield : entryfields) {
                        String expression;
                        String desc;
                        Map<String, String> entryMap;
                        if (!entryfield.getBoolean("entryismustinput")) continue;
                        String entryfieldname = entryfield.getString("entryfieldname");
                        if (map.containsKey(eventClassId)) {
                            entryMap = (Map)map.get(eventClassId);
                            desc = entryfield.getString("entrymustinputformuladesc_tag");
                            expression = AiEventUtil.getFilterExpression((String)desc, (MainEntityType)eventClassType);
                            entryMap.put(entryfieldname, expression);
                            continue;
                        }
                        entryMap = new HashMap();
                        desc = entryfield.getString("entrymustinputformuladesc_tag");
                        expression = AiEventUtil.getFilterExpression((String)desc, (MainEntityType)eventClassType);
                        entryMap.put(entryfieldname, expression);
                        map.put(eventClassId, entryMap);
                    }
                }
            }
        }
        return map;
    }
}

