/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.datamapping.opplugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.v2.fah.context.ExtDataSaveCtx;
import kd.fi.v2.fah.context.ExtDataSaveCtxHelper;
import kd.fi.v2.fah.dao.biz.ExtDataSaveHelper;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;

public class ExtDataSaveOp {
    private static final Log logger = LogFactory.getLog(ExtDataSaveOp.class);

    public static void saveSuccessExtData() {
        ExtDataSaveCtx extDataSaveCtx = ExtDataSaveCtxHelper.getExtDataSaveCtx();
        Map allSuccessExtDataSdoMap = extDataSaveCtx.getAllSuccessExtDataSdoMap();
        Map modelTables = extDataSaveCtx.getModelTables();
        ExtDataSaveHelper.checkRepeatDataAndUpdateToExpired((Map)allSuccessExtDataSdoMap, (Map)modelTables);
        for (List sdoList : allSuccessExtDataSdoMap.values()) {
            ExtDataSaveHelper.saveExtDataBatch((List)sdoList);
        }
    }

    public static void releaseLockedIds() {
        ExtDataSaveCtx extDataSaveCtx = ExtDataSaveCtxHelper.getExtDataSaveCtx();
        Set lockIds = extDataSaveCtx.getLockIds();
        if (CollectionUtils.isEmpty((Collection)lockIds)) {
            return;
        }
        MutexRequireUtil.batchReleaseForScheme((Collection)lockIds, (String)"ai_event");
        extDataSaveCtx.getLockIds().removeAll(lockIds);
    }

    public static void triggerBizEventForBuildVoucher() {
        Map allSuccessExtDataSdoMap = ExtDataSaveCtxHelper.getExtDataSaveCtx().getAllSuccessExtDataSdoMap();
        Map modelTables = ExtDataSaveCtxHelper.getExtDataSaveCtx().getModelTables();
        for (Map.Entry entry : allSuccessExtDataSdoMap.entrySet()) {
            String modelNum = (String)entry.getKey();
            List extDatas = (List)entry.getValue();
            Object[] ids = extDatas.stream().map(SimpleDynamicObject::getPkValue).toArray();
            String metaEntityNum = (String)modelTables.get(modelNum);
            OperationResult result = OperationServiceHelper.executeOperate((String)"savedata", (String)metaEntityNum, (Object[])ids);
            logger.info("trigger extdata do nothing op, for build voucher by biz event, metaEntityNum: {}, ids: {}, result: {}", new Object[]{metaEntityNum, ids, result.isSuccess()});
        }
    }
}

