/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.opplugin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.BaseDataDeleteValidator;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.v2.fah.util.EventUtil;

public class FahAcctRuleDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        AbstractValidator validator;
        List validators = e.getValidators();
        int index = 0;
        Iterator iterator = validators.iterator();
        while (iterator.hasNext() && !((validator = (AbstractValidator)iterator.next()) instanceof BaseDataDeleteValidator)) {
            ++index;
        }
        validators.remove(index);
        e.getValidators().add(new FahAcctRuleDeleteValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        HashSet acctRuleIds = new HashSet();
        Arrays.stream(e.getDataEntities()).forEach(v -> acctRuleIds.add(v.getLong("id")));
        DeleteServiceHelper.delete((String)"fah_evt_acctgroup", (QFilter[])new QFilter[]{new QFilter("acctrule", "in", acctRuleIds)});
        DeleteServiceHelper.delete((String)"fah_evt_acctpublicinfo", (QFilter[])new QFilter[]{new QFilter("acctrule", "in", acctRuleIds)});
        DeleteServiceHelper.delete((String)"fah_evt_acctline", (QFilter[])new QFilter[]{new QFilter("acctrule", "in", acctRuleIds)});
    }

    public static class FahAcctRuleDeleteValidator
    extends AbstractValidator {
        public void validate() {
            ExtendedDataEntity[] entities;
            for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
                if (!EventUtil.acctRuleIsQuote((Long)((Long)entity.getBillPkId()))) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u89c4\u5219\u88ab\u5b50\u5206\u7c7b\u8d26\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FahAcctRuleDeleteOp_1", (String)"fi-ai-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }
}

