/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validate;

import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.utils.StringUtils;

public class EventRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.validateNumber(entity);
        }
    }

    private void validateNumber(ExtendedDataEntity entity) {
        DynamicObjectCollection evtruleLines;
        Boolean needAcct;
        String number = (String)entity.getValue("number");
        if (number.length() > 30) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26\u3002", (String)"EventRuleSaveValidator_0", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
        if (!this.isNumberMatch(number)) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"EventRuleSaveValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
        Long masterid = (Long)entity.getValue("masterid");
        if (!this.isNumberUnique(number.toLowerCase(), masterid)) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u4e8b\u4ef6\u89c4\u5219\u3002", (String)"EventRuleSaveValidator_2", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
        if ((needAcct = (Boolean)entity.getValue("needacct")).booleanValue() && StringUtils.isEmpty((Object)entity.getValue("bookeddate"))) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EventRuleSaveValidator_3", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
        if ((evtruleLines = (DynamicObjectCollection)entity.getValue("evtrule_line")) == null || evtruleLines.isEmpty()) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u81f3\u5c11\u5f55\u5165\u4e00\u884c\u4e8b\u4ef6\u884c\u7c7b\u578b\u3002", (String)"EventRuleSaveValidator_4", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isNumberMatch(String number) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9_]+");
        return pattern.matcher(number).matches();
    }

    private boolean isNumberUnique(String number, Long masterid) {
        Object[] params;
        String sql = "select count(1) as counts from t_fah_evt_gen_rule where lower(fnumber) = ?";
        if (masterid != null && masterid != 0L) {
            sql = sql + "and fmasterid != ?";
            params = new Object[]{number, masterid};
        } else {
            params = new Object[]{number};
        }
        try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.v2.fah.validate.EventRuleSaveValidator.isNumberUnique", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])params);){
            int counts = 0;
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                counts = next.getInteger("counts");
            }
            boolean bl = counts == 0;
            return bl;
        }
    }
}

