/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.context.ExtDataSaveCtx;
import kd.fi.v2.fah.context.ExtDataSaveCtxHelper;
import kd.fi.v2.fah.dao.biz.ExtDataSaveHelper;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.validate.ExtDataValidateUtils;
import kd.fi.v2.fah.validator.MsgInfo;

public class ExtDataSaveValidator {
    private static Log logger = LogFactory.getLog(ExtDataSaveValidator.class);
    private Map<String, Map<Long, List<ExtendedDataEntity>>> modelOrgGroup;
    private BiConsumer<ExtendedDataEntity, String> addErrorMessageConsumer;
    private ExtDataSaveCtx extDataSaveCtx;

    public ExtDataSaveValidator(Map<String, Map<Long, List<ExtendedDataEntity>>> modelOrgGroup, BiConsumer<ExtendedDataEntity, String> addErrorMessageConsumer) {
        this.modelOrgGroup = modelOrgGroup;
        this.addErrorMessageConsumer = addErrorMessageConsumer;
        this.extDataSaveCtx = ExtDataSaveCtxHelper.createExtDataSaveCtx();
    }

    public void validate() {
        logger.info("ExtDataSaveValidator.validate start");
        Set lockIDs = null;
        try {
            lockIDs = this.aquireLocks();
            this.getBuildVoucher();
            List<Tuple<ExtendedDataEntity, String>> errorMessageList = ExtDataValidateUtils.validateAndRecaliBration(this.modelOrgGroup, false);
            this.addErrorMsgBack(errorMessageList);
            this.saveErrorData();
            lockIDs = this.extDataSaveCtx.getErrorLockIds();
        }
        catch (Throwable throwable) {
            if (CollectionUtils.isNotEmpty(lockIDs)) {
                MutexRequireUtil.batchReleaseForScheme(lockIDs, (String)"ai_event");
                this.extDataSaveCtx.getLockIds().removeAll(lockIDs);
            }
            throw throwable;
        }
        if (CollectionUtils.isNotEmpty((Collection)lockIDs)) {
            MutexRequireUtil.batchReleaseForScheme((Collection)lockIDs, (String)"ai_event");
            this.extDataSaveCtx.getLockIds().removeAll(lockIDs);
        }
    }

    private void saveErrorData() {
        try (TXHandle tx = TX.requiresNew();){
            List allFailedExtData = this.extDataSaveCtx.getAllFailedExtData();
            if (CollectionUtils.isEmpty((Collection)allFailedExtData)) {
                return;
            }
            try {
                ExtDataSaveHelper.updateRepeatEventData((DynamicObject[])((DynamicObject[])allFailedExtData.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new)));
                ExtDataSaveHelper.checkRepeatDataAndUpdateToExpired((Map)this.extDataSaveCtx.getAllFailedExtDataSdoMap(), (Map)this.extDataSaveCtx.getModelTables());
                ExtDataSaveHelper.saveFalseData((List)allFailedExtData);
                Map allFailedExtDataSdoMap = this.extDataSaveCtx.getAllFailedExtDataSdoMap();
                for (List sdoList : allFailedExtDataSdoMap.values()) {
                    ExtDataSaveHelper.saveExtDataBatch((List)sdoList);
                }
                List allErrorMsgInfo = this.extDataSaveCtx.getAllErrorMsgInfoNeedSave();
                ExtDataSaveHelper.saveErrorMsg((List)allErrorMsgInfo);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void addErrorMsgBack(List<Tuple<ExtendedDataEntity, String>> errorMessageList) {
        for (Tuple<ExtendedDataEntity, String> errorMessage : errorMessageList) {
            this.addErrorMessage((ExtendedDataEntity)errorMessage.item1, (String)errorMessage.item2);
        }
        List allErrorMsgInfo = this.extDataSaveCtx.getAllErrorMsgInfo();
        for (MsgInfo msgInfo : allErrorMsgInfo) {
            this.addErrorMessage(this.extDataSaveCtx.getExtDataEntity(msgInfo.getModelNum(), msgInfo.getOrgId(), msgInfo.getExtDataNum()), msgInfo.getMsg());
        }
    }

    private Set<Object> aquireLocks() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        HashSet<String> keys = new HashSet<String>(8);
        HashSet<Object> lockIDs = new HashSet(8);
        for (ExtendedDataEntity entity : entities) {
            Long modelMasterId = entity.getDataEntity().getDynamicObject("eventclass").getLong("masterid");
            String number = entity.getDataEntity().getString("number");
            String key = modelMasterId + number;
            keys.add(key);
        }
        lockIDs = MutexRequireUtil.eventRequireMutex((String)"ai_event", keys);
        this.extDataSaveCtx.setLockIds(lockIDs);
        return lockIDs;
    }

    public void addErrorMessage(ExtendedDataEntity entity, String content) {
        this.addErrorMessageConsumer.accept(entity, content);
    }

    private ExtendedDataEntity[] getDataEntities() {
        return (ExtendedDataEntity[])this.modelOrgGroup.values().stream().flatMap(e -> e.values().stream()).flatMap(Collection::stream).toArray(ExtendedDataEntity[]::new);
    }

    public void getBuildVoucher() {
        Map hasVoucherEvtsCache = this.extDataSaveCtx.getHasVoucherEvts();
        if (null != hasVoucherEvtsCache) {
            return;
        }
        ExtendedDataEntity[] entities = this.getDataEntities();
        HashMap<Object, Set<String>> evtMap = new HashMap<Object, Set<String>>();
        for (ExtendedDataEntity entity : entities) {
            Long modelMasterId = entity.getDataEntity().getDynamicObject("eventclass").getLong("masterid");
            String number = entity.getDataEntity().getString("number");
            evtMap.computeIfAbsent(modelMasterId, k -> new HashSet(8)).add(number);
        }
        Map<Object, Set<String>> hasVoucherEvts = this.getBuildVoucher(evtMap);
        this.extDataSaveCtx.setHasVoucher(hasVoucherEvts == null ? Collections.emptyMap() : hasVoucherEvts);
    }

    private Map<Object, Set<String>> getBuildVoucher(Map<Object, Set<String>> eventNumberMap) {
        HashMap<Object, Set<String>> evtMap = new HashMap<Object, Set<String>>(8);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(eventNumberMap.size());
        HashMap<Object, String> idNumMap = new HashMap<Object, String>(8);
        for (Map.Entry<Object, Set<String>> entry : eventNumberMap.entrySet()) {
            qFilters.add(new QFilter("eventclass.masterid", "=", entry.getKey()));
            qFilters.add(new QFilter("number", "in", entry.getValue()));
            qFilters.add(new QFilter("status", "=", (Object)Character.valueOf('1')));
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"ai_event", (String)"id,number,eventclass.number modelnum,eventclass.appversion appversion ", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (CollectionUtils.isEmpty((Collection)dyns)) continue;
            ArrayList<Object> idList = new ArrayList<Object>(dyns.size());
            String billType = null;
            for (DynamicObject dyn : dyns) {
                idList.add(dyn.get("id"));
                if (null == billType) {
                    billType = String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(dyn.getString("appversion")) ? DataModelDaoImpl.getMetaEntityNumber((String)dyn.getString("modelnum")) : "ai_event";
                }
                idNumMap.put(dyn.get("id"), dyn.getString("number"));
            }
            qFilters.clear();
            qFilters.add(new QFilter("billtype.number", "=", billType));
            qFilters.add(new QFilter("sourcebillid", "in", idList));
            DynamicObjectCollection traColl = QueryServiceHelper.query((String)"ai_daptracker", (String)"sourcebillid", (QFilter[])qFilters.toArray(new QFilter[0]));
            Set evtNumberSet = evtMap.computeIfAbsent(entry.getKey(), key -> new HashSet(8));
            for (DynamicObject tra : traColl) {
                evtNumberSet.add(idNumMap.get(tra.getLong("sourcebillid")));
            }
            qFilters.clear();
            idNumMap.clear();
        }
        return evtMap;
    }
}

