/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.ai.enums.EventPreStatusEnum;
import kd.fi.ai.event.AiEventData;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.event.dto.AiEventBlockDto;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.context.ExtDataSaveCtx;
import kd.fi.v2.fah.context.ExtDataSaveCtxHelper;
import kd.fi.v2.fah.dao.biz.ExtDataModelHelper;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.utils.ExtDataSdoHelper;
import kd.fi.v2.fah.utils.SdoUtil;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.validate.FieldRequiredValidatorHepler;

public class ExtDataValidateUtils {
    private static final Log logger = LogFactory.getLog(ExtDataValidateUtils.class);
    private static final String SAVE_DEFAULT = "savedefault";

    public static Tuple<Map<String, Map<Long, List<ExtendedDataEntity>>>, ExtendedDataEntity[]> checkModelOrg(ExtendedDataEntity[] dataEntities) {
        HashMap<String, Map> modelOrgGroup = new HashMap<String, Map>(8);
        ArrayList<ExtendedDataEntity> oldModelData = new ArrayList<ExtendedDataEntity>(8);
        if (null != dataEntities) {
            for (ExtendedDataEntity data : dataEntities) {
                String modelNum = data.getDataEntity().getDynamicObject("eventclass").getString("number");
                Long modelId = data.getDataEntity().getLong("eventclass_id");
                if (ExtDataModelHelper.checkNewModelFromCache((Long)modelId)) {
                    Map orgGroup = modelOrgGroup.computeIfAbsent(modelNum, k -> new HashMap(8));
                    orgGroup.computeIfAbsent(data.getDataEntity().getLong("org_id"), k -> new ArrayList(8)).add(data);
                    continue;
                }
                oldModelData.add(data);
            }
        }
        return Tuple.create(modelOrgGroup, (Object)oldModelData.toArray(new ExtendedDataEntity[0]));
    }

    public static Tuple<Map<String, List<ExtendedDataEntity>>, ExtendedDataEntity[]> checkModel(ExtendedDataEntity[] dataEntities) {
        HashMap<String, List> modelGroup = new HashMap<String, List>(8);
        ArrayList<ExtendedDataEntity> oldModelData = new ArrayList<ExtendedDataEntity>(8);
        if (null != dataEntities) {
            for (ExtendedDataEntity data : dataEntities) {
                String modelNum = data.getDataEntity().getDynamicObject("eventclass").getString("number");
                Long modelId = data.getDataEntity().getLong("eventclass_id");
                if (ExtDataModelHelper.checkNewModelFromCache((Long)modelId)) {
                    modelGroup.computeIfAbsent(modelNum, k -> new LinkedList()).add(data);
                    continue;
                }
                oldModelData.add(data);
            }
        }
        return Tuple.create(modelGroup, (Object)oldModelData.toArray(new ExtendedDataEntity[0]));
    }

    public static List<Tuple<ExtendedDataEntity, String>> validateAndRecaliBration(Map<String, Map<Long, List<ExtendedDataEntity>>> modelOrgGroup, boolean isRecaliBration) {
        ExtDataSaveCtx extDataSaveCtx = ExtDataSaveCtxHelper.getExtDataSaveCtx();
        ArrayList<Tuple<ExtendedDataEntity, String>> errorMessage = new ArrayList<Tuple<ExtendedDataEntity, String>>();
        for (Map.Entry<String, Map<Long, List<ExtendedDataEntity>>> model : modelOrgGroup.entrySet()) {
            String modelNum = model.getKey();
            Map<Long, List<ExtendedDataEntity>> orgGroup = model.getValue();
            for (Map.Entry<Long, List<ExtendedDataEntity>> org : orgGroup.entrySet()) {
                Long orgId = org.getKey();
                extDataSaveCtx.initCtx(modelNum, orgId);
                List<ExtendedDataEntity> dataList = org.getValue();
                errorMessage.addAll(ExtDataValidateUtils.validateDataList(dataList, extDataSaveCtx, isRecaliBration));
            }
        }
        return errorMessage;
    }

    private static List<Tuple<ExtendedDataEntity, String>> validateDataList(List<ExtendedDataEntity> dataList, ExtDataSaveCtx extDataSaveCtx, boolean isRecaliBration) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        ArrayList<SimpleDynamicObject> sdoList = new ArrayList<SimpleDynamicObject>(dataList.size());
        ExtDataSdoHelper extDataSdoHelper = extDataSaveCtx.getExtDataSdoHelper();
        ArrayList<Tuple<ExtendedDataEntity, String>> errorMessage = new ArrayList<Tuple<ExtendedDataEntity, String>>(dataList.size());
        for (ExtendedDataEntity entity : dataList) {
            Long modelMasterId = entity.getDataEntity().getDynamicObject("eventclass").getLong("masterid");
            String extDataNum = entity.getDataEntity().getString("number");
            String data_tag = entity.getDataEntity().getString("data_tag");
            String modelIdAndDataNum = modelMasterId + extDataNum;
            if (isRecaliBration) {
                extDataSaveCtx.addExtData(extDataNum, entity);
            } else {
                Set hasVchEvtIdSet;
                boolean locked = ExtDataValidateUtils.checkLock(entity, extDataSaveCtx);
                if (!locked) {
                    extDataSaveCtx.addHeadError(modelIdAndDataNum);
                    errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create((Object)entity, (Object)ResManager.loadKDString((String)"\u6709\u5916\u90e8\u6570\u636e\u7c7b\u578b\u548c\u7f16\u7801\u76f8\u540c\u7684\u6570\u636e\u6b63\u5728\u5bfc\u5165\u6216\u8005\u6b63\u5728\u751f\u6210\u51ed\u8bc1\u3002", (String)"ExtDataValidateUtils_0", (String)"fi-ai-opplugin", (Object[])new Object[0])));
                    continue;
                }
                if (extDataSaveCtx.getExtDataMap().containsKey(extDataNum)) {
                    extDataSaveCtx.addHeadError(modelIdAndDataNum);
                    extDataSaveCtx.addErrorLockId(modelIdAndDataNum);
                    errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create((Object)entity, (Object)ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d", (String)"ExtDataValidateUtils_1", (String)"fi-ai-opplugin", (Object[])new Object[0])));
                    continue;
                }
                extDataSaveCtx.addExtData(extDataNum, entity);
                Map eventdata = (Map)SerializationUtils.fromJsonString((String)data_tag, Map.class);
                if (eventdata == null || eventdata.isEmpty()) {
                    extDataSaveCtx.addHeadError(modelIdAndDataNum);
                    extDataSaveCtx.addErrorLockId(modelIdAndDataNum);
                    errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create((Object)entity, (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u5f55\u5165\u6570\u636e", (String)"ExtDataValidateUtils_2", (String)"fi-ai-opplugin", (Object[])new Object[0])));
                    continue;
                }
                if (extDataSaveCtx.getHasVoucherEvts() != null && !extDataSaveCtx.getHasVoucherEvts().isEmpty() && (hasVchEvtIdSet = (Set)extDataSaveCtx.getHasVoucherEvts().get(modelMasterId)) != null && hasVchEvtIdSet.contains(entity.getDataEntity().getString("number"))) {
                    extDataSaveCtx.addHeadError(modelIdAndDataNum);
                    extDataSaveCtx.addErrorLockId(modelIdAndDataNum);
                    errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create((Object)entity, (Object)ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u5df2\u751f\u6210\u51ed\u8bc1", (String)"ExtDataValidateUtils_3", (String)"fi-ai-opplugin", (Object[])new Object[0])));
                    continue;
                }
            }
            SimpleDynamicObject sdo = extDataSdoHelper.create(extDataSaveCtx.getCurrentModelNum());
            ExtDataValidateUtils.setSysFields(sdo, entity.getDataEntity());
            extDataSdoHelper.parseFromJsonString(sdo, data_tag);
            sdoList.add(sdo);
        }
        extDataSaveCtx.getConverterHelper().finishCollect();
        for (SimpleDynamicObject sdo : sdoList) {
            extDataSdoHelper.convertBasedata(sdo);
        }
        ExtDataValidateUtils.checkRequied(dataList, sdoList, extDataSaveCtx);
        for (SimpleDynamicObject sdo : sdoList) {
            extDataSaveCtx.addSuccessOrFailedExtDataSdo(sdo, sdo.getBoolean(SAVE_DEFAULT));
        }
        return errorMessage;
    }

    private static void checkRequied(List<ExtendedDataEntity> dataList, List<SimpleDynamicObject> sdoList, ExtDataSaveCtx extDataSaveCtx) {
        Map<String, SimpleDynamicObject> sdoMap = sdoList.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e));
        ExtendedDataEntity entity = dataList.get(0);
        long eventclassId = entity.getDataEntity().getLong("eventclass_id");
        long orgId = entity.getDataEntity().getLong("org_id");
        try {
            LinkedList<AiEventData> aiEventDataList = new LinkedList<AiEventData>();
            HashSet errorSet = new HashSet(extDataSaveCtx.getHeadErrorList());
            for (ExtendedDataEntity data : dataList) {
                long modelMasterId = data.getDataEntity().getLong("eventclass.masterid");
                String extDataNum = data.getDataEntity().getString("number");
                String modelIdAndDataNum = modelMasterId + extDataNum;
                if (errorSet.contains(modelIdAndDataNum) || null == sdoMap.get(extDataNum)) continue;
                String dataTag = JSON.toJSONString((Object)SdoUtil.toMap((SimpleDynamicObject)sdoMap.get(extDataNum)));
                AiEventData aiEventData = new AiEventData();
                aiEventData.setNumber(extDataNum);
                aiEventData.setOrgId(orgId);
                aiEventData.setData_tag(dataTag);
                aiEventDataList.add(aiEventData);
            }
            if (CollectionUtils.isEmpty(aiEventDataList)) {
                return;
            }
            Map<String, Tuple<String, String>> resMap = FieldRequiredValidatorHepler.validateRequired(eventclassId, aiEventDataList, extDataSaveCtx.getFieldCfgMap(), extDataSaveCtx.getRequiredFields());
            if (null == resMap) {
                return;
            }
            for (Map.Entry<String, Tuple<String, String>> res : resMap.entrySet()) {
                String extDataNum = res.getKey();
                String fieldNum = (String)res.getValue().item1;
                String msg = (String)res.getValue().item2;
                DataModelFieldCfg fieldCfg = extDataSaveCtx.getFieldCfg(fieldNum);
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)extDataSaveCtx.getExtDataMap().get(extDataNum);
                long modelMasterId = extendedDataEntity.getDataEntity().getLong("eventclass.masterid");
                String modelIdAndDataNum = modelMasterId + extDataNum;
                extDataSaveCtx.addErrorMsg(msg, fieldCfg, sdoMap.get(extDataNum), null);
                extDataSaveCtx.addErrorLockId(modelIdAndDataNum);
            }
        }
        catch (Exception e2) {
            logger.error("\u6821\u9a8c\u5fc5\u5f55\u5f02\u5e38, modelNum: {}, DataNums: {}, msg:", new Object[]{extDataSaveCtx.getCurrentModelNum(), sdoMap.keySet(), e2});
            throw e2;
        }
    }

    private static void setSysFields(SimpleDynamicObject sdo, DynamicObject dataEntity) {
        sdo.set("id", dataEntity.get("id"));
        sdo.set("number", dataEntity.get("number"));
        sdo.set("versionnum", dataEntity.get("versionnum"));
        sdo.set("org_id", dataEntity.get("org_id"));
        sdo.set("sourcesys", dataEntity.get("sourcesys"));
        sdo.set("description", dataEntity.get("description"));
        sdo.set("paging", (Object)(!EventPagingEnum.COMMIT.getStatus().equalsIgnoreCase(dataEntity.getString("paging")) ? 1 : 0));
        sdo.set("billstatus", (Object)"C");
    }

    private static boolean checkLock(ExtendedDataEntity data, ExtDataSaveCtx extDataSaveCtx) {
        Long masterId = data.getDataEntity().getLong("eventclass.masterid");
        String number = data.getDataEntity().getString("number");
        String lockId = masterId + number;
        return extDataSaveCtx.getLockIds().contains(lockId);
    }

    public static List<Tuple<ExtendedDataEntity, String>> checkPreModelData(Map<String, List<ExtendedDataEntity>> modelGroup) {
        ArrayList<Tuple<ExtendedDataEntity, String>> errorMessage = new ArrayList<Tuple<ExtendedDataEntity, String>>();
        for (Map.Entry<String, List<ExtendedDataEntity>> model : modelGroup.entrySet()) {
            String modelNum = model.getKey();
            List<ExtendedDataEntity> dataList = model.getValue();
            errorMessage.addAll(ExtDataValidateUtils.checkPreModelDataList(modelNum, dataList));
        }
        return errorMessage;
    }

    private static List<Tuple<ExtendedDataEntity, String>> checkPreModelDataList(String modelNum, List<ExtendedDataEntity> dataList) {
        ArrayList<Tuple<ExtendedDataEntity, String>> errorMessage = new ArrayList<Tuple<ExtendedDataEntity, String>>(dataList.size());
        LinkedList<Long> ids = new LinkedList<Long>();
        HashMap<Long, ExtendedDataEntity> dataMap = new HashMap<Long, ExtendedDataEntity>(dataList.size());
        for (ExtendedDataEntity entity : dataList) {
            String status = entity.getDataEntity().getString("status");
            if ("2".equals(status)) {
                errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create((Object)entity, (Object)ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03\u7684\u5916\u90e8\u6570\u636e\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"ExtDataValidateUtils_4", (String)"fi-ai-opplugin", (Object[])new Object[0])));
                continue;
            }
            if ("3".equals(status)) {
                errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create((Object)entity, (Object)ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6821\u9a8c\u5931\u8d25\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"ExtDataValidateUtils_5", (String)"fi-ai-opplugin", (Object[])new Object[0])));
                continue;
            }
            String paging = entity.getDataEntity().getString("paging");
            if (EventPagingEnum.NO_COMMIT.getStatus().equals(paging.trim())) {
                errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create((Object)entity, (Object)ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u5bfc\u5165\u672a\u5b8c\u6210\u7684\u5916\u90e8\u6570\u636e\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"ExtDataValidateUtils_6", (String)"fi-ai-opplugin", (Object[])new Object[0])));
                continue;
            }
            Long id = entity.getDataEntity().getLong("id");
            ids.add(id);
            dataMap.put(id, entity);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            Map<Long, String> errorMsgMap = ExtDataValidateUtils.checkPreModelDataByIds(modelNum, ids, dataMap);
            for (Long id : ids) {
                String errorMsg = errorMsgMap.get(id);
                if (StringUtils.isEmpty((String)errorMsg)) continue;
                errorMessage.add((Tuple<ExtendedDataEntity, String>)Tuple.create(dataMap.get(id), (Object)errorMsg));
            }
        }
        return errorMessage;
    }

    private static Map<Long, String> checkPreModelDataByIds(String modelNum, List<Long> ids, Map<Long, ExtendedDataEntity> dataMap) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        Map<Long, String> blockStatusMap = ExtDataValidateUtils.checkEventIfBlockV2(ids);
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(8);
        LinkedList<Long> checkedBlockIds = new LinkedList<Long>();
        for (Long id2 : ids) {
            String blockStatus = blockStatusMap.get(id2);
            if (!StringUtils.isEmpty((String)blockStatus)) {
                String dataNum = dataMap.get(id2).getDataEntity().getString("number");
                String msg = ExtDataValidateUtils.getErrorMsg(blockStatus, dataNum);
                errorMsgMap.put(id2, msg);
                continue;
            }
            checkedBlockIds.add(id2);
        }
        if (CollectionUtils.isEmpty(checkedBlockIds)) {
            return errorMsgMap;
        }
        ExtendedDataEntity dataEntity = dataMap.get(ids.get(0));
        Long modelMasterId = dataEntity.getDataEntity().getLong("eventclass.masterid");
        String tableName = DataModelDaoImpl.getTableName((String)modelNum);
        DynamicObject[] relations = DataModelDaoImpl.getModelRelations((Long)modelMasterId);
        if (null == relations || relations.length == 0) {
            return errorMsgMap;
        }
        Map<ModelKey, List<Tuple<String, String>>> relationMap = ExtDataValidateUtils.groupByPreModel(relations);
        ArrayList<AiEventBlockDto> blockDtoList = new ArrayList<AiEventBlockDto>();
        for (Map.Entry<ModelKey, List<Tuple<String, String>>> relation : relationMap.entrySet()) {
            List invalidIds;
            HashMap<Long, Boolean> resMap = new HashMap<Long, Boolean>(checkedBlockIds.size());
            checkedBlockIds.forEach(id -> resMap.put((Long)id, false));
            ModelKey modelKey = relation.getKey();
            String preModelNum = modelKey.preModelNum;
            String preModelStatus = modelKey.preModelStatus;
            boolean genVch = EventPreStatusEnum.VOUCHER.getValue().equals(preModelStatus);
            String preTableName = DataModelDaoImpl.getMetaEntityNumber((String)preModelNum);
            List<Tuple<String, String>> fieldPairList = relation.getValue();
            SqlBuilder sqlBuilder = ExtDataValidateUtils.createSql(tableName, preTableName, fieldPairList, genVch, checkedBlockIds);
            int rows = 0;
            HashMap<Long, Map> fieldValueMap = new HashMap<Long, Map>(checkedBlockIds.size());
            DataSet dataSet = ExtDataValidateUtils.queryDataSet("ExtDataValidateUtils.checkPreModelData", FAHCommonConstant.AI, sqlBuilder);
            Object object = null;
            try {
                while (dataSet.hasNext()) {
                    Long checkField;
                    ++rows;
                    Row row = dataSet.next();
                    Long id3 = row.getLong("id");
                    Long l = checkField = genVch ? row.getLong("vid") : row.getLong("preid");
                    if (null != checkField && 0L != checkField) {
                        resMap.put(id3, true);
                    }
                    fieldValueMap.computeIfAbsent(id3, k -> {
                        HashMap<Object, String> valueMap = new HashMap<Object, String>(fieldPairList.size());
                        for (Tuple fieldPair : fieldPairList) {
                            valueMap.put(fieldPair.item1, row.getString((String)fieldPair.item1));
                        }
                        return valueMap;
                    });
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (DebugTrace.enable()) {
                logger.info("modelNum: {}, preModelNum: {}, preModelStatus: {}, fieldPairList: {}, check rows: {}, idCnt: {}, checkedBlockIds: {}", new Object[]{modelNum, preModelNum, preModelStatus, fieldPairList.stream().map(e -> (String)e.item1 + ":" + (String)e.item2).collect(Collectors.toList()), rows, checkedBlockIds.size(), checkedBlockIds});
            }
            if (CollectionUtils.isEmpty(invalidIds = resMap.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList()))) continue;
            for (Long id4 : invalidIds) {
                Map valueMap = (Map)fieldValueMap.get(id4);
                for (Tuple<String, String> fieldPair : fieldPairList) {
                    AiEventBlockDto blockDto = ExtDataValidateUtils.createBlockDto(id4, modelKey.preModelMasterId, preModelStatus, (String)fieldPair.item2, (String)valueMap.get(fieldPair.item1));
                    blockDtoList.add(blockDto);
                }
                errorMsgMap.put(id4, ExtDataValidateUtils.getErrorMsg(preModelStatus, dataMap.get(id4).getDataEntity().getString("number")));
            }
        }
        AiEventUtil.saveEventBlock(blockDtoList);
        return errorMsgMap;
    }

    private static DataSet queryDataSet(String algoKey, DBRoute dbRoute, SqlBuilder sqlBuilder) {
        return DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
    }

    private static Map<ModelKey, List<Tuple<String, String>>> groupByPreModel(DynamicObject[] relations) {
        HashMap<ModelKey, List<Tuple<String, String>>> relationMap = new HashMap<ModelKey, List<Tuple<String, String>>>(relations.length);
        for (DynamicObject relation : relations) {
            ModelKey preModelKey = new ModelKey();
            preModelKey.preModelMasterId = relation.getLong("predatamodel_id");
            preModelKey.preModelNum = relation.getString("predatamodel.number");
            preModelKey.preModelStatus = relation.getString("prestatus");
            relationMap.computeIfAbsent(preModelKey, k -> new LinkedList()).add(Tuple.create((Object)relation.getString("datafield"), (Object)relation.getString("predatafield")));
        }
        return relationMap;
    }

    private static AiEventBlockDto createBlockDto(Long id, Long preModelMasterId, String preModelStatus, String fieldNum, String fieldValue) {
        AiEventBlockDto blockDto = new AiEventBlockDto();
        blockDto.setEventClassId(preModelMasterId);
        blockDto.setFieldName(fieldNum);
        blockDto.setEventId(id);
        blockDto.setPreStatus(preModelStatus);
        blockDto.setFieldValue(fieldValue);
        return blockDto;
    }

    private static SqlBuilder createSql(String tableName, String preTableName, List<Tuple<String, String>> fieldPairList, boolean genVch, List<Long> checkedBlockIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid id, b.fid preid", new Object[0]);
        for (Tuple<String, String> fieldPair : fieldPairList) {
            sqlBuilder.append(",a.f" + (String)fieldPair.item1, new Object[0]).append((String)fieldPair.item1, new Object[0]);
        }
        if (genVch) {
            sqlBuilder.append(",c.fid dapid,c.fvoucherid vid ", new Object[0]);
        }
        sqlBuilder.append(" from ", new Object[0]).append(tableName, new Object[0]).append(" a ", new Object[0]).append(" left join ", new Object[0]).append(preTableName, new Object[0]).append(" b ", new Object[0]).append(" on ", new Object[0]);
        sqlBuilder.append(" b.fbillstatus='C' ", new Object[0]);
        for (Tuple<String, String> fieldPair : fieldPairList) {
            sqlBuilder.append(" and a.f" + (String)fieldPair.item1, new Object[0]).append("=", new Object[0]).append(" b.f" + (String)fieldPair.item2, new Object[0]);
        }
        if (genVch) {
            sqlBuilder.append(" left join t_ai_daptracker c on c.fsourcebillid=b.fid and c.fbilltype='" + preTableName + "'", new Object[0]);
        }
        sqlBuilder.appendIn(" where a.fid", checkedBlockIds.toArray());
        if (DebugTrace.enable()) {
            logger.info("sql: {}", (Object)sqlBuilder);
        }
        return sqlBuilder;
    }

    private static String getErrorMsg(String blockStatus, String dataNum) {
        StringBuilder sbMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u7f16\u53f7\uff1a\u201c%1$s\u201d", (String)"ExtDataValidateUtils_7", (String)"fi-ai-opplugin", (Object[])new Object[0]), dataNum));
        if ("oldData".equals(blockStatus)) {
            sbMsg.append(ResManager.loadKDString((String)"\u5b58\u5728\u963b\u585e\u4e8b\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExtDataValidateUtils_8", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        } else if (EventPreStatusEnum.VOUCHER.getValue().equals(blockStatus)) {
            sbMsg.append(ResManager.loadKDString((String)"\u5b58\u5728\u524d\u7f6e\u5916\u90e8\u6570\u636e\u6a21\u578b\u672a\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExtDataValidateUtils_9", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        } else {
            sbMsg.append(ResManager.loadKDString((String)"\u5b58\u5728\u524d\u7f6e\u5916\u90e8\u6570\u636e\u6a21\u578b\u672a\u4ea7\u751f\u5916\u90e8\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExtDataValidateUtils_10", (String)"fi-ai-opplugin", (Object[])new Object[0]));
        }
        return sbMsg.toString();
    }

    private static Map<Long, String> checkEventIfBlockV2(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        QFilter idFilter = new QFilter("eventid", "in", ids);
        DynamicObjectCollection blockStatusList = QueryServiceHelper.query((String)"ai_eventblock", (String)"eventid,textfield", (QFilter[])new QFilter[]{idFilter});
        if (CollectionUtils.isEmpty((Collection)blockStatusList)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> resMap = new HashMap<Long, String>(8);
        for (DynamicObject blockStatus : blockStatusList) {
            String status = blockStatus.getString("textfield");
            status = StringUtils.isEmpty((String)status) ? "oldData" : status;
            resMap.put(blockStatus.getLong("eventid"), status);
        }
        return resMap;
    }

    private static class ModelKey {
        private String preModelNum;
        private String preModelStatus;
        private Long preModelMasterId;

        private ModelKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelKey modelKey = (ModelKey)o;
            return Objects.equals(this.preModelMasterId, modelKey.preModelMasterId);
        }

        public int hashCode() {
            return Objects.hash(this.preModelMasterId);
        }
    }
}

