/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validate;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class FahValMapDeleteOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.remove(4);
        e.getValidators().add(new FahValMapDeleteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        HashSet<Long> deleteIdSet = new HashSet<Long>(4);
        for (DynamicObject deleteDate : e.getDataEntities()) {
            deleteIdSet.add((Long)deleteDate.getPkValue());
        }
        DeleteServiceHelper.delete((String)"fah_flex_mapval", (QFilter[])new QFilter[]{new QFilter("maptypeid", "in", deleteIdSet)});
    }

    public static class FahValMapDeleteValidator
    extends AbstractValidator {
        public void validate() {
            ExtendedDataEntity[] entities;
            for (ExtendedDataEntity entity : entities = this.getDataEntities()) {
                LinkedList<String> message = new LinkedList<String>();
                try (DataSet dataSet = this.getVchtemplateQuote((Long)entity.getValue("id"));){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        message.add(row.getString("fnumber"));
                    }
                }
                if (message.isEmpty()) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8be5\u4e1a\u8d22\u6570\u636e\u6620\u5c04\u88ab\u51ed\u8bc1\u6a21\u677f\u201c%1$s\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FahValMapDeleteOp_1", (String)"fi-ai-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", message)));
            }
        }

        private DataSet getVchtemplateQuote(Long id) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fnumber from t_ai_vchtemplate where fxml like ?", new Object[]{"%" + id + "%"});
            return DB.queryDataSet((String)FahValMapDeleteValidator.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        }
    }
}

