/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aifs.common.model;

import kd.fi.aifs.common.model.NumberCardModel;
import kd.fi.aifs.common.model.SelectsModel;
import kd.fi.aifs.common.model.UrlModel;

public class ResponseModel {
    private String type;
    private Object content;

    private ResponseModel(String type, Object content) {
        this.type = type;
        this.content = content;
    }

    public static ResponseModel createTextResponse(String content) {
        return new ResponseModel(Type.TEXT.toString(), content);
    }

    public static ResponseModel createSelectsResponse(SelectsModel selects) {
        return new ResponseModel(Type.SELECTS.toString(), selects);
    }

    public static ResponseModel createUrlResponse(UrlModel urlModel) {
        return new ResponseModel(Type.URL.toString(), urlModel);
    }

    public static ResponseModel createNumberCardResponse(NumberCardModel numberCardModel) {
        return new ResponseModel(Type.NUMBER_CARD.toString(), numberCardModel);
    }

    public String getType() {
        return this.type;
    }

    public Object getContent() {
        return this.content;
    }

    public static enum Type {
        TEXT,
        SELECTS,
        URL,
        NUMBER_CARD;

    }
}

