/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aifs.formplugin.mainpage;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aifs.business.picknumber.BcmPickNumber;
import kd.fi.aifs.business.picknumber.GlPickNumber;

public class MainPageAiConmmand {
    private static final String[] configFields = new String[]{"model", "currency", "audittrail", "internalcompany", "number", "name", "account", "scenario", "process", "numbersource", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "id", "enable", "accountfield", "multigaap", "accounttable", "currencyfield", "accrual", "balance", "reportaccrual", "reportbalance", "ratiotype", "broadcaststlye", "asstacttype", "reportbalance", "reportaccrual"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> doCommand(Map<String, Object> cmdParameters) {
        DynamicObject org;
        String orgName = (String)cmdParameters.get("orgname");
        String targetName = (String)cmdParameters.get("targetname");
        int year = (Integer)cmdParameters.get("year");
        int month = (Integer)cmdParameters.get("month");
        QFilter f1 = new QFilter("name", "=", (Object)targetName);
        DynamicObject targetConfig = BusinessDataServiceHelper.loadSingle((String)"aifs_targetset", (String)String.join((CharSequence)",", configFields), (QFilter[])new QFilter[]{f1});
        if (targetConfig == null) {
            return null;
        }
        String enable = targetConfig.getString("enable");
        if (enable.equals("0")) {
            return null;
        }
        String source = targetConfig.getString("numbersource");
        HashMap<String, Object> searchProp = new HashMap<String, Object>();
        String modelId = null;
        if (source.equals("2")) {
            DynamicObject modelDy = targetConfig.getDynamicObject("model");
            if (modelDy == null) {
                return null;
            }
            modelId = modelDy.getString("id");
        }
        if ((org = MainPageAiConmmand.matchOrg(orgName, source, modelId)) == null) {
            return null;
        }
        for (IDataEntityProperty prop : targetConfig.getDynamicObjectType().getProperties()) {
            String propKey = prop.getName();
            searchProp.put(propKey, targetConfig.get(propKey));
        }
        MainPageAiConmmand.changePropForBcm(searchProp);
        searchProp.put("entity", org.getString("id"));
        searchProp.put("orgNum", org.getString("number"));
        searchProp.put("orgName", org.getString("name"));
        Map<Object, Object> backData1 = new HashMap();
        BigDecimal backData = new BigDecimal(0);
        List<String> targetTypes = MainPageAiConmmand.checkType((String)searchProp.get("ratiotype"));
        String allErrorMsg = null;
        HashMap<String, Object> allBackData = new HashMap<String, Object>();
        block19: for (String type : targetTypes) {
            String unitName = "%";
            switch (type) {
                case "\u5b9e\u9645\u6570": {
                    if (!MainPageAiConmmand.checkAccrualAndBalance(1, searchProp)) break;
                    try {
                        backData1 = MainPageAiConmmand.getData(searchProp, source, year, month);
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        if (errorMsg == null || !errorMsg.contains("AIFS")) throw e;
                        allErrorMsg = errorMsg;
                        break block19;
                    }
                    if (backData1 == null || backData1.size() == 0) break;
                    backData = (BigDecimal)backData1.get("data");
                    allBackData.put("accrual", backData);
                    break;
                }
                case "\u4f59\u989d": {
                    if (!MainPageAiConmmand.checkAccrualAndBalance(2, searchProp)) break;
                    try {
                        backData1 = MainPageAiConmmand.getData(searchProp, source, year, month);
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        if (errorMsg == null || !errorMsg.contains("AIFS")) throw e;
                        allErrorMsg = errorMsg;
                        break;
                    }
                    if (backData1 == null || backData1.size() == 0) break;
                    backData = (BigDecimal)backData1.get("data");
                    allBackData.put("balance", backData);
                    break;
                }
                case "\u73af\u6bd4\u589e\u957f": {
                    if (!MainPageAiConmmand.checkAccrualAndBalance(1, searchProp)) break;
                    int year1 = year;
                    int period1 = month - 1;
                    if (month == 1) {
                        year1 = year - 1;
                        period1 = 12;
                    }
                    if ((backData = MainPageAiConmmand.getRate(searchProp, source, year, month, year1, period1)) == null) break;
                    allBackData.put("momgrow", backData + unitName);
                    break;
                }
                case "\u540c\u6bd4\u589e\u957f": {
                    if (!MainPageAiConmmand.checkAccrualAndBalance(1, searchProp) || (backData = MainPageAiConmmand.getRate(searchProp, source, year, month, year - 1, month)) == null) break;
                    allBackData.put("yoygrow", backData + unitName);
                    break;
                }
                case "\u5e74\u589e\u957f\u7387": {
                    MainPageAiConmmand.checkAccrualAndBalance(3, searchProp);
                    backData = MainPageAiConmmand.getRate(searchProp, source, year, month, year - 1, month);
                    if (backData == null) break;
                    allBackData.put("yeargrow", backData + unitName);
                }
            }
        }
        if (allBackData.isEmpty()) {
            if (allErrorMsg == null) return allBackData;
            return null;
        } else {
            allBackData.put("currency", targetConfig.getDynamicObject("currencyfield").get("id"));
        }
        return allBackData;
    }

    private static void changePropForBcm(Map<String, Object> searchProp) {
        String sourse = String.valueOf(searchProp.get("numbersource"));
        if (sourse.equals("2")) {
            ArrayList<String> propKeys = new ArrayList<String>(searchProp.keySet());
            for (String key : propKeys) {
                if (key.endsWith("_id")) {
                    searchProp.remove(key);
                    continue;
                }
                Object value = searchProp.get(key);
                if (value == null || !value.getClass().equals(DynamicObject.class)) continue;
                searchProp.put(key, ((DynamicObject)value).get("id"));
            }
        }
    }

    public static BigDecimal getRate(Map<String, Object> searchProp, String source, int yearInt, int periodInt, int yearInt1, int periodInt1) {
        Map<Object, Object> backData1 = new HashMap();
        Map<Object, Object> backData2 = new HashMap();
        BigDecimal backData = BigDecimal.ZERO;
        backData1 = MainPageAiConmmand.getData(searchProp, source, yearInt, periodInt);
        try {
            backData2 = MainPageAiConmmand.getData(searchProp, source, yearInt1, periodInt1);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg != null && errorMsg.contains("AIFS")) {
                backData2 = new HashMap();
            }
            throw e;
        }
        if ((backData1 == null || backData1.size() == 0) && backData2 != null && backData2.size() > 0) {
            return null;
        }
        if (backData1 != null && backData1.size() > 0 && (backData2 == null || backData2.size() == 0)) {
            backData = new BigDecimal(100);
        } else {
            if (!(backData1 != null && backData1.size() != 0 || backData2 != null && backData2.size() != 0)) {
                return null;
            }
            if (backData1 == null || backData2 == null) {
                return null;
            }
            BigDecimal one = (BigDecimal)backData1.get("data");
            BigDecimal two = (BigDecimal)backData2.get("data");
            backData = one.divide(two, 5, RoundingMode.HALF_UP).subtract(BigDecimal.ONE).multiply(new BigDecimal(100));
            backData = backData.setScale(2, RoundingMode.HALF_UP);
        }
        return backData;
    }

    public static String getCurrencySign(String number) {
        QFilter idf = new QFilter("number", "=", (Object)number);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_currency", (String)"sign", (QFilter[])new QFilter[]{idf});
        return dyn.getString("sign");
    }

    public static Map<String, Object> getData(Map<String, Object> searchProp, String source, int year, int period) {
        Map data;
        if (source.equals("1")) {
            searchProp.put("year", year);
            searchProp.put("period", period);
            data = new GlPickNumber().SearchData(searchProp);
        } else {
            QFilter F1 = new QFilter("name", "=", (Object)String.format(ResManager.loadKDString((String)"%1$s\u6708", (String)"MainPageAiConmmand_0", (String)"fi-aifs-formplugin", (Object[])new Object[0]), period));
            QFilter F2 = new QFilter("model", "=", (Object)Long.parseLong(String.valueOf(searchProp.get("model"))));
            DynamicObject dyObject1 = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"number,id,name", (QFilter[])new QFilter[]{F1, F2});
            if (dyObject1 == null) {
                return null;
            }
            searchProp.put("period", dyObject1.getString("id"));
            F1 = new QFilter("name", "=", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5e74", (String)"MainPageAiConmmand_1", (String)"fi-aifs-formplugin", (Object[])new Object[0]), year));
            DynamicObject dyObject2 = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"number,id,name", (QFilter[])new QFilter[]{F1, F2});
            if (dyObject2 == null) {
                return null;
            }
            searchProp.put("year", dyObject2.getString("id"));
            data = BcmPickNumber.pickNumber(searchProp);
        }
        return data;
    }

    private static DynamicObject matchOrg(String orgName, String source, String modelId) {
        DynamicObject org = null;
        QFilter q1 = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter q2 = new QFilter("view.treetype", "=", (Object)"10");
        QFilter q4 = new QFilter("org.name", "=", (Object)orgName);
        org = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id as viewid,org.id as id,org.number as number,org.name as name,view.treetype", (QFilter[])new QFilter[]{q1, q2, q4});
        if (source.equals("2")) {
            q1 = new QFilter("name", "=", (Object)orgName);
            q2 = new QFilter("model", "=", (Object)Long.parseLong(modelId));
            QFilter q3 = new QFilter("storagetype", "!=", (Object)"3");
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"name,id,number,storagetype", (QFilter[])new QFilter[]{q1, q2, q3});
        }
        return org;
    }

    public static boolean checkAccrualAndBalance(int type, Map<String, Object> searchProp) {
        String sourse = (String)searchProp.get("numbersource");
        boolean done = false;
        if (sourse.equals("1")) {
            String accrual = (String)searchProp.get("accrual");
            String balance = (String)searchProp.get("balance");
            if (type == 1 && !accrual.equals("7")) {
                searchProp.put("fetchType", accrual);
                done = true;
            }
            if (type == 2 && !balance.equals("7")) {
                searchProp.put("fetchType", balance);
                done = true;
            }
            if (type == 3) {
                if (accrual.equals("1")) {
                    searchProp.put("fetchType", "3");
                } else if (accrual.equals("2")) {
                    searchProp.put("fetchType", "4");
                }
            }
        } else {
            Long reportaccrual = (Long)searchProp.get("reportaccrual");
            Long reportbalance = (Long)searchProp.get("reportbalance");
            if (reportaccrual != null && reportaccrual != 0L && type == 1) {
                searchProp.put("changetype", reportaccrual);
                done = true;
            }
            if (reportbalance != null && reportbalance != 0L && type == 2) {
                searchProp.put("changetype", reportbalance);
                done = true;
            }
            if (type == 3) {
                Long modelId = (Long)searchProp.get("model");
                QFilter qModel = new QFilter("model", "=", (Object)modelId);
                DynamicObject changeType = QueryServiceHelper.queryOne((String)"bcm_changetypemembertree", (String)"name,number", (QFilter[])new QFilter[]{qModel, new QFilter("id", "=", (Object)reportaccrual)});
                String accrualNum = changeType.getString("number");
                if (accrualNum.equals("CurrentPeriod")) {
                    QFilter qType = new QFilter("storagetype", "!=", (Object)"3");
                    changeType = QueryServiceHelper.queryOne((String)"bcm_changetypemembertree", (String)"name,number,id", (QFilter[])new QFilter[]{qModel, qType, new QFilter("number", "=", (Object)"YTD")});
                    searchProp.put("changetype", changeType.get("id"));
                } else {
                    searchProp.put("changetype", reportaccrual);
                }
            }
        }
        return done;
    }

    public static List<String> checkType(String rate) {
        ArrayList<String> targetTypes = new ArrayList<String>();
        targetTypes.add(ResManager.loadKDString((String)"\u4f59\u989d", (String)"MainPageAiConmmand_2", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        targetTypes.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"MainPageAiConmmand_3", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        if ("3567".contains(rate)) {
            targetTypes.add(ResManager.loadKDString((String)"\u5e74\u589e\u957f\u7387", (String)"MainPageAiConmmand_4", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        if ("1457".contains(rate)) {
            targetTypes.add(ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f", (String)"MainPageAiConmmand_5", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        if ("2467".contains(rate)) {
            targetTypes.add(ResManager.loadKDString((String)"\u73af\u6bd4\u589e\u957f", (String)"MainPageAiConmmand_6", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        return targetTypes;
    }

    public Map<String, List<Object>> packParameters(DynamicObjectCollection parameters, Object[] allField) {
        HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
        for (DynamicObject p : parameters) {
            for (Object key : allField) {
                String keyStr = (String)key;
                if (!data.containsKey(key)) {
                    data.put(keyStr, new ArrayList());
                    continue;
                }
                List valus = (List)data.get(key);
                if (valus.contains(p.get(keyStr))) continue;
                valus.add(p.get(keyStr));
            }
        }
        return data;
    }
}

