/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aifs.formplugin.mainpage;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.aifs.util.DateUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;

public class TargetQueryApi
implements ISkillRunnable {
    private static final Log LOG = LogFactory.getLog(TargetQueryApi.class);
    private static DBRoute ROUNTE_FI = DBRoute.of((String)"fi");

    public SkillRunResult pullData(SkillRunContext runContext) {
        int totalTimes;
        int currentMonthTimes;
        if (DebugTrace.enable()) {
            LOG.info("TargetQuery pullData param runContext: {}", (Object)DebugTraceHelper.toString((Object)runContext));
        }
        if (runContext == null) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"TargetQueryApi_0", (String)"fi-aifs-formplugin", (Object[])new Object[0])});
        }
        SkillRunResult skillResult = runContext.getSkillResult();
        String skillNum = runContext.getSkillNum();
        Date startTime = runContext.getStartTime();
        Date endTime = runContext.getEndTime();
        if (startTime == null || endTime == null) {
            throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u6216\u622a\u6b62\u65f6\u95f4\u4e3a\u7a7a", (String)"TargetQueryApi_1", (String)"fi-aifs-formplugin", (Object[])new Object[0])});
        }
        int startYearMonth = DateUtil.getYearMonth((Date)startTime);
        int endYearMonth = DateUtil.getYearMonth((Date)endTime);
        int targetsTimes = this.getTargetSize();
        if (targetsTimes < 1) {
            currentMonthTimes = 0;
            totalTimes = 0;
        } else {
            Calendar c = Calendar.getInstance();
            int year = c.get(1);
            int month = c.get(2);
            int yearmonth = year * 100 + month + 1;
            currentMonthTimes = this.getQueryTimesByYearMonth(yearmonth);
            totalTimes = this.getQueryTimesBetweenYearMonth(startYearMonth, endYearMonth);
        }
        HashMap<String, String> currentMonthTimesMap = new HashMap<String, String>();
        currentMonthTimesMap.put("name", ResManager.loadKDString((String)"\u672c\u6708\u67e5\u8be2\u6b21\u6570", (String)"TargetQueryApi_2", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        currentMonthTimesMap.put("value", String.valueOf(currentMonthTimes));
        currentMonthTimesMap.put("valueType", "0");
        currentMonthTimesMap.put("number", "bycxcs");
        HashMap<String, String> targetsTimesMap = new HashMap<String, String>();
        targetsTimesMap.put("name", ResManager.loadKDString((String)"\u53ef\u67e5\u8be2\u6307\u6807\u6570", (String)"TargetQueryApi_3", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        targetsTimesMap.put("value", String.valueOf(targetsTimes));
        targetsTimesMap.put("valueType", "0");
        targetsTimesMap.put("number", "kcxzbs");
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        list.add(currentMonthTimesMap);
        list.add(targetsTimesMap);
        skillResult.setData(list);
        skillResult.setDate(startTime);
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(Integer.valueOf(totalTimes));
        if (DebugTrace.enable()) {
            LOG.info("TargetQuery pullData skillResult: {}", (Object)skillResult.toString());
        }
        return skillResult;
    }

    private int getTargetSize() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select count(1) from  t_aifs_targetset", new Object[0]);
        return this.executeSql(sqlBuilder);
    }

    private int getQueryTimesBetweenYearMonth(int startYearMonth, int endYearMonth) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select sum(ftimes) from t_aifs_queryrecord where ", new Object[0]);
        sqlBuilder.append("fyearmonth >= ?", new Object[]{startYearMonth});
        sqlBuilder.append(" and fyearmonth <= ?", new Object[]{endYearMonth});
        return this.executeSql(sqlBuilder);
    }

    private int getQueryTimesByYearMonth(int yearmonth) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select sum(ftimes) from t_aifs_queryrecord where ", new Object[0]);
        sqlBuilder.append("fyearmonth = ? ", new Object[]{yearmonth});
        return this.executeSql(sqlBuilder);
    }

    private int executeSql(SqlBuilder sqlBuilder) {
        return (Integer)DB.query((DBRoute)ROUNTE_FI, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                rs.next();
                return rs.getInt(1);
            }
        });
    }
}

