/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aifs.formplugin.parse;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.aifs.business.picknumber.BcmPickNumber;
import kd.fi.aifs.business.picknumber.GlPickNumber;
import kd.fi.aifs.common.model.NumberCardModel;
import kd.fi.aifs.common.model.ResponseModel;
import kd.fi.aifs.common.model.SelectsModel;
import kd.fi.aifs.util.AifsUtil;

public class PaserAiCommand
extends AbstractBillWebApiPlugin {
    private final String[] configFields = new String[]{"model", "currency", "audittrail", "internalcompany", "number", "name", "account", "scenario", "process", "numbersource", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "id", "enable", "accountfield", "multigaap", "accounttable", "currencyfield", "accrual", "balance", "reportaccrual", "reportbalance", "ratiotype", "broadcaststlye", "asstacttype", "reportbalance", "reportaccrual"};

    public void doAICommand(AICommandEvent e) {
        LicenseCheckResult licresult = LicenseServiceHelper.checkPerformGroup((String)"PRO_AIFS");
        if (!licresult.getHasLicense().booleanValue()) {
            String msg = licresult.getMsg();
            throw new KDBizException(msg);
        }
        super.doAICommand(e);
        AICommand command = e.getCommand();
        Map cmdParameters = command.getParameter();
        ApiResult result = new ApiResult();
        ResponseModel response = null;
        try {
            response = ResponseModel.createNumberCardResponse((NumberCardModel)((NumberCardModel)this.doCommand(cmdParameters)));
        }
        catch (Exception e2) {
            String errorMsg = e2.getMessage();
            if (errorMsg != null && errorMsg.contains("AIFS")) {
                response = ResponseModel.createTextResponse((String)errorMsg.substring(errorMsg.indexOf("AIFS") + 4));
            }
            throw e2;
        }
        result.setData((Object)response);
        e.setResult(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doCommand(Map<String, Object> cmdParameters) {
        StringBuffer backString = new StringBuffer();
        String orgName = (String)cmdParameters.get("orgname");
        String targetName = (String)cmdParameters.get("targetname");
        String asstactType = (String)cmdParameters.get("asstactType");
        HashMap asstcatMsg = (HashMap)cmdParameters.get("asstactMsg");
        String asstcatMsgId = "";
        String asstcatMsgName = "";
        if (asstcatMsg != null) {
            asstcatMsgId = (String)asstcatMsg.get("id");
            asstcatMsgName = (String)asstcatMsg.get("value");
        }
        String uid = RequestContext.getOrCreate().getUserId();
        String appId = AppMetadataCache.getAppInfo((String)"aifs").getId();
        int[] yearAndPeriod = this.matchYearAndPeriod((String)cmdParameters.get("year"), (String)cmdParameters.get("period"));
        int yearInt = yearAndPeriod[0];
        int periodInt = yearAndPeriod[1];
        QFilter f1 = new QFilter("name", "=", (Object)targetName);
        DynamicObject targetConfig = BusinessDataServiceHelper.loadSingle((String)"aifs_targetset", (String)String.join((CharSequence)",", this.configFields), (QFilter[])new QFilter[]{f1});
        this.checkNull(targetConfig, ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u672a\u914d\u7f6e\u8be5\u6307\u6807\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u67e5\u8be2", (String)"PaserAiCommand_0", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        this.recordQueryInformation(Long.parseLong(uid), yearInt * 100 + periodInt, targetName);
        String enable = targetConfig.getString("enable");
        if (enable.equals("0")) {
            throw new KDBizException(ResManager.loadKDString((String)"AIFS\u4f60\u8981\u770b\u7684\u8fd9\u9879\u6307\u6807\u8fd8\u672a\u5f00\u542f\uff0c\u4f26\u5bb6\u7ed9\u4f60\u627e\u5230\u4e86\u7ba1\u7406\u5458\uff0c\u8bf7\u4ed6\u7ed9\u4f60\u542f\u7528\u4e00\u4e0b\u5427", (String)"PaserAiCommand_1", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection types = targetConfig.getDynamicObjectCollection("asstacttype");
        ArrayList<String> typeNameList = new ArrayList<String>();
        for (DynamicObject asstcattype : types) {
            typeNameList.add(asstcattype.getString("fbasedataid.name"));
        }
        String source = targetConfig.getString("numbersource");
        HashMap<String, Object> searchProp = new HashMap<String, Object>(16);
        if (asstactType != null && asstactType.length() > 0) {
            if (source.equals("2")) {
                throw new KDBizException(ResManager.loadKDString((String)"AIFS\u5bf9\u4e0d\u8d77\u4f60\u6240\u67e5\u8be2\u7684\u6307\u6807\u4e3a\u62a5\u8868\u7cfb\u7edf\u53d6\u6570\uff0c\u65e0\u6cd5\u67e5\u8be2\u6838\u7b97\u7ef4\u5ea6", (String)"PaserAiCommand_2", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
            }
            if (!typeNameList.contains(asstactType)) {
                throw new KDBizException(ResManager.loadKDString((String)"AIFS\u5bf9\u4e0d\u8d77\u4f60\u6240\u67e5\u8be2\u7684\u6307\u6807\u672a\u914d\u7f6e\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u6b21\u67e5\u8be2", (String)"PaserAiCommand_3", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
            }
            if (typeNameList.contains(asstactType)) {
                Map<Long, String> flexfieldAndId = this.getAsstCat(asstactType, asstcatMsgId, asstcatMsgName);
                if (flexfieldAndId.size() == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"AIFS\u5bf9\u4e0d\u8d77\uff0c\u60a8\u8981\u67e5\u7684%1$s%2$s%3$s%3$s", (String)"PaserAiCommand_4", (String)"fi-aifs-formplugin", (Object[])new Object[0]), targetName, ResManager.loadKDString((String)"\u6307\u6807\u4e0b\u6ca1\u6709\u914d\u7f6e\u201c", (String)"PaserAiCommand_5", (String)"fi-aifs-formplugin", (Object[])new Object[0]), asstactType, ResManager.loadKDString((String)"\u201d\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u67e5\u8be2", (String)"PaserAiCommand_6", (String)"fi-aifs-formplugin", (Object[])new Object[0])));
                }
                if (flexfieldAndId.size() == 1) {
                    for (Map.Entry<Long, String> entry : flexfieldAndId.entrySet()) {
                        long asstactid = entry.getKey();
                        searchProp.put("flexfield", entry.getValue());
                        searchProp.put("asstact", asstactid);
                    }
                } else {
                    ArrayList<SelectsModel.SelectItem> selectItemList = new ArrayList<SelectsModel.SelectItem>(flexfieldAndId.size());
                    Iterator<Map.Entry<Long, String>> entry = flexfieldAndId.entrySet().iterator();
                    while (true) {
                        if (!entry.hasNext()) {
                            SelectsModel selectModel = new SelectsModel(ResManager.loadKDString((String)"\u67e5\u5230\u6709\u4ee5\u4e0b\u51e0\u4e2a\u6838\u7b97\u4f53\u7cfb~\u8bf7\u9009\u62e9", (String)"PaserAiCommand_7", (String)"fi-aifs-formplugin", (Object[])new Object[0]), selectItemList);
                            return ResponseModel.createSelectsResponse((SelectsModel)selectModel);
                        }
                        Map.Entry<Long, String> entry2 = entry.next();
                        SelectsModel.SelectItem selectItem = new SelectsModel.SelectItem(String.valueOf(entry2.getKey()), entry2.getValue());
                        selectItemList.add(selectItem);
                    }
                }
            }
        }
        String modelId = null;
        if (source.equals("2")) {
            DynamicObject modelDy = targetConfig.getDynamicObject("model");
            this.checkNull(modelDy, ResManager.loadKDString((String)"\u8be5\u6307\u6807\u4e0b\u914d\u7f6e\u7684\u4f53\u7cfb\u6570\u636e\u8bfb\u53d6\u51fa\u9519\uff0c\u5c0fk\u4e3a\u4f60\u627e\u5230\u4e86\u7ba1\u7406\u5458", (String)"PaserAiCommand_8", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
            modelId = modelDy.getString("id");
        }
        DynamicObject org = this.matchOrg(orgName, source, modelId);
        this.checkNull(org, ResManager.loadKDString((String)"\u4f60\u8981\u770b\u7684\u8be5\u7ec4\u7ec7\u5c1a\u65e0\u6570\u636e\uff0c\u5c0fK\u4e3a\u4f60\u627e\u5230\u4e86\u7ba1\u7406\u5458", (String)"PaserAiCommand_9", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        boolean ifperomorg = this.ifPermOrg(uid, appId, org.getLong("id"));
        if (!ifperomorg) {
            throw new KDBizException(ResManager.loadKDString((String)"AIFS\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8d22\u52a1\u67e5\u8be2\u6743\u9650\u4e2d\u672a\u914d\u7f6e\u8be5\u6838\u7b97\u4e3b\u4f53\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\u540e\u518d\u8bd5", (String)"PaserAiCommand_10", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        for (IDataEntityProperty prop : targetConfig.getDynamicObjectType().getProperties()) {
            String propKey = prop.getName();
            searchProp.put(propKey, targetConfig.get(propKey));
        }
        this.changePropForBcm(searchProp);
        searchProp.put("entity", org.getString("id"));
        searchProp.put("orgNum", org.getString("number"));
        searchProp.put("orgName", org.getString("name"));
        Map<Object, Object> backData1 = new HashMap();
        BigDecimal backData = new BigDecimal(0);
        List<String> targetTypes = this.checkType((String)searchProp.get("ratiotype"));
        String allErrorMsg = null;
        HashMap<String, String> allBackData = new HashMap<String, String>(16);
        block22: for (String type : targetTypes) {
            String unitName = "%";
            switch (type) {
                case "\u5b9e\u9645\u6570": {
                    if (!this.checkAccrualAndBalance(1, searchProp)) break;
                    try {
                        backData1 = this.getData(searchProp, source, yearInt, periodInt);
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        if (errorMsg != null && errorMsg.contains("AIFS")) {
                            allErrorMsg = errorMsg;
                            break block22;
                        }
                        throw e;
                    }
                    if (backData1.isEmpty()) break;
                    backData = (BigDecimal)backData1.get("data");
                    unitName = this.getCurrencySign((String)backData1.get("currency"));
                    allBackData.put(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"PaserAiCommand_11", (String)"fi-aifs-formplugin", (Object[])new Object[0]), unitName + this.changeDataDisplay(backData));
                    break;
                }
                case "\u4f59\u989d": {
                    if (!this.checkAccrualAndBalance(2, searchProp)) break;
                    try {
                        backData1 = this.getData(searchProp, source, yearInt, periodInt);
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        if (errorMsg != null && errorMsg.contains("AIFS")) {
                            allErrorMsg = errorMsg;
                            break;
                        }
                        throw e;
                    }
                    if (backData1.isEmpty()) break;
                    backData = (BigDecimal)backData1.get("data");
                    unitName = this.getCurrencySign((String)backData1.get("currency"));
                    allBackData.put(ResManager.loadKDString((String)"\u4f59\u989d", (String)"PaserAiCommand_12", (String)"fi-aifs-formplugin", (Object[])new Object[0]), unitName + this.changeDataDisplay(backData));
                    break;
                }
                case "\u73af\u6bd4\u589e\u957f": {
                    if (!this.checkAccrualAndBalance(1, searchProp)) break;
                    int year1 = yearInt;
                    int period1 = periodInt - 1;
                    if (periodInt == 1) {
                        year1 = yearInt - 1;
                        period1 = 12;
                    }
                    if ((backData = this.getRate(searchProp, source, yearInt, periodInt, year1, period1)) == null) break;
                    allBackData.put(ResManager.loadKDString((String)"\u73af\u6bd4", (String)"PaserAiCommand_13", (String)"fi-aifs-formplugin", (Object[])new Object[0]), backData + unitName);
                    break;
                }
                case "\u540c\u6bd4\u589e\u957f": {
                    if (!this.checkAccrualAndBalance(1, searchProp) || (backData = this.getRate(searchProp, source, yearInt, periodInt, yearInt - 1, periodInt)) == null) break;
                    allBackData.put(ResManager.loadKDString((String)"\u540c\u6bd4", (String)"PaserAiCommand_14", (String)"fi-aifs-formplugin", (Object[])new Object[0]), backData + unitName);
                    break;
                }
                case "\u5e74\u589e\u957f\u7387": {
                    this.checkAccrualAndBalance(3, searchProp);
                    backData = this.getRate(searchProp, source, yearInt, periodInt, yearInt - 1, periodInt);
                    if (backData == null) break;
                    allBackData.put(ResManager.loadKDString((String)"\u5e74\u589e\u957f\u7387", (String)"PaserAiCommand_15", (String)"fi-aifs-formplugin", (Object[])new Object[0]), backData + unitName);
                }
            }
        }
        if (allBackData.isEmpty()) {
            if (allErrorMsg != null) {
                throw new KDBizException(allErrorMsg);
            }
            throw new KDBizException(ResManager.loadKDString((String)"AIFS\u4f60\u8981\u770b\u7684\u7ec4\u7ec7\u8fd8\u6ca1\u6570\u636e\u54a7\uff0c\u4f26\u5bb6\u7ed9\u4f60\u627e\u5230\u4e86\u7ba1\u7406\u5458\uff0c\u4ed6\u4f1a\u7ed9\u4f60\u89e3\u91ca\u7684", (String)"PaserAiCommand_16", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        if (asstactType != null && asstactType.length() > 0 && !asstactType.equals("null")) {
            if (this.isMultiOrg(uid)) {
                backString.append(org.getString("name"));
                backString.append(ResManager.loadKDString((String)"\u7684", (String)"PaserAiCommand_17", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
                backString.append(asstactType);
                backString.append(asstcatMsgName);
            } else {
                backString.append(asstcatMsgName);
                backString.append('(');
                backString.append(asstactType);
                backString.append(')');
            }
        } else {
            backString.append(org.getString("name"));
        }
        backString.append(String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u4efd\u7684%3$s", (String)"PaserAiCommand_18", (String)"fi-aifs-formplugin", (Object[])new Object[0]), yearInt, periodInt, targetName));
        NumberCardModel response = new NumberCardModel();
        response.setTitle(orgName);
        ArrayList<NumberCardModel.CardDetail> ratioDetail = new ArrayList<NumberCardModel.CardDetail>(allBackData.size());
        ArrayList<NumberCardModel.CardDetail> numeralDetail = new ArrayList<NumberCardModel.CardDetail>(allBackData.size());
        Object object = allBackData.entrySet().iterator();
        while (true) {
            if (!object.hasNext()) {
                response.setRatioDetail(ratioDetail);
                response.setNumeralDetail(numeralDetail);
                response.setDesc(String.format(ResManager.loadKDString((String)"%1$s\u6570\u636e\u5982\u4e0b", (String)"PaserAiCommand_20", (String)"fi-aifs-formplugin", (Object[])new Object[0]), backString));
                return response;
            }
            Map.Entry entry = (Map.Entry)object.next();
            if (((String)entry.getKey()).equals(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"PaserAiCommand_11", (String)"fi-aifs-formplugin", (Object[])new Object[0])) || ((String)entry.getKey()).equals(ResManager.loadKDString((String)"\u4f59\u989d", (String)"PaserAiCommand_12", (String)"fi-aifs-formplugin", (Object[])new Object[0]))) {
                numeralDetail.add(new NumberCardModel.CardDetail((String)entry.getKey(), (String)entry.getValue()));
                continue;
            }
            ratioDetail.add(new NumberCardModel.CardDetail((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private void changePropForBcm(Map<String, Object> searchProp) {
        String sourse = String.valueOf(searchProp.get("numbersource"));
        if (sourse.equals("2")) {
            ArrayList<String> propKeys = new ArrayList<String>(searchProp.keySet());
            for (String key : propKeys) {
                if (key.endsWith("_id")) {
                    searchProp.remove(key);
                    continue;
                }
                Object value = searchProp.get(key);
                if (value == null || !value.getClass().equals(DynamicObject.class)) continue;
                searchProp.put(key, ((DynamicObject)value).get("id"));
            }
        }
    }

    public boolean isMultiOrg(String uid) {
        ArrayList<String> orgNames = new ArrayList<String>();
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"aifs_targetset", (String)"47150e89000000ac");
        QFilter qPermOrgIds = null;
        if (!permOrgRs.hasAllOrgPerm()) {
            List allPermOrgIds = permOrgRs.getHasPermOrgs();
            qPermOrgIds = new QFilter("org.id", "in", (Object)allPermOrgIds.toArray());
        }
        ArrayList<String> org2 = new ArrayList<String>();
        QFilter qViewDefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter qViewType = new QFilter("view.treetype", "=", (Object)"10");
        DynamicObjectCollection allPermOrgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id as id,org.number as number,org.name as name", (QFilter[])new QFilter[]{qViewDefault, qViewType, qPermOrgIds}, null, (int)20);
        for (DynamicObject org : allPermOrgs) {
            String name = org.getString("name");
            if (!org2.contains(name)) {
                org2.add(name);
                orgNames.add(org.getString("name"));
            }
            if (orgNames.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public Map<Long, String> getAsstCat(String typeName, String asstcatMsgId, String asstcatMsgName) {
        HashMap<Long, String> flexfieldAndid = new HashMap<Long, String>();
        if (typeName.length() > 5 && typeName.substring(0, 5).equals(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599_", (String)"PaserAiCommand_21", (String)"fi-aifs-formplugin", (Object[])new Object[0]))) {
            QFilter idOrNameFilter;
            QFilter filter = new QFilter("name", "=", (Object)typeName.substring(5));
            DynamicObject asstcatType = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"assistanttype,flexfield", (QFilter[])new QFilter[]{filter});
            QFilter groupFilter = new QFilter("group", "=", asstcatType.get("assistanttype"));
            QFilter[] filters = new QFilter[]{groupFilter, idOrNameFilter = asstcatMsgId == null || asstcatMsgId.length() == 0 ? new QFilter("name", "=", (Object)asstcatMsgName) : new QFilter("id", "=", (Object)Long.parseLong(asstcatMsgId))};
            DynamicObjectCollection asstactNames = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"id,name,number", (QFilter[])filters);
            if (asstactNames == null) {
                return flexfieldAndid;
            }
            if (asstactNames.size() == 1) {
                flexfieldAndid.put(((DynamicObject)asstactNames.get(0)).getLong("id"), asstcatType.getString("flexfield"));
            } else {
                for (DynamicObject asstact : asstactNames) {
                    flexfieldAndid.put(asstact.getLong("id"), asstact.getString("name"));
                }
            }
        } else {
            QFilter filter = new QFilter("name", "=", (Object)typeName);
            DynamicObject asstcatType = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"valuesource,flexfield", (QFilter[])new QFilter[]{filter});
            QFilter nameOrIdFilter = asstcatMsgId == null || asstcatMsgId.length() == 0 ? new QFilter("name", "=", (Object)asstcatMsgName) : new QFilter("id", "=", (Object)Long.parseLong(asstcatMsgId));
            DynamicObjectCollection asstactNames = QueryServiceHelper.query((String)asstcatType.getString("valuesource"), (String)"id,name,number", (QFilter[])new QFilter[]{nameOrIdFilter});
            if (asstactNames == null) {
                return flexfieldAndid;
            }
            if (asstactNames.size() == 1) {
                flexfieldAndid.put(((DynamicObject)asstactNames.get(0)).getLong("id"), asstcatType.getString("flexfield"));
            } else {
                for (DynamicObject asstact : asstactNames) {
                    flexfieldAndid.put(asstact.getLong("id"), asstact.getString("name"));
                }
            }
        }
        return flexfieldAndid;
    }

    public Map<Long, Map<Long, String>> getAiasstactType(Object asstactTypeName, DynamicObject targetConfig) {
        DynamicObjectCollection asstactTypes = targetConfig.getDynamicObjectCollection("asstacttype");
        if (asstactTypes == null || asstactTypes.size() == 0) {
            asstactTypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id,valuesource", null);
        }
        HashMap<Long, Map<Long, String>> asstMap = new HashMap<Long, Map<Long, String>>();
        for (DynamicObject dyn : asstactTypes) {
            QFilter qf;
            String valuesource = dyn.getString("valuesource");
            DynamicObjectCollection querys = QueryServiceHelper.query((String)valuesource, (String)"id,name", (QFilter[])new QFilter[]{qf = new QFilter("name", "like", asstactTypeName)});
            if (querys == null || querys.size() == 0) continue;
            HashMap<Long, String> assts = new HashMap<Long, String>();
            for (DynamicObject dyn2 : querys) {
                assts.put(dyn2.getLong("id"), dyn2.getString("name"));
            }
            asstMap.put(dyn.getLong("id"), assts);
        }
        return asstMap;
    }

    public BigDecimal getRate(Map<String, Object> searchProp, String source, int yearInt, int periodInt, int yearInt1, int periodInt1) {
        Map<Object, Object> backData1 = new HashMap();
        Map<Object, Object> backData2 = new HashMap();
        BigDecimal backData = new BigDecimal(0);
        backData1 = this.getData(searchProp, source, yearInt, periodInt);
        try {
            backData2 = this.getData(searchProp, source, yearInt1, periodInt1);
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            if (errorMsg != null && errorMsg.contains("AIFS")) {
                backData2 = new HashMap();
            }
            throw e;
        }
        if (backData1.isEmpty() && !backData2.isEmpty()) {
            return null;
        }
        if (!backData1.isEmpty() && backData2.isEmpty()) {
            backData = new BigDecimal(100);
        } else {
            if (backData1.isEmpty() && backData2.isEmpty()) {
                return null;
            }
            BigDecimal one = (BigDecimal)backData1.get("data");
            BigDecimal two = (BigDecimal)backData2.get("data");
            backData = one.divide(two, 5, RoundingMode.HALF_UP).subtract(BigDecimal.ONE).multiply(new BigDecimal(100));
            backData = backData.setScale(2, RoundingMode.HALF_UP);
        }
        return backData;
    }

    public String getCurrencySign(String number) {
        QFilter idf = new QFilter("number", "=", (Object)number);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_currency", (String)"sign", (QFilter[])new QFilter[]{idf});
        return dyn.getString("sign");
    }

    public Map<String, Object> getData(Map<String, Object> searchProp, String source, int year, int period) {
        Map data;
        if (source.equals("1")) {
            searchProp.put("year", year);
            searchProp.put("period", period);
            data = new GlPickNumber().SearchData(searchProp);
        } else {
            QFilter F1 = new QFilter("name", "=", (Object)String.format(ResManager.loadKDString((String)"%1$s\u6708", (String)"PaserAiCommand_22", (String)"fi-aifs-formplugin", (Object[])new Object[0]), String.valueOf(period)));
            QFilter F2 = new QFilter("model", "=", (Object)Long.parseLong(String.valueOf(searchProp.get("model"))));
            DynamicObject dyObject1 = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"number,id,name", (QFilter[])new QFilter[]{F1, F2});
            this.checkNull(dyObject1, ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u672a\u542f\u7528\u8be5\u62a5\u8868\u671f\u95f4", (String)"PaserAiCommand_23", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
            searchProp.put("period", dyObject1.getString("id"));
            F1 = new QFilter("name", "=", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5e74", (String)"PaserAiCommand_31", (String)"fi-aifs-formplugin", (Object[])new Object[0]), String.valueOf(year)));
            DynamicObject dyObject2 = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"number,id,name", (QFilter[])new QFilter[]{F1, F2});
            this.checkNull(dyObject2, ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u672a\u542f\u7528\u8be5\u62a5\u8868\u8d22\u5e74", (String)"PaserAiCommand_24", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
            searchProp.put("year", dyObject2.getString("id"));
            data = BcmPickNumber.pickNumber(searchProp);
        }
        return data;
    }

    public DynamicObject matchOrg(String orgName, String source, String modelId) {
        DynamicObject org = null;
        QFilter q1 = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter q2 = new QFilter("view.treetype", "=", (Object)"10");
        QFilter q4 = new QFilter("org.name", "=", (Object)orgName);
        org = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id as viewid,org.id as id,org.number as number,org.name as name,view.treetype", (QFilter[])new QFilter[]{q1, q2, q4});
        if (source.equals("2")) {
            q1 = new QFilter("name", "=", (Object)orgName);
            q2 = new QFilter("model", "=", (Object)Long.parseLong(modelId));
            QFilter q3 = new QFilter("storagetype", "!=", (Object)"3");
            org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"name,id,number,storagetype", (QFilter[])new QFilter[]{q1, q2, q3});
        }
        return org;
    }

    public boolean checkAccrualAndBalance(int type, Map<String, Object> searchProp) {
        String sourse = (String)searchProp.get("numbersource");
        boolean done = false;
        if (sourse.equals("1")) {
            String accrual = (String)searchProp.get("accrual");
            String balance = (String)searchProp.get("balance");
            if (type == 1 && !accrual.equals("7")) {
                searchProp.put("fetchType", accrual);
                done = true;
            }
            if (type == 2 && !balance.equals("7")) {
                searchProp.put("fetchType", balance);
                done = true;
            }
            if (type == 3) {
                if (accrual.equals("1")) {
                    searchProp.put("fetchType", "3");
                } else if (accrual.equals("2")) {
                    searchProp.put("fetchType", "4");
                }
            }
        } else {
            Long reportaccrual = (Long)searchProp.get("reportaccrual");
            Long reportbalance = (Long)searchProp.get("reportbalance");
            if (reportaccrual != null && reportaccrual != 0L && type == 1) {
                searchProp.put("changetype", reportaccrual);
                done = true;
            }
            if (reportbalance != null && reportbalance != 0L && type == 2) {
                searchProp.put("changetype", reportbalance);
                done = true;
            }
            if (type == 3) {
                Long modelId = (Long)searchProp.get("model");
                QFilter qModel = new QFilter("model", "=", (Object)modelId);
                DynamicObject changeType = QueryServiceHelper.queryOne((String)"bcm_changetypemembertree", (String)"name,number", (QFilter[])new QFilter[]{qModel, new QFilter("id", "=", (Object)reportaccrual)});
                String accrualNum = changeType.getString("number");
                if (accrualNum.equals("CurrentPeriod")) {
                    QFilter qType = new QFilter("storagetype", "!=", (Object)"3");
                    changeType = QueryServiceHelper.queryOne((String)"bcm_changetypemembertree", (String)"name,number,id", (QFilter[])new QFilter[]{qModel, qType, new QFilter("number", "=", (Object)"YTD")});
                    searchProp.put("changetype", changeType.get("id"));
                } else {
                    searchProp.put("changetype", reportaccrual);
                }
            }
        }
        return done;
    }

    public int[] matchYearAndPeriod(String year, String period) {
        Calendar nowDate = Calendar.getInstance();
        int nowMonth = nowDate.get(2) + 1;
        int[] backData = new int[2];
        int nowYear = nowDate.get(1);
        if (year != null && !year.equals("")) {
            switch (year) {
                case "\u4eca\u5e74": 
                case "\u672c\u5e74": {
                    break;
                }
                case "\u53bb\u5e74": {
                    --nowYear;
                    break;
                }
                case "\u524d\u5e74": {
                    nowYear -= 2;
                    break;
                }
                case "\u5927\u524d\u5e74": {
                    nowYear -= 3;
                    break;
                }
                default: {
                    try {
                        nowYear = AifsUtil.getIntByString((String)year);
                        break;
                    }
                    catch (Exception e) {
                        throw new KDBizException(ResManager.loadKDString((String)"AIFS\u5e74\u4efd\u683c\u5f0f\u9519\u8bef", (String)"PaserAiCommand_25", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
        if (period == null) {
            period = ResManager.loadKDString((String)"\u672c\u6708", (String)"PaserAiCommand_26", (String)"fi-aifs-formplugin", (Object[])new Object[0]);
        }
        switch (period) {
            case "\u672c\u6708": 
            case "\u8fd9\u4e2a\u6708": {
                break;
            }
            case "\u4e0a\u6708": 
            case "\u4e0a\u4e2a\u6708": 
            case "\u4e0a\u4e00\u4e2a\u6708": 
            case "\u524d\u4e00\u4e2a\u6708": {
                if (nowMonth == 1) {
                    nowMonth = 12;
                }
                break;
            }
            default: {
                try {
                    nowMonth = AifsUtil.getIntByString((String)period);
                    break;
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"AIFS\u6708\u4efd\u683c\u5f0f\u9519\u8bef", (String)"PaserAiCommand_27", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
                }
            }
        }
        backData[0] = --nowYear;
        backData[1] = --nowMonth;
        return backData;
    }

    public void checkNull(Object oj, String message) {
        if (oj == null || oj.equals("")) {
            throw new KDBizException("AIFS" + message);
        }
    }

    public List<String> checkType(String rate) {
        ArrayList<String> targetTypes = new ArrayList<String>();
        targetTypes.add(ResManager.loadKDString((String)"\u4f59\u989d", (String)"PaserAiCommand_12", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        targetTypes.add(ResManager.loadKDString((String)"\u5b9e\u9645\u6570", (String)"PaserAiCommand_11", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        if ("3567".contains(rate)) {
            targetTypes.add(ResManager.loadKDString((String)"\u5e74\u589e\u957f\u7387", (String)"PaserAiCommand_15", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        if ("1457".contains(rate)) {
            targetTypes.add(ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f", (String)"PaserAiCommand_28", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        if ("2467".contains(rate)) {
            targetTypes.add(ResManager.loadKDString((String)"\u73af\u6bd4\u589e\u957f", (String)"PaserAiCommand_29", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
        return targetTypes;
    }

    public Map<String, List<Object>> packParameters(DynamicObjectCollection parameters, Object[] allField) {
        HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
        for (DynamicObject p : parameters) {
            for (Object key : allField) {
                String keyStr = (String)key;
                if (!data.containsKey(key)) {
                    data.put(keyStr, new ArrayList());
                    continue;
                }
                List valus = (List)data.get(key);
                if (valus.contains(p.get(keyStr))) continue;
                valus.add(p.get(keyStr));
            }
        }
        return data;
    }

    public String changeDataDisplay(BigDecimal data) {
        DecimalFormat fm = new DecimalFormat("#,###");
        data = data.setScale(0, RoundingMode.DOWN);
        int size = data.precision();
        String unit = ResManager.loadKDString((String)"\u5343\u5143", (String)"PaserAiCommand_30", (String)"fi-aifs-formplugin", (Object[])new Object[0]);
        if (size < 4) {
            fm = new DecimalFormat("#,###.##");
            data = data.divide(new BigDecimal(1000));
        } else {
            data = data.divide(new BigDecimal(1000), 2, RoundingMode.HALF_UP);
        }
        return fm.format(data) + unit;
    }

    public boolean ifPermOrg(String uid, String appId, long orgId) {
        List allPermOrgIds;
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(uid), (String)appId, (String)"aifs_targetset", (String)"47150e89000000ac");
        return permOrgRs.hasAllOrgPerm() || (allPermOrgIds = permOrgRs.getHasPermOrgs()).contains(orgId);
    }

    public void recordQueryInformation(long userId, int yearMounth, String targetName) {
        QFilter userQf = new QFilter("creator", "=", (Object)userId);
        QFilter yearMounthQf = new QFilter("yearmonth", "=", (Object)yearMounth);
        QFilter targetNameQf = new QFilter("name", "=", (Object)targetName);
        QFilter[] filters = new QFilter[]{userQf, yearMounthQf, targetNameQf};
        DynamicObject targetInfo = BusinessDataServiceHelper.loadSingle((String)"aifs_queryrecord", (String)"times", (QFilter[])filters);
        if (targetInfo == null) {
            targetInfo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"aifs_queryrecord"));
            targetInfo.set("name", (Object)targetName);
            targetInfo.set("creator", (Object)userId);
            targetInfo.set("yearmonth", (Object)yearMounth);
            targetInfo.set("times", (Object)1);
            targetInfo.set("createtime", (Object)new Date());
        } else {
            int times = targetInfo.getInt("times");
            targetInfo.set("times", (Object)(++times));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetInfo});
    }
}

