/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aifs.formplugin.picknumber;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aifs.business.picknumber.BcmServiceHelper;

public class ReportPickNumberRule
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final List<String> dimKeys = new ArrayList<String>(Arrays.asList("account", "scenario", "currency", "process", "reportaccrual", "reportbalance", "internalcompany", "multigaap", "audittrail", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6"));

    public void initialize() {
        super.initialize();
        for (String key : dimKeys) {
            BasedataEdit base = (BasedataEdit)this.getControl(key);
            if (base == null) continue;
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit modeledit = (BasedataEdit)this.getControl("model");
        modeledit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reportsave", "reportexit"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject temp = this.getModel().getDataEntity();
        if (temp.getDynamicObject("model") == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"multigaap", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "internalcompany"});
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObject temp = model.getDataEntity();
        if (temp.getDynamicObject("model") != null && temp.getString("numbersource").equals("2")) {
            Long modelid = temp.getDynamicObject("model").getLong("id");
            this.setDimensionFilter(modelid);
            this.getView().setVisible(Boolean.FALSE, new String[]{"multigaap", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "internalcompany"});
            String number = temp.getString("number");
            QFilter modelqfilter = new QFilter("number", "=", (Object)number);
            DynamicObjectCollection dimenvalue = QueryServiceHelper.query((String)"aifs_targetset", (String)"account,scenario,currency,process,reportaccrual,reportbalance,internalcompany,multigaap,audittrail,userdefined1,userdefined2,userdefined3,userdefined4,userdefined5,userdefined6", (QFilter[])new QFilter[]{modelqfilter});
            DynamicObject dimen = (DynamicObject)dimenvalue.get(0);
            for (String key : dimKeys) {
                if (dimen.getLong(key) == 0L) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{key});
                model.setValue(key, (Object)dimen.getLong(key));
            }
            DynamicObject accrual = (DynamicObject)model.getValue("reportaccrual");
            if (accrual.get("number").equals("YTD")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"yoygrow", "momgrow"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject accrual;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        DynamicObject temp = model.getDataEntity();
        if (e.getProperty().getName().equals("numbersource") && model.getValue("numbersource").equals("2")) {
            model.setValue("yeargrow", (Object)Boolean.FALSE);
            model.setValue("yoygrow", (Object)Boolean.FALSE);
            model.setValue("momgrow", (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"yeargrow", "yoygrow", "momgrow"});
            if (model.getValue("reportaccrual") != null) {
                accrual = (DynamicObject)model.getValue("reportaccrual");
                if (accrual.get("number").equals("CurrentPeriod")) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"yeargrow", "yoygrow", "momgrow"});
                } else if (accrual.get("number").equals("YTD")) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"yeargrow"});
                }
            }
        }
        if (temp.getString("numbersource").equals("2")) {
            if (temp.getDynamicObject("model") != null && e.getProperty().getName().equals("model")) {
                Long modelId = (Long)temp.getDynamicObject("model").get("id");
                this.getView().setVisible(Boolean.FALSE, new String[]{"multigaap", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6", "internalcompany"});
                for (String key : dimKeys) {
                    model.setValue(key, null);
                }
                model.setValue("yeargrow", (Object)Boolean.FALSE);
                model.setValue("yoygrow", (Object)Boolean.FALSE);
                model.setValue("momgrow", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"yeargrow", "yoygrow", "momgrow"});
                this.setDimension(modelId);
            }
            if (e.getProperty().getName().equals("reportaccrual") && model.getValue("reportaccrual") != null) {
                model.setValue("yeargrow", (Object)Boolean.FALSE);
                model.setValue("yoygrow", (Object)Boolean.FALSE);
                model.setValue("momgrow", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"yeargrow", "yoygrow", "momgrow"});
                accrual = (DynamicObject)model.getValue("reportaccrual");
                if (accrual.get("number").equals("CurrentPeriod")) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"yeargrow", "yoygrow", "momgrow"});
                } else if (accrual.get("number").equals("YTD")) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"yeargrow"});
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals("model")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            BasedataEdit base = (BasedataEdit)this.getControl("model");
            ArrayList qFilterList = base.getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            String filter = BcmServiceHelper.getModelFilter();
            List modelQFilters = (List)SerializationUtils.deSerializeFromBase64((String)filter);
            qFilterList.addAll(modelQFilters);
            base.setQFilters(qFilterList);
            showParameter.setListFilterParameter(new ListFilterParameter(modelQFilters, null));
        } else if (this.getModel().getValue("model") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ReportPickNumberRule_0", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
        }
    }

    private void setDimension(Long modelid) {
        IDataModel model = this.getModel();
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection dimencol = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,issysdimension,name,membermodel,shortnumber", (QFilter[])new QFilter[]{modelqfilter});
        int i = 1;
        for (DynamicObject dot : dimencol) {
            DynamicObject memberobj;
            DynamicObjectCollection intercol;
            String number = dot.getString("number");
            if (number != null && number.equals("Entity") && number.equals("Period") && number.equals("Year")) continue;
            boolean issysdimension = dot.getBoolean("issysdimension");
            boolean visible = true;
            String key = "";
            if (!issysdimension) {
                key = "userdefined" + i;
                ++i;
            } else if (number != null && (key = number.toLowerCase(Locale.ENGLISH)).equals("internalcompany") && (intercol = QueryServiceHelper.query((String)"bcm_intercompanymember", (String)"*", (QFilter[])new QFilter[]{modelqfilter})).size() == 4) {
                visible = false;
            }
            if (key.equals("changetype")) {
                BasedataEdit base1 = (BasedataEdit)this.getControl("reportaccrual");
                BasedataEdit base2 = (BasedataEdit)this.getControl("reportbalance");
                base1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d1\u751f\u989d", (String)"ReportPickNumberRule_1", (String)"fi-aifs-formplugin", (Object[])new Object[0])));
                base2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"ReportPickNumberRule_2", (String)"fi-aifs-formplugin", (Object[])new Object[0])));
                QFilter dfilter = new QFilter("dimension", "=", dot.get("id"));
                ArrayList<String> list1 = new ArrayList<String>();
                ArrayList<String> list2 = new ArrayList<String>();
                list1.add("CurrentPeriod");
                list1.add("YTD");
                QFilter filter1 = new QFilter("number", "in", list1);
                list2.add("EndingBalance");
                list2.add("BOP");
                QFilter filter2 = new QFilter("number", "in", list2);
                ArrayList<QFilter> fl1 = new ArrayList<QFilter>();
                fl1.add(dfilter);
                fl1.add(filter1);
                base1.setQFilters(fl1);
                ArrayList<QFilter> fl2 = new ArrayList<QFilter>();
                fl2.add(dfilter);
                fl2.add(filter2);
                base2.setQFilters(fl2);
                model.setValue("reportaccrual", null);
                model.setValue("reportbalance", null);
                this.getView().updateView("reportaccrual");
                this.getView().updateView("reportbalance");
                LocaleString name1 = new LocaleString(ResManager.loadKDString((String)"\u53d1\u751f\u989d", (String)"ReportPickNumberRule_1", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
                LocaleString name2 = new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"ReportPickNumberRule_2", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
                base1.setCaption(name1);
                base2.setCaption(name2);
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{key});
            BasedataEdit base = (BasedataEdit)this.getControl(key);
            if (base == null) continue;
            LocaleString name = new LocaleString(dot.getString("name"));
            QFilter dimensionqfilter = new QFilter("dimension", "=", (Object)dot.getLong("id"));
            base.setQFilter(dimensionqfilter);
            base.setCaption(name);
            QFilter numberfilter = this.getNumberQfilter(key, dot.getString("shortnumber"));
            if (numberfilter == null || (memberobj = QueryServiceHelper.queryOne((String)dot.getString("membermodel"), (String)"id", (QFilter[])new QFilter[]{dimensionqfilter, numberfilter})) == null) continue;
            if (key.equals("account") || key.equals("changetype")) {
                model.setValue(key, null);
            } else {
                model.setValue(key, (Object)memberobj.getLong("id"));
            }
            this.getView().updateView(key);
        }
    }

    private QFilter getNumberQfilter(String key, String shortnumber) {
        QFilter qfilter = null;
        switch (key) {
            case "currency": {
                qfilter = new QFilter("number", "=", (Object)"CNY");
                break;
            }
            case "scenario": {
                qfilter = new QFilter("number", "=", (Object)"Actual");
                break;
            }
            case "process": {
                qfilter = new QFilter("number", "=", (Object)"IRpt");
                break;
            }
            case "audittrail": {
                qfilter = new QFilter("number", "=", (Object)"EntityInput");
                break;
            }
            case "multigaap": {
                qfilter = new QFilter("number", "=", (Object)"PRCGAAP");
                break;
            }
            case "internalcompany": {
                qfilter = new QFilter("number", "=", (Object)(shortnumber + "None"));
            }
        }
        if (key.startsWith("userdefined")) {
            qfilter = new QFilter("number", "=", (Object)(shortnumber + "None"));
        }
        return qfilter;
    }

    private void setDimensionFilter(Long modelid) {
        QFilter qfilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection dimencol = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,issysdimension,name", (QFilter[])new QFilter[]{qfilter});
        int i = 1;
        for (DynamicObject dot : dimencol) {
            String number = dot.getString("number");
            if (number != null && number.equals("Entity") && number.equals("Period") && number.equals("Year")) continue;
            boolean issysdimension = dot.getBoolean("issysdimension");
            String key = "";
            if (!issysdimension) {
                key = "userdefined" + i;
                ++i;
            } else if (number != null) {
                key = number.toLowerCase(Locale.ENGLISH);
            }
            QFilter dimensionqfilter = new QFilter("dimension", "=", dot.get("id"));
            if (key.equals("changetype")) {
                BasedataEdit base1 = (BasedataEdit)this.getControl("reportaccrual");
                BasedataEdit base2 = (BasedataEdit)this.getControl("reportbalance");
                ArrayList<String> list1 = new ArrayList<String>();
                ArrayList<String> list2 = new ArrayList<String>();
                list1.add("CurrentPeriod");
                list1.add("YTD");
                QFilter filter1 = new QFilter("number", "in", list1);
                list2.add("EndingBalance");
                list2.add("BOP");
                QFilter filter2 = new QFilter("number", "in", list2);
                ArrayList<QFilter> fl1 = new ArrayList<QFilter>();
                fl1.add(dimensionqfilter);
                fl1.add(filter1);
                base1.setQFilters(fl1);
                ArrayList<QFilter> fl2 = new ArrayList<QFilter>();
                fl2.add(dimensionqfilter);
                fl2.add(filter2);
                base2.setQFilters(fl2);
                LocaleString name1 = new LocaleString(ResManager.loadKDString((String)"\u53d1\u751f\u989d", (String)"ReportPickNumberRule_1", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
                LocaleString name2 = new LocaleString(ResManager.loadKDString((String)"\u4f59\u989d", (String)"ReportPickNumberRule_2", (String)"fi-aifs-formplugin", (Object[])new Object[0]));
                base1.setCaption(name1);
                base2.setCaption(name2);
                continue;
            }
            BasedataEdit base = (BasedataEdit)this.getControl(key);
            if (base == null) continue;
            base.setQFilter(dimensionqfilter);
            LocaleString name = new LocaleString(dot.getString("name"));
            base.setCaption(name);
        }
    }
}

